/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.base.BaseConfig;
import com.wuest.prefab.blocks.BlockCustomWall;
import com.wuest.prefab.blocks.BlockGrassSlab;
import com.wuest.prefab.blocks.BlockGrassStairs;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.gui.screens.GuiStructureScanner;
import com.wuest.prefab.network.message.ConfigSyncMessage;
import com.wuest.prefab.network.message.PlayerEntityTagMessage;
import com.wuest.prefab.structures.gui.GuiStructure;
import com.wuest.prefab.structures.items.StructureItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1933;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_638;

public class ClientModRegistry {
    public static EntityPlayerConfiguration playerConfig = new EntityPlayerConfiguration();
    public static class_304 keyBinding;
    public static ArrayList<StructureScannerConfig> structureScanners;
    public static HashMap<StructureItem, GuiStructure> ModGuis;

    public static void registerModComponents() {
        ClientModRegistry.registerKeyBindings();
        ClientModRegistry.registerBlockLayers();
        ClientModRegistry.registerServerToClientMessageHandlers();
        ClientModRegistry.RegisterGuis();
    }

    public static void openGuiForItem(class_1838 itemUseContext) {
        for (Map.Entry<StructureItem, GuiStructure> entry : ModGuis.entrySet()) {
            if (entry.getKey() != itemUseContext.method_8041().method_7909()) continue;
            GuiStructure screen = entry.getValue();
            screen.pos = itemUseContext.method_8037();
            class_310.method_1551().method_1507((class_437)screen);
        }
    }

    public static void openGuiForBlock(class_2338 blockPos, class_1937 world, BaseConfig config) {
        GuiStructureScanner screen = null;
        if (config instanceof StructureScannerConfig) {
            screen = new GuiStructureScanner(blockPos, world, (StructureScannerConfig)config);
        }
        if (screen != null) {
            class_310.method_1551().method_1507(screen);
        }
    }

    private static void registerServerToClientMessageHandlers() {
        ClientSidePacketRegistry.INSTANCE.register(ModRegistry.ConfigSync, (packetContext, attachedData) -> {
            ConfigSyncMessage syncMessage = ConfigSyncMessage.decode(attachedData);
            packetContext.getTaskQueue().execute(() -> Prefab.serverConfiguration.readFromTag(syncMessage.getMessageTag()));
        });
        ClientSidePacketRegistry.INSTANCE.register(ModRegistry.PlayerConfigSync, (packetContext, attachedData) -> {
            PlayerEntityTagMessage syncMessage = PlayerEntityTagMessage.decode(attachedData);
            packetContext.getTaskQueue().execute(() -> {
                UUID playerUUID = class_310.method_1551().field_1724.method_5667();
                playerConfig = EntityPlayerConfiguration.loadFromTag(playerUUID, syncMessage.getMessageTag());
            });
        });
    }

    private static void registerBlockLayers() {
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.GlassStairs, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.GlassSlab, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.PaperLantern, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.Boundary, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.Phasic, class_1921.method_23583());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.GrassStairs, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.DirtStairs, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.GrassSlab, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.DirtSlab, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.GrassWall, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock((class_2248)ModRegistry.DirtWall, class_1921.method_23579());
    }

    public static void RegisterBlockRenderer() {
        class_310.method_1551().method_1505().method_1690((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? class_1163.method_4962((class_1920)worldIn, (class_2338)pos) : class_1933.method_8377((double)0.5, (double)1.0), new class_2248[]{ModRegistry.GrassWall, ModRegistry.GrassSlab, ModRegistry.GrassStairs});
        class_310.method_1551().field_1760.method_1708((stack, tintIndex) -> {
            class_1792 item = stack.method_7909();
            if (item instanceof class_1747) {
                class_1747 itemBlock = (class_1747)item;
                boolean paintBlock = false;
                if (itemBlock.method_7711() instanceof BlockCustomWall) {
                    BlockCustomWall customWall = (BlockCustomWall)itemBlock.method_7711();
                    if (customWall.BlockVariant == BlockCustomWall.EnumType.GRASS) {
                        paintBlock = true;
                    }
                } else if (itemBlock.method_7711() instanceof BlockGrassSlab) {
                    paintBlock = true;
                } else if (itemBlock.method_7711() instanceof BlockGrassStairs) {
                    paintBlock = true;
                }
                if (paintBlock) {
                    class_2338 pos = class_310.method_1551().field_1724.method_24515();
                    class_638 world = class_310.method_1551().field_1687;
                    return class_1163.method_4962((class_1920)world, (class_2338)pos);
                }
            }
            return -1;
        }, (class_1935[])new class_2248[]{ModRegistry.GrassWall, ModRegistry.GrassSlab, ModRegistry.GrassStairs});
    }

    private static void RegisterGuis() {
        for (Consumer<Object> consumer : ModRegistry.guiRegistrations) {
            consumer.accept(null);
        }
    }

    private static void registerKeyBindings() {
        keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("Build Current Structure", class_3675.class_307.field_1668, 66, "Prefab - Structure Preview"));
    }

    static {
        ModGuis = new HashMap();
        structureScanners = new ArrayList();
    }
}

