/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.blocks;

import com.wuest.prefab.Prefab;
import com.wuest.prefab.events.ServerEvents;
import java.util.ArrayList;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3614;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class BlockPhasic
extends class_2248 {
    private static final class_2754<EnumPhasingProgress> Phasing_Progress = class_2754.method_11850((String)"phasic_progress", EnumPhasingProgress.class);
    private static final class_2746 Phasing_Out = class_2746.method_11825((String)"phasing_out");
    private int tickRate = 2;

    public BlockPhasic() {
        super(class_4970.class_2251.method_9637((class_3614)Prefab.SeeThroughImmovable).method_9626(class_2498.field_11544).method_9632(0.6f).method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)Phasing_Out, (Comparable)Boolean.valueOf(false))).method_11657(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{Phasing_Out, Phasing_Progress});
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 rayTrace) {
        EnumPhasingProgress progress;
        if (!world.field_9236 && (progress = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress))) == EnumPhasingProgress.base) {
            world.method_8397().method_8676(pos, (Object)this, this.tickRate);
        }
        return class_1269.field_5812;
    }

    public class_2680 method_9605(class_1750 context) {
        boolean poweredSide = context.method_8045().method_8479(context.method_8037());
        if (poweredSide) {
            this.updateNeighborPhasicBlocks(true, context.method_8045(), context.method_8037(), this.method_9564(), false, false);
        }
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)Phasing_Out, (Comparable)Boolean.valueOf(poweredSide))).method_11657(Phasing_Progress, (Comparable)((Object)EnumPhasingProgress.base));
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        EnumPhasingProgress currentState = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress));
        super.method_9576(world, pos, state, player);
        ServerEvents.RedstoneAffectedBlockPositions.remove(pos);
        boolean poweredSide = world.method_8479(pos);
        if (poweredSide && currentState == EnumPhasingProgress.transparent) {
            this.updateNeighborPhasicBlocks(false, world, pos, state, false, false);
        }
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 blockIn, class_2338 p_189540_5_, boolean p_220069_6_) {
        if (!worldIn.field_9236 && blockIn.method_9564().method_26219()) {
            boolean poweredSide = worldIn.method_8479(pos);
            EnumPhasingProgress currentState = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress));
            boolean setToTransparent = false;
            if (poweredSide && currentState == EnumPhasingProgress.base) {
                setToTransparent = true;
            }
            if (currentState == EnumPhasingProgress.base || currentState == EnumPhasingProgress.transparent) {
                this.updateNeighborPhasicBlocks(setToTransparent, worldIn, pos, state, true, true);
            }
        }
    }

    public void method_9588(class_2680 state, class_3218 worldIn, class_2338 pos, Random random) {
        int updatedMeta;
        int tickDelay = this.tickRate;
        if (ServerEvents.RedstoneAffectedBlockPositions.contains(pos)) {
            return;
        }
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress));
        boolean phasingOut = (Boolean)state.method_11654((class_2769)Phasing_Out);
        if (progress == EnumPhasingProgress.base) {
            for (class_2350 facing : class_2350.values()) {
                class_2248 currentBlock = worldIn.method_8320(pos.method_10093(facing)).method_26204();
                if (!(currentBlock instanceof BlockPhasic) || ServerEvents.RedstoneAffectedBlockPositions.contains(pos.method_10093(facing))) continue;
                worldIn.method_14196().method_8676(pos.method_10093(facing), (Object)currentBlock, tickDelay);
            }
            phasingOut = true;
        }
        if ((updatedMeta = progress.getMeta()) == EnumPhasingProgress.eighty_percent.getMeta() && phasingOut) {
            tickDelay = 100;
        }
        if (updatedMeta == EnumPhasingProgress.transparent.getMeta() && phasingOut) {
            phasingOut = false;
        }
        if (updatedMeta == EnumPhasingProgress.twenty_percent.getMeta() && !phasingOut) {
            tickDelay = -1;
        }
        updatedMeta = phasingOut ? updatedMeta + 2 : updatedMeta - 2;
        progress = EnumPhasingProgress.ValueOf(updatedMeta);
        state = (class_2680)((class_2680)state.method_11657((class_2769)Phasing_Out, (Comparable)Boolean.valueOf(phasingOut))).method_11657(Phasing_Progress, (Comparable)((Object)progress));
        worldIn.method_8501(pos, state);
        if (tickDelay > 0) {
            worldIn.method_14196().method_8676(pos, (Object)this, tickDelay);
        }
    }

    public class_2464 method_9604(class_2680 state) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress));
        return progress != EnumPhasingProgress.transparent ? class_2464.field_11458 : class_2464.field_11455;
    }

    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress));
        return progress != EnumPhasingProgress.transparent ? class_259.method_1077() : class_259.method_1073();
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return class_259.method_1073();
        }
        return super.method_9549(state, worldIn, pos, context);
    }

    public class_265 method_9584(class_2680 state, class_1922 worldIn, class_2338 pos) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress));
        if (progress == EnumPhasingProgress.transparent) {
            return class_259.method_1073();
        }
        class_265 aabb = super.method_9584(state, worldIn, pos);
        return aabb;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_9522(class_2680 state, class_2680 adjacentBlockState, class_2350 side) {
        EnumPhasingProgress progress = (EnumPhasingProgress)((Object)state.method_11654(Phasing_Progress));
        return progress == EnumPhasingProgress.transparent;
    }

    protected void updateNeighborPhasicBlocks(boolean setToTransparent, class_1937 worldIn, class_2338 pos, class_2680 phasicBlockState, boolean setCurrentBlock, boolean triggeredByRedstone) {
        ArrayList<class_2338> blocksToUpdate = new ArrayList<class_2338>();
        class_2680 updatedBlockState = (class_2680)((class_2680)phasicBlockState.method_11657((class_2769)Phasing_Out, (Comparable)Boolean.valueOf(setToTransparent))).method_11657(Phasing_Progress, (Comparable)((Object)(setToTransparent ? EnumPhasingProgress.transparent : EnumPhasingProgress.base)));
        this.findNeighborPhasicBlocks(worldIn, pos, updatedBlockState, 0, blocksToUpdate, setCurrentBlock);
        for (class_2338 positionToUpdate : blocksToUpdate) {
            worldIn.method_8501(positionToUpdate, updatedBlockState);
            if (!triggeredByRedstone) continue;
            if (ServerEvents.RedstoneAffectedBlockPositions.contains(positionToUpdate) && !setToTransparent) {
                ServerEvents.RedstoneAffectedBlockPositions.remove(positionToUpdate);
                continue;
            }
            if (ServerEvents.RedstoneAffectedBlockPositions.contains(positionToUpdate) || !setToTransparent) continue;
            ServerEvents.RedstoneAffectedBlockPositions.add(positionToUpdate);
        }
    }

    private int findNeighborPhasicBlocks(class_1937 worldIn, class_2338 pos, class_2680 desiredBlockState, int cascadeCount, ArrayList<class_2338> cascadedBlockPos, boolean setCurrentBlock) {
        if (++cascadeCount > 100) {
            return cascadeCount;
        }
        if (setCurrentBlock) {
            cascadedBlockPos.add(pos);
        }
        for (class_2350 facing : class_2350.values()) {
            class_2248 neighborBlock = worldIn.method_8320(pos.method_10093(facing)).method_26204();
            if (!(neighborBlock instanceof BlockPhasic)) continue;
            class_2680 blockState = worldIn.method_8320(pos.method_10093(facing));
            EnumPhasingProgress progress = (EnumPhasingProgress)((Object)blockState.method_11654(Phasing_Progress));
            if (cascadedBlockPos.contains(pos.method_10093(facing)) || progress == desiredBlockState.method_11654(Phasing_Progress)) continue;
            setCurrentBlock = true;
            cascadeCount = this.findNeighborPhasicBlocks(worldIn, pos.method_10093(facing), desiredBlockState, cascadeCount, cascadedBlockPos, setCurrentBlock);
            if (cascadeCount > 100) break;
        }
        return cascadeCount;
    }

    public static enum EnumPhasingProgress implements class_3542
    {
        base(0, "base"),
        twenty_percent(2, "twenty_percent"),
        forty_percent(4, "forty_percent"),
        sixty_percent(6, "sixty_percent"),
        eighty_percent(8, "eighty_percent"),
        transparent(10, "transparent");

        private int meta;
        private String name;

        private EnumPhasingProgress(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumPhasingProgress ValueOf(int meta) {
            for (EnumPhasingProgress progress : EnumPhasingProgress.values()) {
                if (progress.meta != meta) continue;
                return progress;
            }
            return base;
        }

        public int getMeta() {
            return this.meta;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

