/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.config;

import com.wuest.prefab.config.ChestOptions;
import com.wuest.prefab.config.StarterHouseOptions;
import java.util.HashMap;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_2487;

@Config(name="Prefab")
public class ModConfiguration
implements ConfigData {
    @Comment(value="Item provided to new players when joining a world")
    public StartingItemOptions startingItem = StartingItemOptions.StartingHouse;
    @Comment(value="Enables the loft starter house")
    public boolean enableLoftHouse = false;
    @Comment(value="Add spawners to monster masher")
    public boolean includeSpawnersInMasher = true;
    @Comment(value="Enables preview buttons in screens")
    public boolean enableStructurePreview = true;
    @Comment(value="Bulldozer makes drops")
    public boolean allowBulldozerToCreateDrops = true;
    @Comment(value="Allow water in the End or Custom Dimensions")
    public boolean allowWaterInNonOverworldDimensions = true;
    @Comment(value="Enable Automation Options For Moderate Farm")
    public boolean enableAutomationOptionsFromModerateFarm = true;
    @Comment(value="Generated mineshafts have chests with materials")
    public boolean includeMineshaftChest = true;
    @ConfigEntry.Category(value="recipes")
    public HashMap<String, Boolean> recipes = new HashMap();
    @ConfigEntry.Category(value="chest_options")
    @ConfigEntry.Gui.TransitiveObject
    public ChestOptions chestOptions = new ChestOptions();
    @ConfigEntry.Category(value="starter_options")
    @ConfigEntry.Gui.TransitiveObject
    public StarterHouseOptions starterHouseOptions = new StarterHouseOptions();

    public ModConfiguration() {
        for (String key : ConfigKeyNames.Keys) {
            this.recipes.put(key, true);
        }
    }

    public class_2487 writeCompoundTag() {
        class_2487 tag = new class_2487();
        tag.method_10582(ConfigKeyNames.startingItemName, this.startingItem.toString());
        tag.method_10556(ConfigKeyNames.enableLoftHouseName, this.enableLoftHouse);
        tag.method_10556(ConfigKeyNames.includeSpawnersInMasherName, this.includeSpawnersInMasher);
        tag.method_10556(ConfigKeyNames.enableStructurePreviewName, this.enableStructurePreview);
        tag.method_10556(ConfigKeyNames.includeMineshaftChestName, this.includeMineshaftChest);
        tag.method_10556(ConfigKeyNames.allowBulldozerToCreateDropsName, this.allowBulldozerToCreateDrops);
        tag.method_10556(ConfigKeyNames.allowWaterInNonOverworldDimensionsName, this.allowWaterInNonOverworldDimensions);
        tag.method_10556(ConfigKeyNames.enableAutomationOptionsFromModerateFarmName, this.enableAutomationOptionsFromModerateFarm);
        tag.method_10556(ConfigKeyNames.addSwordName, this.chestOptions.addSword);
        tag.method_10556(ConfigKeyNames.addAxeName, this.chestOptions.addAxe);
        tag.method_10556(ConfigKeyNames.addShovelName, this.chestOptions.addShovel);
        tag.method_10556(ConfigKeyNames.addHoeName, this.chestOptions.addHoe);
        tag.method_10556(ConfigKeyNames.addPickAxeName, this.chestOptions.addPickAxe);
        tag.method_10556(ConfigKeyNames.addArmorName, this.chestOptions.addArmor);
        tag.method_10556(ConfigKeyNames.addFoodName, this.chestOptions.addFood);
        tag.method_10556(ConfigKeyNames.addCropsName, this.chestOptions.addCrops);
        tag.method_10556(ConfigKeyNames.addDirtName, this.chestOptions.addDirt);
        tag.method_10556(ConfigKeyNames.addCobbleName, this.chestOptions.addCobble);
        tag.method_10556(ConfigKeyNames.addSaplingsName, this.chestOptions.addSaplings);
        tag.method_10556(ConfigKeyNames.addTorchesName, this.chestOptions.addTorches);
        tag.method_10556(ConfigKeyNames.addBedName, this.starterHouseOptions.addBed);
        tag.method_10556(ConfigKeyNames.addCraftingTableName, this.starterHouseOptions.addCraftingTable);
        tag.method_10556(ConfigKeyNames.addFurnaceName, this.starterHouseOptions.addFurnace);
        tag.method_10556(ConfigKeyNames.addChestsName, this.starterHouseOptions.addChests);
        tag.method_10556(ConfigKeyNames.addChestContentsName, this.starterHouseOptions.addChestContents);
        tag.method_10556(ConfigKeyNames.addMineshaftName, this.starterHouseOptions.addMineshaft);
        for (Map.Entry<String, Boolean> entry : this.recipes.entrySet()) {
            tag.method_10556(entry.getKey(), entry.getValue().booleanValue());
        }
        return tag;
    }

    public void readFromTag(class_2487 tag) {
        this.startingItem = StartingItemOptions.getByName(tag.method_10558(ConfigKeyNames.startingItemName));
        this.enableLoftHouse = tag.method_10577(ConfigKeyNames.enableLoftHouseName);
        this.includeSpawnersInMasher = tag.method_10577(ConfigKeyNames.includeSpawnersInMasherName);
        this.enableStructurePreview = tag.method_10577(ConfigKeyNames.enableStructurePreviewName);
        this.includeMineshaftChest = tag.method_10577(ConfigKeyNames.includeMineshaftChestName);
        this.allowBulldozerToCreateDrops = tag.method_10577(ConfigKeyNames.allowBulldozerToCreateDropsName);
        this.allowWaterInNonOverworldDimensions = tag.method_10577(ConfigKeyNames.allowWaterInNonOverworldDimensionsName);
        this.enableAutomationOptionsFromModerateFarm = tag.method_10577(ConfigKeyNames.enableAutomationOptionsFromModerateFarmName);
        this.chestOptions.addSword = tag.method_10577(ConfigKeyNames.addSwordName);
        this.chestOptions.addAxe = tag.method_10577(ConfigKeyNames.addAxeName);
        this.chestOptions.addShovel = tag.method_10577(ConfigKeyNames.addShovelName);
        this.chestOptions.addHoe = tag.method_10577(ConfigKeyNames.addHoeName);
        this.chestOptions.addPickAxe = tag.method_10577(ConfigKeyNames.addPickAxeName);
        this.chestOptions.addArmor = tag.method_10577(ConfigKeyNames.addArmorName);
        this.chestOptions.addFood = tag.method_10577(ConfigKeyNames.addFoodName);
        this.chestOptions.addCrops = tag.method_10577(ConfigKeyNames.addCropsName);
        this.chestOptions.addDirt = tag.method_10577(ConfigKeyNames.addDirtName);
        this.chestOptions.addCobble = tag.method_10577(ConfigKeyNames.addCobbleName);
        this.chestOptions.addSaplings = tag.method_10577(ConfigKeyNames.addSaplingsName);
        this.chestOptions.addTorches = tag.method_10577(ConfigKeyNames.addTorchesName);
        this.starterHouseOptions.addBed = tag.method_10577(ConfigKeyNames.addBedName);
        this.starterHouseOptions.addCraftingTable = tag.method_10577(ConfigKeyNames.addCraftingTableName);
        this.starterHouseOptions.addFurnace = tag.method_10577(ConfigKeyNames.addFurnaceName);
        this.starterHouseOptions.addChests = tag.method_10577(ConfigKeyNames.addChestsName);
        this.starterHouseOptions.addChestContents = tag.method_10577(ConfigKeyNames.addChestContentsName);
        this.starterHouseOptions.addMineshaft = tag.method_10577(ConfigKeyNames.addMineshaftName);
        this.recipes.clear();
        for (String key : ConfigKeyNames.Keys) {
            this.recipes.put(key, tag.method_10577(key));
        }
    }

    public static enum StartingItemOptions {
        StartingHouse("Starting House"),
        ModerateHouse("Moderate House"),
        StructureParts("Structure Parts"),
        Nothing("Nothing");

        private final String name;

        private StartingItemOptions(String name) {
            this.name = name;
        }

        public static StartingItemOptions getByName(String name) {
            StartingItemOptions returnValue = Nothing;
            for (StartingItemOptions options : StartingItemOptions.values()) {
                if (!options.name.equals(name) && !options.name().equals(name)) continue;
                returnValue = options;
                break;
            }
            return returnValue;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ConfigKeyNames {
        public static String compressedStoneKey = "Compressed Stone";
        public static String compressedGlowStoneKey = "Compressed Glowstone";
        public static String compressedDirtKey = "Compressed Dirt";
        public static String compressedChestKey = "Compressed Chest";
        public static String pileOfBricksKey = "Pile of Bricks";
        public static String warehouseKey = "Warehouse";
        public static String warehouseUpgradeKey = "Warehouse Upgrade";
        public static String advancedWarehouseKey = "Advanced Warehouse";
        public static String bundleofTimberKey = "Bundle of Timber";
        public static String netherGateKey = "Nether Gate";
        public static String machineryTowerKey = "Machinery Tower";
        public static String defenseBunkerKey = "Defense Bunker";
        public static String mineshaftEntranceKey = "Mineshaft Entrance";
        public static String enderGatewayKey = "Ender Gateway";
        public static String aquaBaseKey = "Aqua Base";
        public static String grassyPlainsKey = "Grassy Plains";
        public static String magicTempleKey = "Magic Temple";
        public static String instantBridgeKey = "Instant Bridge";
        public static String paperLanternKey = "Paper Lantern";
        public static String compressedObsidianKey = "Compressed Obsidian";
        public static String villagerHousesKey = "Villager Houses";
        public static String phasicBlockKey = "Phasic Block";
        public static String smartGlassKey = "Boundary Block";
        public static String greenHouseKey = "Green House";
        public static String startingHouseKey = "Starting House";
        public static String glassStairsKey = "Glass Stairs";
        public static String glassSlabsKey = "Glass Slabs";
        public static String moderateHouseKey = "Moderate House";
        public static String watchTowerKey = "Watch Tower";
        public static String bulldozerKey = "Bulldozer";
        public static String jailKey = "Jail";
        public static String saloonKey = "Saloon";
        public static String skiLodgeKey = "Ski Lodge";
        public static String windMillKey = "Windmill";
        public static String townHallKey = "Town Hall";
        public static String heapOfTimberKey = "Heap of Timber";
        public static String tonOfTimberKey = "Ton of Timber";
        public static String workshopKey = "Workshop";
        public static String modernBuildingsKey = "Modern Buildings";
        public static String starterFarmKey = "Starter Farm";
        public static String moderateFarmKey = "Moderate Farm";
        public static String advancedFarmKey = "Advanced Farm";
        public static String swiftBladeKey = "Swift Blade";
        public static String sickleKey = "Sickle";
        public static String DirtRecipesKey = "Dirt Recipes";
        public static String BunchOfBeetsKey = "Bunch Of Beets";
        public static String BunchOfCarrotsKey = "Bunch Of Carrots";
        public static String BunchOfPotatoesKey = "Bunch Of Potatoes";
        public static String WoodenCrateKey = "WoodenCrate";
        public static String[] Keys = new String[]{compressedStoneKey, compressedGlowStoneKey, compressedDirtKey, compressedChestKey, pileOfBricksKey, warehouseKey, warehouseUpgradeKey, advancedWarehouseKey, bundleofTimberKey, netherGateKey, machineryTowerKey, defenseBunkerKey, mineshaftEntranceKey, enderGatewayKey, magicTempleKey, instantBridgeKey, paperLanternKey, compressedObsidianKey, villagerHousesKey, phasicBlockKey, smartGlassKey, greenHouseKey, startingHouseKey, glassStairsKey, glassSlabsKey, moderateHouseKey, grassyPlainsKey, aquaBaseKey, watchTowerKey, bulldozerKey, jailKey, saloonKey, skiLodgeKey, windMillKey, townHallKey, heapOfTimberKey, tonOfTimberKey, workshopKey, modernBuildingsKey, swiftBladeKey, sickleKey, DirtRecipesKey, BunchOfBeetsKey, BunchOfCarrotsKey, BunchOfPotatoesKey, WoodenCrateKey, starterFarmKey, moderateFarmKey, advancedFarmKey};
        static String enableLoftHouseName = "Enable Loft House";
        static String includeSpawnersInMasherName = "Include Spawners in Monster Masher";
        static String enableStructurePreviewName = "Include Structure Previews";
        static String includeMineshaftChestName = "Include Mineshaft Chest";
        static String enableAutomationOptionsFromModerateFarmName = "Enable Automation Options For Moderate Farm";
        static String allowBulldozerToCreateDropsName = "Bulldozer Creates Drops";
        static String allowWaterInNonOverworldDimensionsName = "Include Water In Overworld Dimension Only";
        static String addSwordName = "Add Sword";
        static String addAxeName = "Add Axe";
        static String addHoeName = "Add Hoe";
        static String addShovelName = "Add Shovel";
        static String addPickAxeName = "Add Pickaxe";
        static String addArmorName = "Add Armor";
        static String addFoodName = "Add Food";
        static String addCropsName = "Add Crops";
        static String addDirtName = "Add Dirt";
        static String addCobbleName = "Add Cobblestone";
        static String addSaplingsName = "Add Saplings";
        static String addTorchesName = "Add Torches";
        static String startingItemName = "Starting Item";
        static String addBedName = "Add Bed";
        static String addCraftingTableName = "Add Crafting Table";
        static String addFurnaceName = "Add Furnace";
        static String addChestsName = "Add Chests";
        static String addChestContentsName = "Add Chest Contents";
        static String addMineshaftName = "Add Mineshaft";
    }
}

