/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.gui.GuiUtils;
import com.wuest.prefab.gui.controls.CustomButton;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiCheckBox;
import com.wuest.prefab.gui.controls.GuiSlider;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public abstract class GuiBase
extends class_437 {
    private final class_2960 backgroundTextures = new class_2960("prefab", "textures/gui/default_background.png");
    private final class_2960 narrowPanelTexture = new class_2960("prefab", "textures/gui/custom_background.png");
    private final class_2960 leftPanelTexture = new class_2960("prefab", "textures/gui/custom_left_panel.png");
    private final class_2960 middlePanelTexture = new class_2960("prefab", "textures/gui/custom_middle_panel.png");
    private final class_2960 rightPanelTexture = new class_2960("prefab", "textures/gui/custom_right_panel.png");
    protected int modifiedInitialXAxis = 0;
    protected int modifiedInitialYAxis = 0;
    protected int imagePanelWidth = 0;
    protected int imagePanelHeight = 0;
    protected int shownImageHeight = 0;
    protected int shownImageWidth = 0;
    protected int textColor = Color.DARK_GRAY.getRGB();
    private boolean pauseGame = true;

    public GuiBase(String title) {
        super((class_2561)Utils.createTextComponent(title));
    }

    public void method_25426() {
        this.Initialize();
    }

    protected void Initialize() {
        this.modifiedInitialXAxis = 160;
        this.modifiedInitialYAxis = 120;
        this.imagePanelWidth = 325;
        this.imagePanelHeight = 300;
        this.shownImageHeight = 150;
        this.shownImageWidth = 268;
    }

    protected int getCenteredXAxis() {
        return this.field_22789 / 2;
    }

    protected int getCenteredYAxis() {
        return this.field_22790 / 2;
    }

    public boolean method_25421() {
        return this.pauseGame;
    }

    public void method_25394(class_4587 matrixStack, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(matrixStack, x, y);
        this.postButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text) {
        return this.createAndAddButton(x, y, width, height, text, true);
    }

    public ExtendedButton createAndAddButton(int x, int y, int width, int height, String text, boolean translate) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (class_2561)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked);
        return (ExtendedButton)this.method_37063((class_364)returnValue);
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text) {
        return this.createAndAddCustomButton(x, y, width, height, text, true);
    }

    public CustomButton createAndAddCustomButton(int x, int y, int width, int height, String text, boolean translate) {
        CustomButton returnValue = new CustomButton(x, y, width, height, (class_2561)(translate ? GuiLangKeys.translateToComponent(text) : Utils.createTextComponent(text)), this::buttonClicked);
        return (CustomButton)this.method_37063((class_364)returnValue);
    }

    public ExtendedButton createAndAddDyeButton(int x, int y, int width, int height, class_1767 color) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (class_2561)Utils.createTextComponent(GuiLangKeys.translateDye(color)), this::buttonClicked);
        return (ExtendedButton)this.method_37063((class_364)returnValue);
    }

    public ExtendedButton createAndAddFullDyeButton(int x, int y, int width, int height, FullDyeColor color) {
        ExtendedButton returnValue = new ExtendedButton(x, y, width, height, (class_2561)Utils.createTextComponent(GuiLangKeys.translateFullDye(color)), this::buttonClicked);
        return (ExtendedButton)this.method_37063((class_364)returnValue);
    }

    public GuiCheckBox createAndAddCheckBox(int xPos, int yPos, String displayString, boolean isChecked, GuiCheckBox.PressAction handler) {
        GuiCheckBox checkBox = new GuiCheckBox(xPos, yPos, GuiLangKeys.translateString(displayString), isChecked, handler);
        return (GuiCheckBox)this.method_37063((class_364)checkBox);
    }

    public GuiSlider createAndAddSlider(int xPos, int yPos, int width, int height, String prefix, String suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, class_4185.class_4241 handler) {
        GuiSlider slider = new GuiSlider(xPos, yPos, width, height, (class_2561)Utils.createTextComponent(prefix), (class_2561)Utils.createTextComponent(suf), minVal, maxVal, currentVal, showDec, drawStr, handler);
        return (GuiSlider)this.method_37063((class_364)slider);
    }

    protected void drawControlBackground(class_4587 matrixStack, int grayBoxX, int grayBoxY) {
        GuiUtils.bindAndDrawTexture(this.backgroundTextures, matrixStack, grayBoxX, grayBoxY, this.method_25305(), 256, 256, 256, 256);
    }

    protected void drawControlPanel(class_4587 matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.narrowPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlBackground(class_4587 matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.bindAndDrawScaledTexture(this.backgroundTextures, matrixStack, grayBoxX, grayBoxY, width, height, width, height, width, height);
    }

    protected void drawControlLeftPanel(class_4587 matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.leftPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlMiddlePanel(class_4587 matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.middlePanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawControlRightPanel(class_4587 matrixStack, int grayBoxX, int grayBoxY, int width, int height) {
        GuiUtils.drawContinuousTexturedBox(this.rightPanelTexture, grayBoxX, grayBoxY, 0, 0, width, height, 89, 233, 2, 2, 4, 4, 0.0f);
    }

    protected void drawStandardControlBoxAndImage(class_4587 matrixStack, class_2960 imageLocation, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(matrixStack);
        this.drawControlBackground(matrixStack, x, y, this.imagePanelWidth, this.imagePanelHeight);
        if (imageLocation != null) {
            int imagePanelMiddle = this.imagePanelWidth / 2;
            int middleOfImage = this.shownImageWidth / 2;
            int imagePos = x + (imagePanelMiddle - middleOfImage - 5);
            GuiUtils.bindAndDrawTexture(imageLocation, matrixStack, imagePos, y + 10, 1, this.shownImageWidth, this.shownImageHeight, this.shownImageWidth, this.shownImageHeight);
        }
    }

    protected void renderButtons(class_4587 matrixStack, int mouseX, int mouseY) {
        for (class_364 button : this.method_25396()) {
            class_364 class_3642 = button;
            if (!(class_3642 instanceof class_339)) continue;
            class_339 currentButton = (class_339)class_3642;
            if (!currentButton.field_22764) continue;
            currentButton.method_25359(matrixStack, mouseX, mouseY, this.field_22787.method_1488());
        }
    }

    protected Tuple<Integer, Integer> getAdjustedXYValue() {
        return new Tuple<Integer, Integer>(this.getCenteredXAxis() - this.modifiedInitialXAxis, this.getCenteredYAxis() - this.modifiedInitialYAxis);
    }

    public int drawString(class_4587 matrixStack, String text, float x, float y, int color) {
        return this.getMinecraft().field_1772.method_1729(matrixStack, text, x, y, color);
    }

    public void drawSplitString(String str, int x, int y, int wrapWidth, int textColor) {
        this.getMinecraft().field_1772.method_1712((class_5348)Utils.createTextComponent(str), x, y, wrapWidth, textColor);
    }

    public List<class_5481> getSplitString(String str, int wrapWidth) {
        return this.getMinecraft().field_1772.method_1728((class_5348)Utils.createTextComponent(str), wrapWidth);
    }

    public List<class_5481> getSplitString(class_5348 str, int wrapWidth) {
        return this.getMinecraft().field_1772.method_1728(str, wrapWidth);
    }

    public void closeScreen() {
        this.getMinecraft().method_1507(null);
    }

    public class_310 getMinecraft() {
        return this.field_22787;
    }

    public abstract void buttonClicked(class_4264 var1);

    protected abstract void preButtonRender(class_4587 var1, int var2, int var3, int var4, int var5, float var6);

    protected abstract void postButtonRender(class_4587 var1, int var2, int var3, int var4, int var5, float var6);
}

