/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.controls;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import org.jetbrains.annotations.Nullable;

public class GuiTextBox
extends class_339
implements class_4068,
class_364 {
    private final class_327 textRenderer;
    private String text = "";
    private int maxLength = 32;
    public int focusedTicks;
    public boolean drawsBackground = true;
    public boolean focusUnlocked = true;
    public boolean editable = true;
    public boolean selecting;
    public int firstCharacterIndex;
    public int selectionStart;
    public int selectionEnd;
    public int editableColor = 0xE0E0E0;
    public int uneditableColor = 0x707070;
    public int backgroundColor = Color.WHITE.getRGB();
    public boolean drawsTextShadow;
    @Nullable
    public String suggestion;
    @Nullable
    public Consumer<String> changedListener;
    public Predicate<String> textPredicate = Objects::nonNull;
    public BiFunction<String, Integer, class_5481> renderTextProvider = (string, integer) -> class_5481.method_30747((String)string, (class_2583)class_2583.field_24360);

    public GuiTextBox(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
        this(textRenderer, x, y, width, height, null, text);
    }

    public GuiTextBox(class_327 textRenderer, int x, int y, int width, int height, @Nullable class_342 copyFrom, class_2561 text) {
        super(x, y, width, height, text);
        this.textRenderer = textRenderer;
        if (copyFrom != null) {
            this.setText(copyFrom.method_1882());
        }
    }

    public void setChangedListener(Consumer<String> changedListener) {
        this.changedListener = changedListener;
    }

    public void setRenderTextProvider(BiFunction<String, Integer, class_5481> renderTextProvider) {
        this.renderTextProvider = renderTextProvider;
    }

    public void tick() {
        ++this.focusedTicks;
    }

    protected class_5250 method_25360() {
        class_2561 text = this.method_25369();
        return new class_2588("gui.narrate.editBox", new Object[]{text, this.text});
    }

    public void setText(String text) {
        if (this.textPredicate.test(text)) {
            this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.setCursorToEnd();
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(text);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void setTextPredicate(Predicate<String> textPredicate) {
        this.textPredicate = textPredicate;
    }

    public void write(String text) {
        String string2;
        String string;
        int l;
        int i = Math.min(this.selectionStart, this.selectionEnd);
        int j = Math.max(this.selectionStart, this.selectionEnd);
        int k = this.maxLength - this.text.length() - (i - j);
        if (k < (l = (string = class_155.method_644((String)text)).length())) {
            string = string.substring(0, k);
            l = k;
        }
        if (this.textPredicate.test(string2 = new StringBuilder(this.text).replace(i, j, string).toString())) {
            this.text = string2;
            this.setSelectionStart(i + l);
            this.setSelectionEnd(this.selectionStart);
            this.onChanged(this.text);
        }
    }

    private void onChanged(String newText) {
        if (this.changedListener != null) {
            this.changedListener.accept(newText);
        }
    }

    private void erase(int offset) {
        if (class_437.method_25441()) {
            this.eraseWords(offset);
        } else {
            this.eraseCharacters(offset);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                this.eraseCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.write("");
            } else {
                String string;
                int k;
                int i = this.getCursorPosWithOffset(characterOffset);
                int j = Math.min(i, this.selectionStart);
                if (j != (k = Math.max(i, this.selectionStart)) && this.textPredicate.test(string = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = string;
                    this.setCursor(j);
                }
            }
        }
    }

    public int getWordSkipPosition(int wordOffset) {
        return this.getWordSkipPosition(wordOffset, this.getCursor());
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition) {
        return this.getWordSkipPosition(wordOffset, cursorPosition, true);
    }

    private int getWordSkipPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipOverSpaces && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipOverSpaces && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int offset) {
        this.setCursor(this.getCursorPosWithOffset(offset));
    }

    private int getCursorPosWithOffset(int offset) {
        return class_156.method_27761((String)this.text, (int)this.selectionStart, (int)offset);
    }

    public void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    public void setSelectionStart(int cursor) {
        this.selectionStart = class_3532.method_15340((int)cursor, (int)0, (int)this.text.length());
    }

    public void setCursorToStart() {
        this.setCursor(0);
    }

    public void setCursorToEnd() {
        this.setCursor(this.text.length());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        this.selecting = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.setCursorToEnd();
            this.setSelectionEnd(0);
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            if (this.editable) {
                this.write(class_310.method_1551().field_1774.method_1460());
            }
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            if (this.editable) {
                this.write("");
            }
            return true;
        }
        switch (keyCode) {
            case 259: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(-1);
                    this.selecting = class_437.method_25442();
                }
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                if (this.editable) {
                    this.selecting = false;
                    this.erase(1);
                    this.selecting = class_437.method_25442();
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    this.setCursor(this.getWordSkipPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorToStart();
                return true;
            }
            case 269: 
        }
        this.setCursorToEnd();
        return true;
    }

    public boolean isActive() {
        return this.isVisible() && this.method_25370() && this.isEditable();
    }

    public boolean method_25400(char chr, int modifiers) {
        if (!this.isActive()) {
            return false;
        }
        if (class_155.method_643((char)chr)) {
            if (this.editable) {
                this.write(Character.toString(chr));
            }
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl2 = bl = mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
        if (this.focusUnlocked) {
            this.setTextFieldFocused(bl);
        }
        if (this.method_25370() && bl && button == 0) {
            int i = class_3532.method_15357((double)mouseX) - this.field_22760;
            if (this.drawsBackground) {
                i -= 4;
            }
            String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
            this.setCursor(this.textRenderer.method_27523(string, i).length() + this.firstCharacterIndex);
            return true;
        }
        return false;
    }

    public void setTextFieldFocused(boolean focused) {
        this.method_25365(focused);
    }

    public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            int var10004;
            int var10003;
            int var10002;
            int j;
            if (this.drawsBackground()) {
                j = this.method_25370() ? -1 : -6250336;
                GuiTextBox.method_25294((class_4587)matrices, (int)(this.field_22760 - 1), (int)(this.field_22761 - 1), (int)(this.field_22760 + this.field_22758 + 1), (int)(this.field_22761 + this.field_22759 + 1), (int)j);
                GuiTextBox.method_25294((class_4587)matrices, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)this.backgroundColor);
            }
            j = this.editable ? this.editableColor : this.uneditableColor;
            int k = this.selectionStart - this.firstCharacterIndex;
            int l = this.selectionEnd - this.firstCharacterIndex;
            String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), this.getInnerWidth());
            boolean bl = k >= 0 && k <= string.length();
            boolean bl2 = this.method_25370() && this.focusedTicks / 6 % 2 == 0 && bl;
            int m = this.drawsBackground ? this.field_22760 + 4 : this.field_22760;
            int n = this.drawsBackground ? this.field_22761 + (this.field_22759 - 8) / 2 : this.field_22761;
            int o = m;
            if (l > string.length()) {
                l = string.length();
            }
            if (!string.isEmpty()) {
                String string2 = bl ? string.substring(0, k) : string;
                o = !this.drawsTextShadow ? this.textRenderer.method_27528(matrices, this.renderTextProvider.apply(string2, this.firstCharacterIndex), (float)m, (float)n, j) : this.textRenderer.method_27517(matrices, this.renderTextProvider.apply(string2, this.firstCharacterIndex), (float)m, (float)n, j);
            }
            boolean bl3 = this.selectionStart < this.text.length() || this.text.length() >= this.getMaxLength();
            int p = o;
            if (!bl) {
                p = k > 0 ? m + this.field_22758 : m;
            } else if (bl3) {
                p = o - 1;
                --o;
            }
            if (!string.isEmpty() && bl && k < string.length()) {
                if (!this.drawsTextShadow) {
                    this.textRenderer.method_27528(matrices, this.renderTextProvider.apply(string.substring(k), this.selectionStart), (float)o, (float)n, j);
                } else {
                    this.textRenderer.method_27517(matrices, this.renderTextProvider.apply(string.substring(k), this.selectionStart), (float)o, (float)n, j);
                }
            }
            if (!bl3 && this.suggestion != null) {
                if (!this.drawsTextShadow) {
                    this.textRenderer.method_1729(matrices, this.suggestion, (float)(p - 1), (float)n, -8355712);
                } else {
                    this.textRenderer.method_1720(matrices, this.suggestion, (float)(p - 1), (float)n, -8355712);
                }
            }
            if (bl2) {
                if (bl3) {
                    var10002 = n - 1;
                    var10003 = p + 1;
                    var10004 = n + 1;
                    Objects.requireNonNull(this.textRenderer);
                    class_332.method_25294((class_4587)matrices, (int)p, (int)var10002, (int)var10003, (int)(var10004 + 9), (int)-3092272);
                } else if (!this.drawsTextShadow) {
                    this.textRenderer.method_1729(matrices, "_", (float)p, (float)n, j);
                } else {
                    this.textRenderer.method_1720(matrices, "_", (float)p, (float)n, j);
                }
            }
            if (l != k) {
                int q = m + this.textRenderer.method_1727(string.substring(0, l));
                var10002 = n - 1;
                var10003 = q - 1;
                var10004 = n + 1;
                Objects.requireNonNull(this.textRenderer);
                this.drawSelectionHighlight(p, var10002, var10003, var10004 + 9);
            }
        }
    }

    private void drawSelectionHighlight(int x1, int y1, int x2, int y2) {
        int j;
        if (x1 < x2) {
            j = x1;
            x1 = x2;
            x2 = j;
        }
        if (y1 < y2) {
            j = y1;
            y1 = y2;
            y2 = j;
        }
        if (x2 > this.field_22760 + this.field_22758) {
            x2 = this.field_22760 + this.field_22758;
        }
        if (x1 > this.field_22760 + this.field_22758) {
            x1 = this.field_22760 + this.field_22758;
        }
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34539);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22912((double)x1, (double)y2, 0.0).method_1344();
        bufferBuilder.method_22912((double)x2, (double)y2, 0.0).method_1344();
        bufferBuilder.method_22912((double)x2, (double)y1, 0.0).method_1344();
        bufferBuilder.method_22912((double)x1, (double)y1, 0.0).method_1344();
        tessellator.method_1350();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableColorLogicOp();
        RenderSystem.enableTexture();
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        if (this.text.length() > maxLength) {
            this.text = this.text.substring(0, maxLength);
            this.onChanged(this.text);
        }
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public int getCursor() {
        return this.selectionStart;
    }

    private boolean drawsBackground() {
        return this.drawsBackground;
    }

    public void setDrawsBackground(boolean drawsBackground) {
        this.drawsBackground = drawsBackground;
    }

    public void setEditableColor(int color) {
        this.editableColor = color;
    }

    public void setUneditableColor(int color) {
        this.uneditableColor = color;
    }

    public boolean method_25407(boolean lookForwards) {
        return this.field_22764 && this.editable ? super.method_25407(lookForwards) : false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.field_22760 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY >= (double)this.field_22761 && mouseY < (double)(this.field_22761 + this.field_22759);
    }

    protected void method_25363(boolean newFocused) {
        if (newFocused) {
            this.focusedTicks = 0;
        }
    }

    private boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int getInnerWidth() {
        return this.drawsBackground() ? this.field_22758 - 8 : this.field_22758;
    }

    public void setSelectionEnd(int index) {
        int i = this.text.length();
        this.selectionEnd = class_3532.method_15340((int)index, (int)0, (int)i);
        if (this.textRenderer != null) {
            if (this.firstCharacterIndex > i) {
                this.firstCharacterIndex = i;
            }
            int j = this.getInnerWidth();
            String string = this.textRenderer.method_27523(this.text.substring(this.firstCharacterIndex), j);
            int k = string.length() + this.firstCharacterIndex;
            if (this.selectionEnd == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.textRenderer.method_27524(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.firstCharacterIndex += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
            }
            this.firstCharacterIndex = class_3532.method_15340((int)this.firstCharacterIndex, (int)0, (int)i);
        }
    }

    public void setFocusUnlocked(boolean focusUnlocked) {
        this.focusUnlocked = focusUnlocked;
    }

    public boolean isVisible() {
        return this.field_22764;
    }

    public void setVisible(boolean visible) {
        this.field_22764 = visible;
    }

    public void setSuggestion(@Nullable String suggestion) {
        this.suggestion = suggestion;
    }

    public int getCharacterX(int index) {
        return index > this.text.length() ? this.field_22760 : this.field_22760 + this.textRenderer.method_1727(this.text.substring(0, index));
    }

    public void setX(int x) {
        this.field_22760 = x;
    }

    public void method_37020(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)new class_2588("narration.edit_box", new Object[]{this.getText()}));
    }
}

