/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui.screens;

import com.wuest.prefab.ClientModRegistry;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.blocks.BlockStructureScanner;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.gui.controls.ExtendedButton;
import com.wuest.prefab.gui.controls.GuiTextBox;
import java.awt.Color;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4264;
import net.minecraft.class_4587;

public class GuiStructureScanner
extends GuiBase {
    private final class_2338 blockPos;
    private final class_1937 world;
    private StructureScannerConfig config;
    private ExtendedButton btnStartingPositionMoveLeft;
    private ExtendedButton btnStartingPositionMoveRight;
    private ExtendedButton btnStartingPositionMoveDown;
    private ExtendedButton btnStartingPositionMoveUp;
    private ExtendedButton btnWidthGrow;
    private ExtendedButton btnWidthShrink;
    private ExtendedButton btnLengthGrow;
    private ExtendedButton btnLengthShrink;
    private ExtendedButton btnHeightGrow;
    private ExtendedButton btnHeightShrink;
    private GuiTextBox txtZipName;
    private ExtendedButton btnScan;
    private ExtendedButton btnSet;

    public GuiStructureScanner(class_2338 blockPos, class_1937 world, StructureScannerConfig config) {
        super("Structure Scanner");
        this.blockPos = blockPos;
        this.world = world;
        this.config = config;
        this.config.blockPos = this.blockPos;
    }

    @Override
    protected void Initialize() {
        super.Initialize();
        this.config.direction = (class_2350)this.world.method_8320(this.blockPos).method_11654((class_2769)BlockStructureScanner.FACING);
        Tuple<Integer, Integer> adjustedXYValues = this.getAdjustedXYValue();
        int adjustedX = (Integer)adjustedXYValues.first;
        int adjustedY = (Integer)adjustedXYValues.second;
        this.btnStartingPositionMoveDown = this.createAndAddButton(adjustedX + 33, adjustedY + 50, 25, 20, "\u25b2");
        this.btnStartingPositionMoveLeft = this.createAndAddButton(adjustedX + 20, adjustedY + 75, 25, 20, "\u25c4");
        this.btnStartingPositionMoveLeft.fontScale = 2.0f;
        this.btnStartingPositionMoveRight = this.createAndAddButton(adjustedX + 47, adjustedY + 75, 25, 20, "\u25ba");
        this.btnStartingPositionMoveRight.fontScale = 2.0f;
        this.btnStartingPositionMoveUp = this.createAndAddButton(adjustedX + 33, adjustedY + 100, 25, 20, "\u25bc");
        this.btnLengthShrink = this.createAndAddButton(adjustedX + 120, adjustedY + 30, 25, 20, "\u25bc");
        this.btnLengthGrow = this.createAndAddButton(adjustedX + 147, adjustedY + 30, 25, 20, "\u25b2");
        this.btnWidthShrink = this.createAndAddButton(adjustedX + 200, adjustedY + 30, 25, 20, "\u25bc");
        this.btnWidthGrow = this.createAndAddButton(adjustedX + 227, adjustedY + 30, 25, 20, "\u25b2");
        this.btnHeightShrink = this.createAndAddButton(adjustedX + 270, adjustedY + 30, 25, 20, "\u25bc");
        this.btnHeightGrow = this.createAndAddButton(adjustedX + 297, adjustedY + 30, 25, 20, "\u25b2");
        this.txtZipName = new GuiTextBox(this.getMinecraft().field_1772, adjustedX + 120, adjustedY + 75, 150, 20, (class_2561)new class_2585(""));
        if (this.config.structureZipName == null || this.config.structureZipName.trim().equals("")) {
            this.txtZipName.setText("Structure Name Here");
        } else {
            this.txtZipName.setText(this.config.structureZipName);
        }
        this.txtZipName.setMaxLength(128);
        this.txtZipName.setDrawsBackground(true);
        this.txtZipName.backgroundColor = Color.WHITE.getRGB();
        this.txtZipName.setEditableColor(Color.DARK_GRAY.getRGB());
        this.txtZipName.drawsTextShadow = false;
        this.method_25429(this.txtZipName);
        this.btnSet = this.createAndAddButton(adjustedX + 25, adjustedY + 140, 90, 20, "Set And Close");
        this.btnScan = this.createAndAddCustomButton(adjustedX + 200, adjustedY + 140, 90, 20, "Scan");
    }

    @Override
    protected void preButtonRender(class_4587 matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawControlBackground(matrixStack, x, y + 15, 350, 250);
    }

    @Override
    protected void postButtonRender(class_4587 matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawString(matrixStack, "Starting Position", x + 15, y + 20, this.textColor);
        this.drawString(matrixStack, "Left: " + this.config.blocksToTheLeft + " Down: " + -this.config.blocksDown, x + 15, y + 35, this.textColor);
        this.drawString(matrixStack, "Length: " + this.config.blocksLong, x + 120, y + 20, this.textColor);
        this.drawString(matrixStack, "Width: " + this.config.blocksWide, x + 200, y + 20, this.textColor);
        this.drawString(matrixStack, "Height: " + this.config.blocksTall, x + 270, y + 20, this.textColor);
        this.drawString(matrixStack, "Name", x + 120, y + 60, this.textColor);
    }

    @Override
    public void buttonClicked(class_4264 button) {
        this.config.structureZipName = this.txtZipName.getText();
        if (this.config.structureZipName.trim().equals("")) {
            this.config.structureZipName = "Structure Name Here";
        }
        this.config.structureZipName = this.config.structureZipName.toLowerCase().trim().replace(' ', '_');
        if (button == this.btnScan) {
            this.sendScanPacket();
            this.closeScreen();
        } else if (button == this.btnSet) {
            boolean foundExistingConfig = false;
            for (StructureScannerConfig config : ClientModRegistry.structureScanners) {
                if (config.blockPos.method_10263() != this.config.blockPos.method_10263() || config.blockPos.method_10260() != this.config.blockPos.method_10260() || config.blockPos.method_10264() != this.config.blockPos.method_10264()) continue;
                foundExistingConfig = true;
                break;
            }
            if (!foundExistingConfig) {
                ClientModRegistry.structureScanners.add(this.config);
            }
            this.closeScreen();
        } else {
            if (button == this.btnStartingPositionMoveLeft) {
                ++this.config.blocksToTheLeft;
            }
            if (button == this.btnStartingPositionMoveRight) {
                --this.config.blocksToTheLeft;
            }
            if (button == this.btnStartingPositionMoveDown) {
                --this.config.blocksDown;
            }
            if (button == this.btnStartingPositionMoveUp) {
                ++this.config.blocksDown;
            }
            if (button == this.btnWidthGrow) {
                ++this.config.blocksWide;
            }
            if (button == this.btnWidthShrink) {
                --this.config.blocksWide;
            }
            if (button == this.btnLengthGrow) {
                ++this.config.blocksLong;
            }
            if (button == this.btnLengthShrink) {
                --this.config.blocksLong;
            }
            if (button == this.btnHeightGrow) {
                ++this.config.blocksTall;
            }
            if (button == this.btnHeightShrink) {
                --this.config.blocksTall;
            }
            this.sendUpdatePacket();
        }
    }

    private void sendUpdatePacket() {
        class_2540 messagePacket = Utils.createMessageBuffer(this.config.GetCompoundNBT());
        ClientPlayNetworking.send((class_2960)ModRegistry.StructureScannerSync, (class_2540)messagePacket);
    }

    private void sendScanPacket() {
        class_2540 messagePacket = Utils.createMessageBuffer(this.config.GetCompoundNBT());
        ClientPlayNetworking.send((class_2960)ModRegistry.StructureScannerAction, (class_2540)messagePacket);
    }
}

