/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.recipe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1715;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ConditionedShapedRecipe
extends class_1869 {
    private final int width;
    private final int height;
    private final class_2371<class_1856> inputs;
    private final class_1799 output;
    private final class_2960 id;
    private final String group;
    private final String configName;

    public ConditionedShapedRecipe(class_2960 id, String group, int width, int height, class_2371<class_1856> ingredients, class_1799 output, String configName) {
        super(id, group, width, height, ingredients, output);
        this.id = id;
        this.group = group;
        this.width = width;
        this.height = height;
        this.inputs = ingredients;
        this.output = output;
        this.configName = configName;
    }

    private static class_2371<class_1856> getIngredients(String[] pattern, Map<String, class_1856> key, int width, int height) {
        class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
        HashSet set = Sets.newHashSet(key.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String string = pattern[i].substring(j, j + 1);
                class_1856 ingredient = key.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                defaultedList.set(j + width * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return defaultedList;
    }

    @VisibleForTesting
    static String[] combinePattern(String ... lines) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < lines.length; ++m) {
            String string = lines[m];
            i = Math.min(i, ConditionedShapedRecipe.findNextIngredient(string));
            int n = ConditionedShapedRecipe.findNextIngredientReverse(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (lines.length == l) {
            return new String[0];
        }
        String[] strings = new String[lines.length - l - k];
        for (int o = 0; o < strings.length; ++o) {
            strings[o] = lines[o + k].substring(i, j + 1);
        }
        return strings;
    }

    private static int findNextIngredient(String pattern) {
        int i;
        for (i = 0; i < pattern.length() && pattern.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int findNextIngredientReverse(String pattern) {
        int i;
        for (i = pattern.length() - 1; i >= 0 && pattern.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] getPattern(JsonArray json) {
        String[] strings = new String[json.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = class_3518.method_15287((JsonElement)json.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    private static Map<String, class_1856> getComponents(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            JsonElement ingredientJSON = (JsonElement)entry.getValue();
            class_1856 ingredient = class_1856.method_8102((JsonElement)ingredientJSON);
            if (ingredient.method_8103() || ingredient.method_8105().length == 0) {
                map.clear();
                break;
            }
            map.put((String)entry.getKey(), ingredient);
        }
        map.put(" ", class_1856.field_9017);
        return map;
    }

    public static class_1799 getItemStack(JsonObject json) {
        String string = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = (class_1792)class_2378.field_11142.method_17966(new class_2960(string)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + string + "'"));
        int stackCount = 1;
        if (class_3518.method_34920((JsonObject)json, (String)"count")) {
            stackCount = class_3518.method_15260((JsonObject)json, (String)"count");
        }
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        return new class_1799((class_1935)item, stackCount);
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRegistry.ConditionedShapedRecipeSeriaizer;
    }

    @Environment(value=EnvType.CLIENT)
    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_2371<class_1856> getPreviewInputs() {
        return this.inputs;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_8113(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    public boolean method_17728(class_1715 craftingInventory, class_1937 world) {
        for (int i = 0; i <= craftingInventory.method_17398() - this.width; ++i) {
            for (int j = 0; j <= craftingInventory.method_17397() - this.height; ++j) {
                if (this.matchesSmall(craftingInventory, i, j, true)) {
                    return true;
                }
                if (!this.matchesSmall(craftingInventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesSmall(class_1715 inv, int offsetX, int offsetY, boolean bl) {
        for (int i = 0; i < inv.method_17398(); ++i) {
            for (int j = 0; j < inv.method_17397(); ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                class_1856 ingredient = class_1856.field_9017;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = bl ? (class_1856)this.inputs.get(this.width - k - 1 + l * this.width) : (class_1856)this.inputs.get(k + l * this.width);
                }
                if (ingredient.method_8093(inv.method_5438(i + j * inv.method_17398()))) continue;
                return false;
            }
        }
        return true;
    }

    public class_1799 method_17727(class_1715 craftingInventory) {
        return this.method_8110().method_7972();
    }

    public int method_8150() {
        return this.width;
    }

    public int method_8158() {
        return this.height;
    }

    public static class Serializer
    implements class_1865<ConditionedShapedRecipe> {
        public ConditionedShapedRecipe read(class_2960 identifier, JsonObject jsonObject) {
            String groupName = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            String configName = class_3518.method_15253((JsonObject)jsonObject, (String)"configName", (String)"");
            Map<String, class_1856> map = ConditionedShapedRecipe.getComponents(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
            if (map.size() == 1 && map.containsKey(" ")) {
                return new ConditionedShapedRecipe(identifier, groupName, 3, 3, (class_2371<class_1856>)class_2371.method_10213((int)9, (Object)class_1856.field_9017), class_1799.field_8037, configName);
            }
            String[] strings = ConditionedShapedRecipe.combinePattern(ConditionedShapedRecipe.getPattern(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern")));
            int width = strings[0].length();
            int height = strings.length;
            class_2371<class_1856> defaultedList = ConditionedShapedRecipe.getIngredients(strings, map, width, height);
            class_1799 itemStack = this.validateRecipeOutput(ConditionedShapedRecipe.getItemStack(class_3518.method_15296((JsonObject)jsonObject, (String)"result")), configName);
            return new ConditionedShapedRecipe(identifier, groupName, width, height, defaultedList, itemStack, configName);
        }

        public ConditionedShapedRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            int width = packetByteBuf.method_10816();
            int height = packetByteBuf.method_10816();
            String groupName = packetByteBuf.method_10800(Short.MAX_VALUE);
            String configName = packetByteBuf.method_10800(Short.MAX_VALUE);
            class_2371 defaultedList = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            for (int k = 0; k < defaultedList.size(); ++k) {
                defaultedList.set(k, (Object)class_1856.method_8086((class_2540)packetByteBuf));
            }
            class_1799 itemStack = this.validateRecipeOutput(packetByteBuf.method_10819(), configName);
            return new ConditionedShapedRecipe(identifier, groupName, width, height, (class_2371<class_1856>)defaultedList, itemStack, configName);
        }

        public void write(class_2540 packetByteBuf, ConditionedShapedRecipe shapedRecipe) {
            packetByteBuf.method_10804(shapedRecipe.width);
            packetByteBuf.method_10804(shapedRecipe.height);
            packetByteBuf.method_10814(shapedRecipe.group);
            packetByteBuf.method_10814(shapedRecipe.configName);
            for (class_1856 ingredient : shapedRecipe.inputs) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10793(shapedRecipe.output);
        }

        public class_1799 validateRecipeOutput(class_1799 originalOutput, String configName) {
            if (originalOutput == class_1799.field_8037) {
                return class_1799.field_8037;
            }
            if (!Strings.isNullOrEmpty((String)configName) && Prefab.serverConfiguration.recipes.containsKey(configName) && !Prefab.serverConfiguration.recipes.get(configName).booleanValue()) {
                return class_1799.field_8037;
            }
            return originalOutput;
        }
    }
}

