/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.recipe;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.recipe.ConditionedShapedRecipe;
import it.unimi.dsi.fastutil.ints.IntList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1662;
import net.minecraft.class_1715;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ConditionedShaplessRecipe
extends class_1867 {
    private final class_2960 id;
    private final String group;
    private final class_1799 output;
    private final class_2371<class_1856> input;
    private final String configName;

    public ConditionedShaplessRecipe(class_2960 id, String group, class_1799 output, class_2371<class_1856> input, String configName) {
        super(id, group, output, input);
        this.id = id;
        this.group = group;
        this.output = output;
        this.input = input;
        this.configName = configName;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRegistry.ConditionedShapelessRecipeSeriaizer;
    }

    @Environment(value=EnvType.CLIENT)
    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_2371<class_1856> getPreviewInputs() {
        return this.input;
    }

    public boolean method_17730(class_1715 craftingInventory, class_1937 world) {
        class_1662 recipeFinder = new class_1662();
        int i = 0;
        for (int j = 0; j < craftingInventory.method_5439(); ++j) {
            class_1799 itemStack = craftingInventory.method_5438(j);
            if (itemStack.method_7960()) continue;
            ++i;
            recipeFinder.method_20478(itemStack, 1);
        }
        return i == this.input.size() && recipeFinder.method_7402((class_1860)this, (IntList)null);
    }

    public class_1799 method_17729(class_1715 craftingInventory) {
        return this.output.method_7972();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_8113(int width, int height) {
        return width * height >= this.input.size();
    }

    public static class Serializer
    implements class_1865<ConditionedShaplessRecipe> {
        public ConditionedShaplessRecipe read(class_2960 identifier, JsonObject jsonObject) {
            String groupName = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)"");
            String configName = class_3518.method_15253((JsonObject)jsonObject, (String)"configName", (String)"");
            class_2371<class_1856> defaultedList = Serializer.getIngredients(class_3518.method_15261((JsonObject)jsonObject, (String)"ingredients"));
            if (defaultedList.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (defaultedList.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            class_1799 itemStack = this.validateRecipeOutput(ConditionedShapedRecipe.getItemStack(class_3518.method_15296((JsonObject)jsonObject, (String)"result")), configName);
            return new ConditionedShaplessRecipe(identifier, groupName, itemStack, defaultedList, configName);
        }

        private static class_2371<class_1856> getIngredients(JsonArray json) {
            class_2371 defaultedList = class_2371.method_10211();
            for (int i = 0; i < json.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)json.get(i));
                if (ingredient.method_8103()) continue;
                defaultedList.add((Object)ingredient);
            }
            return defaultedList;
        }

        public ConditionedShaplessRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            String groupName = packetByteBuf.method_10800(Short.MAX_VALUE);
            String configName = packetByteBuf.method_10800(Short.MAX_VALUE);
            int i = packetByteBuf.method_10816();
            class_2371 defaultedList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < defaultedList.size(); ++j) {
                defaultedList.set(j, (Object)class_1856.method_8086((class_2540)packetByteBuf));
            }
            class_1799 itemStack = this.validateRecipeOutput(packetByteBuf.method_10819(), configName);
            return new ConditionedShaplessRecipe(identifier, groupName, itemStack, (class_2371<class_1856>)defaultedList, configName);
        }

        public void write(class_2540 packetByteBuf, ConditionedShaplessRecipe shapelessRecipe) {
            packetByteBuf.method_10814(shapelessRecipe.group);
            packetByteBuf.method_10814(shapelessRecipe.configName);
            packetByteBuf.method_10804(shapelessRecipe.input.size());
            for (class_1856 ingredient : shapelessRecipe.input) {
                ingredient.method_8088(packetByteBuf);
            }
            packetByteBuf.method_10793(shapelessRecipe.output);
        }

        public class_1799 validateRecipeOutput(class_1799 originalOutput, String configName) {
            if (originalOutput == class_1799.field_8037) {
                return class_1799.field_8037;
            }
            if (!Strings.isNullOrEmpty((String)configName) && Prefab.serverConfiguration.recipes.containsKey(configName) && !Prefab.serverConfiguration.recipes.get(configName).booleanValue()) {
                return class_1799.field_8037;
            }
            return originalOutput;
        }
    }
}

