/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.google.gson.annotations.Expose;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.structures.base.BuildProperty;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2310;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2401;
import net.minecraft.class_2465;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2522;
import net.minecraft.class_2541;
import net.minecraft.class_2544;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3610;
import net.minecraft.class_4778;

public class BuildBlock {
    public class_2338 blockPos;
    @Expose
    private String blockDomain;
    @Expose
    private String blockName;
    @Expose
    private PositionOffset startingPosition;
    @Expose
    private ArrayList<BuildProperty> properties;
    @Expose
    private BuildBlock subBlock;
    @Expose
    private boolean hasFacing;
    @Expose
    private class_2680 state;
    @Expose
    private String blockStateData;

    public BuildBlock() {
        this.Initialize();
    }

    public static BuildBlock SetBlockState(StructureConfiguration configuration, class_1937 world, class_2338 originalPos, class_2350 assumedNorth, BuildBlock block, class_2248 foundBlock, class_2680 blockState, Structure structure) {
        try {
            if (!block.blockStateData.equals("")) {
                return BuildBlock.SetBlockStateFromTagData(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, structure);
            }
            class_2350 vineFacing = BuildBlock.getVineFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            class_2350.class_2351 logFacing = BuildBlock.getBoneFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            class_2350.class_2351 boneFacing = BuildBlock.getBoneFacing(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            class_2350 leverOrientation = BuildBlock.getLeverOrientation(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Map<class_2350, Boolean> fourWayFacings = BuildBlock.getFourWayBlockFacings(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            Map<class_2350, class_4778> wallShapes = BuildBlock.getWallFacings(configuration, foundBlock, block, structure.getClearSpace().getShape().getDirection());
            if (block.getProperties().size() > 0) {
                Collection properties = blockState.method_28501();
                for (class_2769 property : properties) {
                    BuildProperty buildProperty = block.getProperty(property.method_11899());
                    if (buildProperty == null) continue;
                    try {
                        Optional propertyValue = property.method_11900(buildProperty.getValue());
                        if (!propertyValue.isPresent() || propertyValue.getClass().getName().equals("com.google.common.base.Absent")) {
                            Prefab.logger.warn("Property value for property name [" + property.method_11899() + "] for block [" + block.getBlockName() + "] is considered Absent, figure out why.");
                            continue;
                        }
                        Comparable comparable = (Comparable)property.method_11902().cast(propertyValue.get());
                        if ((comparable = BuildBlock.setComparable(comparable, foundBlock, property, configuration, block, propertyValue, vineFacing, logFacing, boneFacing, leverOrientation, structure, fourWayFacings, wallShapes)) == null) continue;
                        try {
                            if (blockState.method_11654(property) == comparable) continue;
                            blockState = BuildBlock.setProperty(blockState, property, comparable);
                        }
                        catch (Exception ex) {
                            System.out.println("Error setting properly value for property name [" + property.method_11899() + "] property value [" + buildProperty.getValue() + "] for block [" + block.getBlockName() + "] The default value will be used.");
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Error getting properly value for property name [" + property.method_11899() + "] property value [" + buildProperty.getValue() + "] for block [" + block.getBlockName() + "]");
                        throw ex;
                    }
                }
            }
            block.setBlockState(blockState);
            return block;
        }
        catch (Exception ex) {
            System.out.println("Error setting block state for block [" + block.getBlockName() + "] for structure configuration class [" + configuration.getClass().getName() + "]");
            throw ex;
        }
    }

    private static boolean neighborHaveWater(class_2338 originalPos, class_1937 world) {
        boolean returnValue = false;
        for (class_2350 direction : class_2350.values()) {
            class_3610 fluidState;
            if (direction == class_2350.field_11033 || !(fluidState = world.method_8316(originalPos.method_10093(direction))).method_15767((class_3494)class_3486.field_15517) || fluidState.method_15761() != 8) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public static class_2350 getHorizontalFacing(class_2350 currentFacing, class_2350 configurationFacing, class_2350 structureDirection) {
        if (currentFacing != null && currentFacing != class_2350.field_11036 && currentFacing != class_2350.field_11033) {
            if (configurationFacing.method_10153() == structureDirection.method_10170()) {
                currentFacing = currentFacing.method_10170();
            } else if (configurationFacing.method_10153() == structureDirection.method_10153()) {
                currentFacing = currentFacing.method_10153();
            } else if (configurationFacing.method_10153() == structureDirection.method_10160()) {
                currentFacing = currentFacing.method_10160();
            }
        }
        return currentFacing;
    }

    private static Comparable setComparable(Comparable<?> comparable, class_2248 foundBlock, class_2769<?> property, StructureConfiguration configuration, BuildBlock block, Optional<?> propertyValue, class_2350 vineFacing, class_2350.class_2351 logFacing, class_2350.class_2351 boneFacing, class_2350 leverOrientation, Structure structure, Map<class_2350, Boolean> fourWayFacings, Map<class_2350, class_4778> wallShapes) {
        if (property.method_11899().equals("facing") && foundBlock instanceof class_2341) {
            comparable = leverOrientation;
            block.setHasFacing(true);
        } else if (property.method_11899().equals("facing")) {
            class_2350 facing = BuildBlock.getDirectionByName(propertyValue.get().toString());
            comparable = facing = BuildBlock.getHorizontalFacing(facing, configuration.houseFacing, structure.getClearSpace().getShape().getDirection());
            block.setHasFacing(true);
        } else if (property.method_11899().equals("rotation")) {
            class_2350 facing;
            int rotation = (Integer)propertyValue.get();
            class_2350 class_23502 = rotation == 0 ? class_2350.field_11035 : (rotation == 4 ? class_2350.field_11039 : (facing = rotation == 8 ? class_2350.field_11043 : class_2350.field_11034));
            if (configuration.houseFacing.method_10153() == structure.getClearSpace().getShape().getDirection().method_10170()) {
                facing = facing.method_10170();
            } else if (configuration.houseFacing.method_10153() == structure.getClearSpace().getShape().getDirection().method_10153()) {
                facing = facing.method_10153();
            } else if (configuration.houseFacing.method_10153() == structure.getClearSpace().getShape().getDirection().method_10160()) {
                facing = facing.method_10160();
            }
            rotation = facing == class_2350.field_11035 ? 0 : (facing == class_2350.field_11039 ? 4 : (facing == class_2350.field_11043 ? 8 : 12));
            comparable = rotation;
            block.setHasFacing(true);
        } else if (foundBlock instanceof class_2541) {
            if (property.method_11899().equals(vineFacing.method_10151())) {
                comparable = true;
                block.setHasFacing(true);
            } else {
                comparable = false;
            }
        } else if (foundBlock instanceof class_2310 && !property.method_11899().equals("waterlogged")) {
            for (Map.Entry<class_2350, Boolean> entry : fourWayFacings.entrySet()) {
                if (!property.method_11899().equals(entry.getKey().method_10151())) continue;
                comparable = entry.getValue();
            }
        } else if (foundBlock instanceof class_2544 && !property.method_11899().equals("waterlogged")) {
            for (Map.Entry<class_2350, class_4778> entry : wallShapes.entrySet()) {
                if (!property.method_11899().equals(entry.getKey().method_10151())) continue;
                comparable = (Comparable)entry.getValue();
            }
        } else if (foundBlock instanceof class_2465 && property.method_11899().equals("axis")) {
            comparable = boneFacing;
        }
        return comparable;
    }

    private static class_2350 getVineFacing(StructureConfiguration configuration, class_2248 foundBlock, BuildBlock block, class_2350 assumedNorth) {
        class_2350 vineFacing = class_2350.field_11036;
        if (foundBlock instanceof class_2541 || foundBlock instanceof class_2544) {
            if (block.getProperty("east").getValue().equals("true")) {
                vineFacing = class_2350.field_11034;
            } else if (block.getProperty("west").getValue().equals("true")) {
                vineFacing = class_2350.field_11039;
            } else if (block.getProperty("south").getValue().equals("true")) {
                vineFacing = class_2350.field_11035;
            } else if (block.getProperty("north").getValue().equals("true")) {
                vineFacing = class_2350.field_11043;
            }
            if (vineFacing != class_2350.field_11036) {
                if (configuration.houseFacing.method_10170() == assumedNorth) {
                    vineFacing = vineFacing.method_10170();
                } else if (configuration.houseFacing.method_10153() != assumedNorth) {
                    vineFacing = configuration.houseFacing.method_10160() == assumedNorth ? vineFacing.method_10160() : vineFacing.method_10153();
                }
            }
        }
        return vineFacing;
    }

    private static Map<class_2350, class_4778> getWallFacings(StructureConfiguration configuration, class_2248 foundBlock, BuildBlock block, class_2350 assumedNorth) {
        HashMap<class_2350, class_4778> facings = new HashMap<class_2350, class_4778>();
        if (foundBlock instanceof class_2544) {
            class_4778 northValue = BuildBlock.getShapeByName(block.getProperty("north").getValue());
            class_4778 eastValue = BuildBlock.getShapeByName(block.getProperty("east").getValue());
            class_4778 westValue = BuildBlock.getShapeByName(block.getProperty("west").getValue());
            class_4778 southValue = BuildBlock.getShapeByName(block.getProperty("south").getValue());
            class_4778 originalNorth = northValue;
            class_4778 originalEast = eastValue;
            class_4778 originalWest = westValue;
            class_4778 originalSouth = southValue;
            if (configuration.houseFacing.method_10170() == assumedNorth) {
                northValue = originalWest;
                eastValue = originalNorth;
                southValue = originalEast;
                westValue = originalSouth;
            } else if (configuration.houseFacing == assumedNorth) {
                northValue = originalSouth;
                eastValue = originalWest;
                southValue = originalNorth;
                westValue = originalEast;
            } else if (configuration.houseFacing.method_10160() == assumedNorth) {
                northValue = originalEast;
                eastValue = originalSouth;
                southValue = originalWest;
                westValue = originalNorth;
            }
            facings.put(class_2350.field_11043, northValue);
            facings.put(class_2350.field_11034, eastValue);
            facings.put(class_2350.field_11039, westValue);
            facings.put(class_2350.field_11035, southValue);
        }
        return facings;
    }

    private static Map<class_2350, Boolean> getFourWayBlockFacings(StructureConfiguration configuration, class_2248 foundBlock, BuildBlock block, class_2350 assumedNorth) {
        HashMap<class_2350, Boolean> facings = new HashMap<class_2350, Boolean>();
        if (foundBlock instanceof class_2310) {
            boolean northValue = Boolean.parseBoolean(block.getProperty("north").getValue());
            boolean eastValue = Boolean.parseBoolean(block.getProperty("east").getValue());
            boolean westValue = Boolean.parseBoolean(block.getProperty("west").getValue());
            boolean southValue = Boolean.parseBoolean(block.getProperty("south").getValue());
            boolean originalNorth = northValue;
            boolean originalEast = eastValue;
            boolean originalWest = westValue;
            boolean originalSouth = southValue;
            if (configuration.houseFacing.method_10170() == assumedNorth) {
                northValue = originalWest;
                eastValue = originalNorth;
                southValue = originalEast;
                westValue = originalSouth;
            } else if (configuration.houseFacing == assumedNorth) {
                northValue = originalSouth;
                eastValue = originalWest;
                southValue = originalNorth;
                westValue = originalEast;
            } else if (configuration.houseFacing.method_10160() == assumedNorth) {
                northValue = originalEast;
                eastValue = originalSouth;
                southValue = originalWest;
                westValue = originalNorth;
            }
            facings.put(class_2350.field_11043, northValue);
            facings.put(class_2350.field_11034, eastValue);
            facings.put(class_2350.field_11039, westValue);
            facings.put(class_2350.field_11035, southValue);
        }
        return facings;
    }

    private static class_2350.class_2351 getBoneFacing(StructureConfiguration configuration, class_2248 foundBlock, BuildBlock block, class_2350 assumedNorth) {
        BuildProperty property;
        class_2350.class_2351 boneFacing = class_2350.class_2351.field_11048;
        if (foundBlock instanceof class_2465 && (property = block.getProperty("axis")) != null) {
            if (!property.getValue().equals("x")) {
                boneFacing = property.getValue().equals("y") ? class_2350.class_2351.field_11052 : class_2350.class_2351.field_11051;
            }
            if (boneFacing != class_2350.class_2351.field_11052) {
                boneFacing = configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.method_10153() ? boneFacing : (boneFacing == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048);
            }
        }
        return boneFacing;
    }

    private static class_2350 getLeverOrientation(StructureConfiguration configuration, class_2248 foundBlock, BuildBlock block, class_2350 assumedNorth) {
        class_2350 leverOrientation = class_2350.field_11043;
        class_2738 attachedTo = class_2738.field_12475;
        if (foundBlock instanceof class_2341) {
            leverOrientation = (class_2350)class_2741.field_12481.method_11900(block.getProperty("facing").getValue()).get();
            attachedTo = (class_2738)class_2401.field_11007.method_11900(block.getProperty("face").getValue()).get();
            if (attachedTo == class_2738.field_12475 || attachedTo == class_2738.field_12473) {
                leverOrientation = attachedTo == class_2738.field_12475 ? (configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.method_10153() ? leverOrientation : (leverOrientation == class_2350.field_11043 ? class_2350.field_11034 : class_2350.field_11043)) : (configuration.houseFacing == assumedNorth || configuration.houseFacing == assumedNorth.method_10153() ? leverOrientation : (leverOrientation == class_2350.field_11043 ? class_2350.field_11034 : class_2350.field_11043));
            } else {
                class_2350 facing = leverOrientation;
                if (configuration.houseFacing.method_10170() == assumedNorth) {
                    facing = facing.method_10170();
                } else if (configuration.houseFacing.method_10153() != assumedNorth) {
                    facing = configuration.houseFacing.method_10160() == assumedNorth ? facing.method_10160() : facing.method_10153();
                }
                for (class_2350 tempOrientation : class_2350.values()) {
                    if (tempOrientation != facing) continue;
                    leverOrientation = tempOrientation;
                    break;
                }
            }
        }
        return leverOrientation;
    }

    private static class_2680 setProperty(class_2680 state, class_2769 property, Comparable comparable) {
        return (class_2680)state.method_11657(property, comparable);
    }

    private static BuildBlock SetBlockStateFromTagData(StructureConfiguration configuration, class_1937 world, class_2338 originalPos, class_2350 assumedNorth, BuildBlock block, class_2248 foundBlock, class_2680 blockState, Structure structure) {
        class_2680 tagState = block.getBlockStateFromDataTag();
        if (tagState == null) {
            block.setBlockStateData("");
            return BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, structure);
        }
        block.setBlockState(block.getBlockStateFromDataTag());
        return block;
    }

    public static class_2350 getDirectionByName(String name) {
        for (class_2350 direction : class_2350.values()) {
            if (!direction.method_10151().toLowerCase().equals(name.toLowerCase())) continue;
            return direction;
        }
        return class_2350.field_11043;
    }

    public static class_4778 getShapeByName(String name) {
        for (class_4778 shape : class_4778.values()) {
            if (!shape.method_15434().toLowerCase().equals(name.toLowerCase())) continue;
            return shape;
        }
        return class_4778.field_22178;
    }

    public String getBlockDomain() {
        return this.blockDomain;
    }

    public void setBlockDomain(String value) {
        this.blockDomain = value;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String value) {
        this.blockName = value;
    }

    public class_2960 getResourceLocation() {
        return new class_2960(this.blockDomain, this.blockName);
    }

    public PositionOffset getStartingPosition() {
        return this.startingPosition;
    }

    public void setStartingPosition(PositionOffset value) {
        this.startingPosition = value;
    }

    public ArrayList<BuildProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<BuildProperty> value) {
        this.properties = value;
    }

    public BuildProperty getProperty(String name) {
        for (BuildProperty property : this.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public BuildBlock getSubBlock() {
        return this.subBlock;
    }

    public void setSubBlock(BuildBlock value) {
        this.subBlock = value;
    }

    public boolean getHasFacing() {
        return this.hasFacing;
    }

    public void setHasFacing(boolean value) {
        this.hasFacing = value;
    }

    public class_2680 getBlockState() {
        return this.state;
    }

    public void setBlockState(class_2680 value) {
        this.state = value;
    }

    public String getBlockStateData() {
        return this.blockStateData;
    }

    public void setBlockStateData(String value) {
        this.blockStateData = value;
    }

    public void setBlockStateData(class_2487 tagCompound) {
        this.blockStateData = tagCompound.toString();
    }

    public class_2487 getBlockStateDataTag() {
        class_2487 tag = null;
        if (!this.blockStateData.equals("")) {
            try {
                tag = class_2522.method_10718((String)this.blockStateData);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        return tag;
    }

    public class_2680 getBlockStateFromDataTag() {
        class_2487 tag;
        class_2680 state = null;
        if (!this.blockStateData.equals("") && (tag = this.getBlockStateDataTag()) != null) {
            state = class_2512.method_10681((class_2487)tag.method_10562("tag"));
        }
        return state;
    }

    public void Initialize() {
        this.blockDomain = "";
        this.blockName = "";
        this.properties = new ArrayList();
        this.hasFacing = false;
        this.state = null;
        this.subBlock = null;
        this.startingPosition = new PositionOffset();
        this.blockStateData = "";
    }
}

