/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Triple;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.config.ModConfiguration;
import java.util.ArrayList;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2399;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3866;

public class BuildingMethods {
    public static ArrayList<class_1799> ConsolidateDrops(class_3218 world, class_2338 pos, class_2680 state, ArrayList<class_1799> originalStacks, ArrayList<class_1792> itemsToNotAdd) {
        for (class_1799 stack : class_2248.method_9562((class_2680)state, (class_3218)world, (class_2338)pos, null)) {
            if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.method_7909())) continue;
            boolean foundStack = false;
            for (class_1799 existingStack : originalStacks) {
                if (!class_1799.method_7987((class_1799)existingStack, (class_1799)stack) || existingStack.method_7947() + stack.method_7947() > stack.method_7914()) continue;
                existingStack.method_7939(existingStack.method_7947() + stack.method_7947());
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            originalStacks.add(stack);
        }
        return originalStacks;
    }

    public static ArrayList<class_1799> CreateWall(class_3218 world, int height, int length, class_2350 direction, class_2338 startingPosition, class_2248 replacementBlock, ArrayList<class_1792> itemsToNotAdd) {
        ArrayList<class_1799> itemsDropped = new ArrayList<class_1799>();
        class_2338 wallPos = null;
        for (int i = 0; i < height; ++i) {
            wallPos = startingPosition.method_10086(i);
            for (int j = 0; j < length; ++j) {
                class_2680 currentBlockPosState = world.method_8320(wallPos);
                for (class_1799 stack : class_2248.method_9562((class_2680)currentBlockPosState, (class_3218)world, (class_2338)wallPos, null)) {
                    if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.method_7909())) continue;
                    itemsDropped.add(stack);
                }
                BuildingMethods.ReplaceBlock((class_1937)world, wallPos, replacementBlock);
                wallPos = wallPos.method_10093(direction);
            }
        }
        return itemsDropped;
    }

    public static ArrayList<class_1799> SetFloor(class_3218 world, class_2338 pos, class_2248 block, int width, int depth, ArrayList<class_1799> originalStack, class_2350 facing, ArrayList<class_1792> itemsToNotAdd) {
        for (int i = 0; i < width; ++i) {
            originalStack.addAll(BuildingMethods.CreateWall(world, 1, depth, facing, pos, block, itemsToNotAdd));
            pos = pos.method_10093(facing.method_10170());
        }
        return originalStack;
    }

    public static void ReplaceBlock(class_1937 world, class_2338 pos, class_2248 replacementBlock) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlock.method_9564(), 3);
    }

    public static void ReplaceBlockNoAir(class_1937 world, class_2338 pos, class_2248 replacementBlock) {
        BuildingMethods.ReplaceBlockNoAir(world, pos, replacementBlock.method_9564(), 3);
    }

    public static void ReplaceBlock(class_1937 world, class_2338 pos, class_2680 replacementBlockState) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlockState, 3);
    }

    public static void ReplaceBlock(class_1937 world, class_2338 pos, class_2680 replacementBlockState, int flags) {
        world.method_8650(pos, false);
        world.method_8652(pos, replacementBlockState, flags);
    }

    public static void ReplaceBlockNoAir(class_1937 world, class_2338 pos, class_2680 replacementBlockState, int flags) {
        world.method_8652(pos, replacementBlockState, flags);
    }

    public static Triple<Boolean, class_2680, class_2338> CheckBuildSpaceForAllowedBlockReplacement(class_3218 world, class_2338 startBlockPos, class_2338 endBlockPos, class_1657 player) {
        if (!world.field_9236) {
            for (class_2338 currentPos : class_2338.method_10097((class_2338)startBlockPos, (class_2338)endBlockPos)) {
                class_2680 blockState = world.method_8320(currentPos);
                if (world.method_8503().method_3785(world, currentPos, player)) {
                    return new Triple<Boolean, class_2680, class_2338>(false, blockState, currentPos);
                }
                if (!world.method_22347(currentPos) && !((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak((class_1937)world, player, currentPos, world.method_8320(currentPos), null)) {
                    return new Triple<Boolean, class_2680, class_2338>(false, blockState, currentPos);
                }
                if (!(blockState.method_26214((class_1922)world, currentPos) < 0.0f)) continue;
                return new Triple<Boolean, class_2680, class_2338>(false, blockState, currentPos);
            }
        }
        return new Triple<Boolean, Object, Object>(true, null, null);
    }

    public static void PlaceColoredBed(class_1937 world, class_2338 bedHeadPos, class_2338 bedFootPos, class_1767 bedColor) {
        class_2680 bedFoot = null;
        class_2244 bedBlock = null;
        switch (bedColor) {
            case field_7963: {
                bedBlock = (class_2244)class_2246.field_10461;
                bedFoot = class_2246.field_10461.method_9564();
                break;
            }
            case field_7966: {
                bedBlock = (class_2244)class_2246.field_10527;
                bedFoot = class_2246.field_10527.method_9564();
                break;
            }
            case field_7957: {
                bedBlock = (class_2244)class_2246.field_10288;
                bedFoot = class_2246.field_10288.method_9564();
                break;
            }
            case field_7955: {
                bedBlock = (class_2244)class_2246.field_10109;
                bedFoot = class_2246.field_10109.method_9564();
                break;
            }
            case field_7944: {
                bedBlock = (class_2244)class_2246.field_10141;
                bedFoot = class_2246.field_10141.method_9564();
                break;
            }
            case field_7942: {
                bedBlock = (class_2244)class_2246.field_10561;
                bedFoot = class_2246.field_10561.method_9564();
                break;
            }
            case field_7951: {
                bedBlock = (class_2244)class_2246.field_10621;
                bedFoot = class_2246.field_10621.method_9564();
                break;
            }
            case field_7967: {
                bedBlock = (class_2244)class_2246.field_10326;
                bedFoot = class_2246.field_10326.method_9564();
                break;
            }
            case field_7961: {
                bedBlock = (class_2244)class_2246.field_10180;
                bedFoot = class_2246.field_10180.method_9564();
                break;
            }
            case field_7958: {
                bedBlock = (class_2244)class_2246.field_10230;
                bedFoot = class_2246.field_10230.method_9564();
                break;
            }
            case field_7946: {
                bedBlock = (class_2244)class_2246.field_10410;
                bedFoot = class_2246.field_10410.method_9564();
                break;
            }
            case field_7954: {
                bedBlock = (class_2244)class_2246.field_10610;
                bedFoot = class_2246.field_10610.method_9564();
                break;
            }
            case field_7945: {
                bedBlock = (class_2244)class_2246.field_10019;
                bedFoot = class_2246.field_10019.method_9564();
                break;
            }
            case field_7964: {
                bedBlock = (class_2244)class_2246.field_10069;
                bedFoot = class_2246.field_10069.method_9564();
                break;
            }
            case field_7952: {
                bedBlock = (class_2244)class_2246.field_10120;
                bedFoot = class_2246.field_10120.method_9564();
                break;
            }
            case field_7947: {
                bedBlock = (class_2244)class_2246.field_10356;
                bedFoot = class_2246.field_10356.method_9564();
            }
        }
        class_2350 direction = class_2350.field_11043;
        class_2338 tempPos = bedHeadPos.method_10093(class_2350.field_11043);
        while (tempPos.method_10263() != bedFootPos.method_10263() || tempPos.method_10260() != bedFootPos.method_10260()) {
            direction = direction.method_10170();
            tempPos = bedHeadPos.method_10093(direction);
        }
        class_2350 facingDirection = direction.method_10153();
        bedFoot = (class_2680)bedFoot.method_11657((class_2769)class_2244.field_11177, (Comparable)facingDirection);
        world.method_8652(bedHeadPos, class_2246.field_10124.method_9564(), 35);
        world.method_8652(bedFootPos, class_2246.field_10124.method_9564(), 35);
        BuildingMethods.ReplaceBlock(world, bedFootPos, bedFoot);
        bedBlock.method_9567(world, bedFootPos, bedFoot, null, class_1799.field_8037);
    }

    public static void FillChest(class_1937 world, class_2338 itemPosition) {
        class_2586 tileEntity = world.method_8321(itemPosition);
        if (tileEntity instanceof class_2621) {
            class_2621 chestTile = (class_2621)tileEntity;
            int itemSlot = 0;
            if (Prefab.serverConfiguration.chestOptions.addAxe) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8062));
            }
            if (Prefab.serverConfiguration.chestOptions.addHoe) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8431));
            }
            if (Prefab.serverConfiguration.chestOptions.addPickAxe) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8387));
            }
            if (Prefab.serverConfiguration.chestOptions.addShovel) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8776));
            }
            if (Prefab.serverConfiguration.chestOptions.addSword) {
                class_1792 sword = ModRegistry.SwiftBladeStone;
                if (!Prefab.serverConfiguration.recipes.get(ModConfiguration.ConfigKeyNames.swiftBladeKey).booleanValue()) {
                    sword = class_1802.field_8528;
                }
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)sword));
            }
            if (Prefab.serverConfiguration.chestOptions.addArmor) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8370));
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8577));
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8267));
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8570));
            }
            if (Prefab.serverConfiguration.chestOptions.addFood) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8229, 20));
            }
            if (Prefab.serverConfiguration.chestOptions.addCrops) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8567, 3));
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8179, 3));
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1802.field_8317, 3));
            }
            if (Prefab.serverConfiguration.chestOptions.addCobble) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1792.method_7867((class_2248)class_2246.field_10445), 64));
            }
            if (Prefab.serverConfiguration.chestOptions.addDirt) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1792.method_7867((class_2248)class_2246.field_10566), 64));
            }
            if (Prefab.serverConfiguration.chestOptions.addSaplings) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1792.method_7867((class_2248)class_2246.field_10394), 3));
            }
            if (Prefab.serverConfiguration.chestOptions.addTorches) {
                chestTile.method_5447(itemSlot++, new class_1799((class_1935)class_1792.method_7867((class_2248)class_2246.field_10336), 20));
            }
        }
    }

    public static void FillFurnaces(class_1937 world, ArrayList<class_2338> furnacePositions) {
        if (furnacePositions != null && furnacePositions.size() > 0) {
            for (class_2338 furnacePos : furnacePositions) {
                class_2586 tileEntity = world.method_8321(furnacePos);
                if (!(tileEntity instanceof class_3866)) continue;
                class_3866 furnaceTile = (class_3866)tileEntity;
                furnaceTile.method_5447(1, new class_1799((class_1935)class_1802.field_8713, 20));
            }
        }
    }

    public static void PlaceMineShaft(class_3218 world, class_2338 pos, class_2350 facing, boolean onlyGatherOres) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        ArrayList<class_1792> blocksToNotAdd = new ArrayList<class_1792>();
        if (onlyGatherOres) {
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10102));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_9979));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10445));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10340));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10566));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10474));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10115));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10508));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10534));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10344));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_9989));
            blocksToNotAdd.add(class_1792.method_7867((class_2248)class_2246.field_10065));
        }
        Tuple<ArrayList<class_1799>, ArrayList<class_2338>> ladderShaftResults = BuildingMethods.CreateLadderShaft(world, pos, stacks, facing, blocksToNotAdd);
        stacks = ladderShaftResults.getFirst();
        ArrayList<class_2338> torchPositions = ladderShaftResults.getSecond();
        pos = pos.method_10087(pos.method_10264() - 10);
        ArrayList<class_1799> tempStacks = new ArrayList<class_1799>();
        class_2338 ceilingLevel = pos.method_10086(4);
        tempStacks = BuildingMethods.SetFloor(world, ceilingLevel.method_10079(facing, 2).method_10079(facing.method_10170(), 2).method_10093(facing.method_10153()), class_2246.field_10340, 4, 4, tempStacks, facing.method_10153(), blocksToNotAdd);
        BuildingMethods.ReplaceBlock((class_1937)world, ceilingLevel, (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)facing));
        class_2680 torchState = class_2246.field_10336.method_9564();
        for (class_2338 torchPos : torchPositions) {
            class_2680 surroundingState = world.method_8320(torchPos);
            class_2248 surroundingBlock = surroundingState.method_26204();
            tempStacks = BuildingMethods.ConsolidateDrops(world, torchPos, surroundingState, tempStacks, blocksToNotAdd);
            BuildingMethods.ReplaceBlock((class_1937)world, torchPos, torchState);
        }
        tempStacks.addAll(BuildingMethods.SetFloor(world, pos.method_10093(facing).method_10093(facing.method_10170()), class_2246.field_10340, 3, 4, tempStacks, facing.method_10153(), blocksToNotAdd));
        for (int i = 0; i < tempStacks.size(); ++i) {
            class_1799 stack = tempStacks.get(i);
            if (stack.method_7909() != class_1792.method_7867((class_2248)class_2246.field_9983)) continue;
            tempStacks.remove(i);
            --i;
        }
        pos = pos.method_10084();
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.method_10170(), pos.method_10079(facing.method_10153(), 2).method_10093(facing.method_10160()), class_2246.field_10124, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.method_10170(), pos.method_10079(facing.method_10153(), 3).method_10093(facing.method_10160()), class_2246.field_10340, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.method_10079(facing.method_10153(), 2).method_10093(facing.method_10170()), class_2246.field_10124, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.method_10079(facing.method_10153(), 2).method_10079(facing.method_10170(), 2), class_2246.field_10340, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.method_10160(), pos.method_10093(facing).method_10093(facing.method_10170()), class_2246.field_10124, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.method_10160(), pos.method_10079(facing, 2).method_10093(facing.method_10170()), class_2246.field_10340, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.method_10153(), pos.method_10093(facing).method_10093(facing.method_10160()), class_2246.field_10124, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.method_10153(), pos.method_10079(facing, 1).method_10079(facing.method_10160(), 2), class_2246.field_10340, blocksToNotAdd));
        for (class_1799 tempStack : tempStacks) {
            boolean foundStack = false;
            for (class_1799 existingStack : stacks) {
                if (!class_1799.method_7987((class_1799)existingStack, (class_1799)tempStack) || existingStack.method_7947() + tempStack.method_7947() > tempStack.method_7914()) continue;
                existingStack.method_7939(existingStack.method_7947() + tempStack.method_7947());
                foundStack = true;
                break;
            }
            if (foundStack) continue;
            stacks.add(tempStack);
        }
        class_2680 blockState = class_2246.field_10336.method_9564();
        BuildingMethods.ReplaceBlock((class_1937)world, pos.method_10093(facing.method_10160()), blockState);
        if (Prefab.serverConfiguration.includeMineshaftChest) {
            class_2680 chestState = (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)facing);
            BuildingMethods.ReplaceBlock((class_1937)world, pos.method_10093(facing.method_10170()), chestState);
            if (stacks.size() > 27) {
                BuildingMethods.ReplaceBlock((class_1937)world, pos.method_10093(facing.method_10170()).method_10093(facing.method_10153()), chestState);
            }
            class_2586 tileEntity = world.method_8321(pos.method_10093(facing.method_10170()));
            class_2586 tileEntity2 = world.method_8321(pos.method_10093(facing.method_10170()).method_10093(facing.method_10153()));
            if (tileEntity instanceof class_2595) {
                class_2595 chestTile = (class_2595)tileEntity;
                class_2595 chestTile2 = (class_2595)tileEntity2;
                int i = 0;
                boolean fillSecond = false;
                for (class_1799 stack : stacks) {
                    if (i == 27 && !fillSecond) {
                        fillSecond = true;
                        i = 0;
                        chestTile = chestTile2;
                    }
                    if (i >= 27 && fillSecond) break;
                    chestTile.method_5447(i, stack);
                    ++i;
                }
            }
        }
    }

    private static Tuple<ArrayList<class_1799>, ArrayList<class_2338>> CreateLadderShaft(class_3218 world, class_2338 pos, ArrayList<class_1799> originalStacks, class_2350 houseFacing, ArrayList<class_1792> blocksToNotAdd) {
        int torchCounter = 0;
        class_2350 westWall = houseFacing.method_10160();
        class_2680 ladderState = (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)houseFacing);
        BuildingMethods.ReplaceBlock((class_1937)world, pos, class_2246.field_10124);
        ArrayList<class_2338> torchPositions = new ArrayList<class_2338>();
        while (pos.method_10264() > 8) {
            class_2680 state = world.method_8320(pos);
            class_2248 block = state.method_26204();
            ++torchCounter;
            for (int i = 0; i < 4; ++i) {
                class_2350 facing = houseFacing;
                switch (i) {
                    case 1: {
                        facing = houseFacing.method_10170();
                        break;
                    }
                    case 2: {
                        facing = houseFacing.method_10153();
                        break;
                    }
                    case 3: {
                        facing = houseFacing.method_10160();
                        break;
                    }
                    default: {
                        facing = houseFacing;
                    }
                }
                if (facing == westWall && torchCounter == 6 && pos.method_10264() > 14) {
                    for (int j = 0; j <= 2; ++j) {
                        class_2338 tempPos = null;
                        class_2680 surroundingState = null;
                        class_2248 surroundingBlock = null;
                        if (j == 0) {
                            tempPos = pos.method_10079(facing, 2);
                            surroundingState = world.method_8320(tempPos);
                            surroundingBlock = surroundingState.method_26204();
                        } else if (j == 1) {
                            tempPos = pos.method_10093(facing).method_10093(facing.method_10170());
                            surroundingState = world.method_8320(tempPos);
                            surroundingBlock = surroundingState.method_26204();
                        } else {
                            tempPos = pos.method_10093(facing).method_10093(facing.method_10160());
                            surroundingState = world.method_8320(tempPos);
                            surroundingBlock = surroundingState.method_26204();
                        }
                        if (surroundingBlock == class_2246.field_10340 || surroundingBlock == class_2246.field_10115 || surroundingBlock == class_2246.field_10508 || surroundingBlock == class_2246.field_10474) continue;
                        originalStacks = BuildingMethods.ConsolidateDrops(world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                        BuildingMethods.ReplaceBlock((class_1937)world, tempPos, class_2246.field_10340);
                    }
                    torchPositions.add(pos.method_10093(facing));
                    torchCounter = 0;
                    continue;
                }
                class_2338 tempPos = pos.method_10093(facing);
                class_2680 surroundingState = world.method_8320(tempPos);
                class_2248 surroundingBlock = surroundingState.method_26204();
                if (surroundingState.method_26216((class_1922)world, tempPos) && !(surroundingBlock instanceof class_2404)) continue;
                originalStacks = BuildingMethods.ConsolidateDrops(world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                BuildingMethods.ReplaceBlock((class_1937)world, tempPos, class_2246.field_10340);
            }
            originalStacks = BuildingMethods.ConsolidateDrops(world, pos, state, originalStacks, blocksToNotAdd);
            if (pos.method_10264() >= 10) {
                BuildingMethods.ReplaceBlock((class_1937)world, pos, ladderState);
            }
            pos = pos.method_10074();
        }
        return new Tuple<ArrayList<class_1799>, ArrayList<class_2338>>(originalStacks, torchPositions);
    }
}

