/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Triple;
import com.wuest.prefab.ZipUtil;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildEntity;
import com.wuest.prefab.structures.base.BuildProperty;
import com.wuest.prefab.structures.base.BuildTileEntity;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.events.StructureEventHandler;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2185;
import net.minecraft.class_2189;
import net.minecraft.class_2231;
import net.minecraft.class_2241;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2269;
import net.minecraft.class_2301;
import net.minecraft.class_2311;
import net.minecraft.class_2312;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2377;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2381;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_2401;
import net.minecraft.class_2404;
import net.minecraft.class_2457;
import net.minecraft.class_2459;
import net.minecraft.class_2465;
import net.minecraft.class_2468;
import net.minecraft.class_2476;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2523;
import net.minecraft.class_2527;
import net.minecraft.class_2541;
import net.minecraft.class_2561;
import net.minecraft.class_2577;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3614;
import net.minecraft.class_3749;
import net.minecraft.class_3866;

public class Structure {
    public ArrayList<class_2338> allBlockPositions = new ArrayList();
    public ArrayList<class_2338> clearedBlockPos = new ArrayList();
    public ArrayList<BuildBlock> priorityOneBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityTwoBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityThreeBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityFourBlocks = new ArrayList();
    public ArrayList<BuildBlock> priorityFiveBlocks = new ArrayList();
    public ArrayList<BuildBlock> airBlocks = new ArrayList();
    public StructureConfiguration configuration;
    public class_3218 world;
    public class_2338 originalPos;
    public class_2350 assumedNorth;
    public boolean hasAirBlocks = false;
    public boolean entitiesRemoved = false;
    @Expose
    public ArrayList<BuildTileEntity> tileEntities = new ArrayList();
    @Expose
    public ArrayList<BuildEntity> entities = new ArrayList();
    @Expose
    private String name;
    @Expose
    private BuildClear clearSpace;
    @Expose
    private ArrayList<BuildBlock> blocks;

    public Structure() {
        this.Initialize();
    }

    public static <T extends Structure> T CreateInstance(String resourceLocation, Class<? extends Structure> child) {
        Structure structure = null;
        Gson file = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        structure = (Structure)file.fromJson(ZipUtil.decompressResource(resourceLocation), child);
        return (T)structure;
    }

    public static void CreateStructureFile(Structure structure, String fileLocation) {
        try {
            Gson converter = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
            StringWriter stringWriter = new StringWriter();
            converter.toJson((Object)structure, (Appendable)stringWriter);
            ZipUtil.zipStringToFile(stringWriter.toString(), fileLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ScanStructure(class_1937 world, class_2338 originalPos, class_2338 cornerPos1, class_2338 cornerPos2, String fileLocation, BuildClear clearedSpace, class_2350 playerFacing, boolean includeAir, boolean excludeWater) {
        Structure scannedStructure = new Structure();
        scannedStructure.setClearSpace(clearedSpace);
        for (class_2338 currentPos : class_2338.method_10097((class_2338)cornerPos1, (class_2338)cornerPos2)) {
            if (world.method_22347(currentPos) && !includeAir) continue;
            class_2680 currentState = world.method_8320(currentPos);
            class_2248 currentBlock = currentState.method_26204();
            if (currentState.method_26207() == class_3614.field_15920 && excludeWater) continue;
            BuildBlock buildBlock = Structure.createBuildBlockFromBlockState(currentState, currentBlock, currentPos, originalPos);
            if (currentBlock instanceof class_2323) {
                class_2756 blockHalf = (class_2756)currentState.method_11654((class_2769)class_2323.field_10946);
                if (blockHalf != class_2756.field_12607) continue;
                class_2680 upperHalfState = world.method_8320(currentPos.method_10084());
                if (upperHalfState.method_26204() instanceof class_2323) {
                    class_2248 upperBlock = upperHalfState.method_26204();
                    BuildBlock upperHalf = Structure.createBuildBlockFromBlockState(upperHalfState, upperBlock, currentPos.method_10084(), originalPos);
                    buildBlock.setSubBlock(upperHalf);
                }
            } else if (currentBlock instanceof class_2244) {
                class_2742 bedPart = (class_2742)currentState.method_11654((class_2769)class_2244.field_9967);
                if (bedPart != class_2742.field_12560) continue;
                class_2680 bedFoot = null;
                boolean foundFoot = false;
                class_2350 facing = class_2350.field_11043;
                while (!foundFoot) {
                    bedFoot = world.method_8320(currentPos.method_10093(facing));
                    if (bedFoot.method_26204() instanceof class_2244 && bedFoot.method_11654((class_2769)class_2244.field_9967) == class_2742.field_12557) {
                        foundFoot = true;
                        break;
                    }
                    if ((facing = facing.method_10170()) != class_2350.field_11043) continue;
                }
                if (foundFoot) {
                    class_2248 footBedBlock = bedFoot.method_26204();
                    BuildBlock bed = Structure.createBuildBlockFromBlockState(bedFoot, footBedBlock, currentPos.method_10093(facing), originalPos);
                    buildBlock.setSubBlock(bed);
                }
            }
            scannedStructure.getBlocks().add(buildBlock);
            class_2586 tileEntity = world.method_8321(currentPos);
            if (tileEntity == null || tileEntity instanceof class_2595 && ((class_2595)tileEntity).method_5442() || tileEntity instanceof class_3866 && ((class_3866)tileEntity).method_5442()) continue;
            class_2960 resourceLocation = class_2378.field_11137.method_10221((Object)tileEntity.method_11017());
            class_2487 tagCompound = new class_2487();
            tagCompound = tileEntity.method_11007(tagCompound);
            BuildTileEntity buildTileEntity = new BuildTileEntity();
            assert (resourceLocation != null);
            buildTileEntity.setEntityDomain(resourceLocation.method_12836());
            buildTileEntity.setEntityName(resourceLocation.method_12832());
            buildTileEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
            buildTileEntity.setEntityNBTData(tagCompound);
            scannedStructure.tileEntities.add(buildTileEntity);
        }
        int x_radiusRangeBegin = Math.min(cornerPos1.method_10263(), cornerPos2.method_10263());
        int x_radiusRangeEnd = Math.max(cornerPos1.method_10263(), cornerPos2.method_10263());
        int y_radiusRangeBegin = Math.min(cornerPos1.method_10264(), cornerPos2.method_10264());
        int y_radiusRangeEnd = Math.max(cornerPos1.method_10264(), cornerPos2.method_10264());
        int z_radiusRangeBegin = Math.min(cornerPos1.method_10260(), cornerPos2.method_10260());
        int z_radiusRangeEnd = Math.max(cornerPos1.method_10260(), cornerPos2.method_10260());
        class_238 axis = new class_238(cornerPos1, cornerPos2);
        for (class_1297 entity : world.method_8335(null, axis)) {
            class_2338 entityPos = entity.method_24515();
            if (entity instanceof class_1530) {
                entityPos = ((class_1530)entity).method_6896();
            }
            if (entityPos.method_10263() < x_radiusRangeBegin || entityPos.method_10263() > x_radiusRangeEnd || entityPos.method_10260() < z_radiusRangeBegin || entityPos.method_10260() > z_radiusRangeEnd || entityPos.method_10264() < y_radiusRangeBegin || entityPos.method_10264() > y_radiusRangeEnd) continue;
            BuildEntity buildEntity = new BuildEntity();
            buildEntity.setEntityResourceString(class_2378.field_11145.method_10221((Object)entity.method_5864()));
            buildEntity.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(entityPos, originalPos));
            buildEntity.entityXAxisOffset = (double)entityPos.method_10263() - entity.method_19538().method_10216();
            buildEntity.entityYAxisOffset = (double)entityPos.method_10264() - entity.method_19538().method_10214();
            buildEntity.entityZAxisOffset = (double)entityPos.method_10260() - entity.method_19538().method_10215();
            if (entity instanceof class_1533) {
                buildEntity.entityYAxisOffset *= -1.0;
            }
            if (entity instanceof class_1530) {
                buildEntity.entityFacing = entity.method_5735().method_15434();
            }
            class_2487 entityTagCompound = new class_2487();
            entityTagCompound = entity.method_5647(entityTagCompound);
            buildEntity.setEntityNBTData(entityTagCompound);
            scannedStructure.entities.add(buildEntity);
        }
        Structure.CreateStructureFile(scannedStructure, fileLocation);
    }

    public static BuildBlock createBuildBlockFromBlockState(class_2680 currentState, class_2248 currentBlock, class_2338 currentPos, class_2338 originalPos) {
        BuildBlock buildBlock = new BuildBlock();
        class_2960 blockIdentifier = class_2378.field_11146.method_10221((Object)currentBlock);
        buildBlock.setBlockDomain(blockIdentifier.method_12836());
        buildBlock.setBlockName(blockIdentifier.method_12832());
        buildBlock.setStartingPosition(Structure.getStartingPositionFromOriginalAndCurrentPosition(currentPos, originalPos));
        buildBlock.blockPos = currentPos;
        Collection properties = currentState.method_28501();
        for (class_2769 entry : properties) {
            BuildProperty property = new BuildProperty();
            property.setName(entry.method_11899());
            Comparable value = currentState.method_11654(entry);
            try {
                if (currentBlock instanceof class_2465 && property.getName().equals("axis")) {
                    property.setValue(((class_2350.class_2351)value).method_15434());
                } else if (currentBlock instanceof class_2577 && property.getName().equals("color")) {
                    class_1767 dyeColor = (class_1767)value;
                    property.setValue(dyeColor.method_15434());
                } else if (value instanceof class_3542) {
                    class_3542 stringSerializable = (class_3542)value;
                    property.setValue(stringSerializable.method_15434());
                } else {
                    property.setValue(value.toString());
                }
            }
            catch (Exception ex) {
                Prefab.logger.error("Unable to set property [" + property.getName() + "] to value [" + value + "] for Block [" + buildBlock.getBlockDomain() + ":" + buildBlock.getBlockName() + "].");
                throw ex;
            }
            buildBlock.getProperties().add(property);
        }
        return buildBlock;
    }

    public static PositionOffset getStartingPositionFromOriginalAndCurrentPosition(class_2338 currentPos, class_2338 originalPos) {
        PositionOffset positionOffSet = new PositionOffset();
        if (currentPos.method_10263() > originalPos.method_10263()) {
            positionOffSet.setEastOffset(currentPos.method_10263() - originalPos.method_10263());
        } else {
            positionOffSet.setWestOffset(originalPos.method_10263() - currentPos.method_10263());
        }
        if (currentPos.method_10260() > originalPos.method_10260()) {
            positionOffSet.setSouthOffset(currentPos.method_10260() - originalPos.method_10260());
        } else {
            positionOffSet.setNorthOffset(originalPos.method_10260() - currentPos.method_10260());
        }
        positionOffSet.setHeightOffset(currentPos.method_10264() - originalPos.method_10264());
        return positionOffSet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public BuildClear getClearSpace() {
        return this.clearSpace;
    }

    public void setClearSpace(BuildClear value) {
        this.clearSpace = value;
    }

    public ArrayList<BuildBlock> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<BuildBlock> value) {
        this.blocks = value;
    }

    public void Initialize() {
        this.name = "";
        this.clearSpace = new BuildClear();
        this.blocks = new ArrayList();
    }

    public boolean BuildStructure(StructureConfiguration configuration, class_3218 world, class_2338 originalPos, class_2350 assumedNorth, class_1657 player) {
        class_2338 endBlockPos;
        class_2338 startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
        Triple<Boolean, class_2680, class_2338> checkResult = BuildingMethods.CheckBuildSpaceForAllowedBlockReplacement(world, startBlockPos, endBlockPos = startBlockPos.method_10079(configuration.houseFacing.method_10160(), this.clearSpace.getShape().getWidth() - 1).method_10079(configuration.houseFacing.method_10153(), this.clearSpace.getShape().getWidth() - 1).method_10079(class_2350.field_11036, this.clearSpace.getShape().getHeight()), player);
        if (!checkResult.getFirst().booleanValue()) {
            class_2588 message = new class_2588("prefab.gui.structure.nobuild", new Object[]{class_2378.field_11146.method_10221((Object)checkResult.getSecond().method_26204()).toString(), checkResult.getThird().method_10263(), checkResult.getThird().method_10264(), checkResult.getThird().method_10260()});
            message.method_10862(class_2583.field_24360.method_10977(class_124.field_1060));
            player.method_7353((class_2561)message, false);
            return false;
        }
        if (!this.BeforeBuilding(configuration, (class_1937)world, originalPos, assumedNorth, player)) {
            this.ClearSpace(configuration, (class_1937)world, originalPos, assumedNorth);
            boolean blockPlacedWithCobbleStoneInstead = false;
            for (BuildBlock block : this.getBlocks()) {
                class_2248 foundBlock = (class_2248)class_2378.field_11146.method_10223(block.getResourceLocation());
                if (foundBlock != null) {
                    boolean priorityFiveBlock;
                    class_2680 blockState = foundBlock.method_9564();
                    BuildBlock subBlock = null;
                    if (this.WaterReplacedWithCobbleStone(configuration, block, (class_1937)world, originalPos, assumedNorth, foundBlock, blockState, player).booleanValue() || this.CustomBlockProcessingHandled(configuration, block, (class_1937)world, originalPos, assumedNorth, foundBlock, blockState, player).booleanValue()) continue;
                    if ((block = BuildBlock.SetBlockState(configuration, (class_1937)world, originalPos, assumedNorth, block, foundBlock, blockState, this)).getSubBlock() != null) {
                        foundBlock = (class_2248)class_2378.field_11146.method_10223(block.getSubBlock().getResourceLocation());
                        blockState = foundBlock.method_9564();
                        subBlock = BuildBlock.SetBlockState(configuration, (class_1937)world, originalPos, assumedNorth, block.getSubBlock(), foundBlock, blockState, this);
                    }
                    if (subBlock != null) {
                        block.setSubBlock(subBlock);
                    }
                    boolean priorityTwoBlock = foundBlock instanceof class_2377 || foundBlock instanceof class_2401;
                    boolean priorityThreeBlock = foundBlock instanceof class_2527 || foundBlock instanceof class_2478 || foundBlock instanceof class_2269 || foundBlock instanceof class_2244 || foundBlock instanceof class_2577 || foundBlock instanceof class_2362 || foundBlock instanceof class_2523 || foundBlock instanceof class_2231 || foundBlock instanceof class_2323 || foundBlock instanceof class_2399 || foundBlock instanceof class_2541 || foundBlock instanceof class_2457 || foundBlock instanceof class_2312 || foundBlock instanceof class_2185 || foundBlock instanceof class_3749 || foundBlock instanceof class_2381 || foundBlock instanceof class_2241;
                    boolean priorityFourBlock = foundBlock instanceof class_2468;
                    boolean bl = priorityFiveBlock = foundBlock instanceof class_2523 || foundBlock instanceof class_2266 || foundBlock instanceof class_2311 || foundBlock instanceof class_2301 || foundBlock instanceof class_2459;
                    if (!block.getHasFacing()) {
                        if (subBlock != null) {
                            block.setSubBlock(subBlock);
                        }
                        if (priorityFiveBlock) {
                            this.priorityFiveBlocks.add(block);
                            continue;
                        }
                        if (priorityFourBlock) {
                            this.priorityFourBlocks.add(block);
                            continue;
                        }
                        if (priorityThreeBlock) {
                            this.priorityThreeBlocks.add(block);
                            continue;
                        }
                        if (foundBlock instanceof class_2189) {
                            this.airBlocks.add(block);
                            continue;
                        }
                        if (foundBlock instanceof class_2343 || priorityTwoBlock) {
                            this.priorityTwoBlocks.add(block);
                            continue;
                        }
                        this.priorityOneBlocks.add(block);
                        continue;
                    }
                    if (priorityThreeBlock) {
                        this.priorityThreeBlocks.add(block);
                        continue;
                    }
                    this.priorityTwoBlocks.add(block);
                    continue;
                }
                String blockTypeNotFound = block.getResourceLocation().toString();
                block = BuildBlock.SetBlockState(configuration, (class_1937)world, originalPos, assumedNorth, block, class_2246.field_10445, class_2246.field_10445.method_9564(), this);
                this.priorityOneBlocks.add(block);
                if (blockPlacedWithCobbleStoneInstead) continue;
                blockPlacedWithCobbleStoneInstead = true;
                Prefab.logger.warn("A Block was in the structure, but it is not registered. This block was replaced with vanilla cobblestone instead. Block type not found: [" + blockTypeNotFound + "]");
            }
            this.configuration = configuration;
            this.world = world;
            this.assumedNorth = assumedNorth;
            this.originalPos = originalPos;
            if (StructureEventHandler.structuresToBuild.containsKey(player)) {
                StructureEventHandler.structuresToBuild.get(player).add(this);
            } else {
                ArrayList<Structure> structures = new ArrayList<Structure>();
                structures.add(this);
                StructureEventHandler.structuresToBuild.put(player, structures);
            }
        }
        return true;
    }

    public void BeforeClearSpaceBlockReplaced(class_2338 pos) {
    }

    public void BeforeHangingEntityRemoved(class_1530 hangingEntity) {
    }

    public class_2680 getStainedGlassBlock(FullDyeColor color) {
        switch (color) {
            case BLACK: {
                return class_2246.field_9997.method_9564();
            }
            case BLUE: {
                return class_2246.field_10060.method_9564();
            }
            case BROWN: {
                return class_2246.field_10073.method_9564();
            }
            case GRAY: {
                return class_2246.field_10555.method_9564();
            }
            case GREEN: {
                return class_2246.field_10357.method_9564();
            }
            case LIGHT_BLUE: {
                return class_2246.field_10271.method_9564();
            }
            case LIGHT_GRAY: {
                return class_2246.field_9996.method_9564();
            }
            case LIME: {
                return class_2246.field_10157.method_9564();
            }
            case MAGENTA: {
                return class_2246.field_10574.method_9564();
            }
            case ORANGE: {
                return class_2246.field_10227.method_9564();
            }
            case PINK: {
                return class_2246.field_10317.method_9564();
            }
            case PURPLE: {
                return class_2246.field_10399.method_9564();
            }
            case RED: {
                return class_2246.field_10272.method_9564();
            }
            case WHITE: {
                return class_2246.field_10087.method_9564();
            }
            case YELLOW: {
                return class_2246.field_10049.method_9564();
            }
            case CLEAR: {
                return class_2246.field_10033.method_9564();
            }
        }
        return class_2246.field_10248.method_9564();
    }

    public class_2680 getStainedGlassPaneBlock(FullDyeColor color) {
        switch (color) {
            case BLACK: {
                return class_2246.field_10070.method_9564();
            }
            case BLUE: {
                return class_2246.field_9982.method_9564();
            }
            case BROWN: {
                return class_2246.field_10163.method_9564();
            }
            case GRAY: {
                return class_2246.field_10077.method_9564();
            }
            case GREEN: {
                return class_2246.field_10419.method_9564();
            }
            case LIGHT_BLUE: {
                return class_2246.field_10193.method_9564();
            }
            case LIGHT_GRAY: {
                return class_2246.field_10129.method_9564();
            }
            case LIME: {
                return class_2246.field_10305.method_9564();
            }
            case MAGENTA: {
                return class_2246.field_10469.method_9564();
            }
            case ORANGE: {
                return class_2246.field_10496.method_9564();
            }
            case PINK: {
                return class_2246.field_10565.method_9564();
            }
            case PURPLE: {
                return class_2246.field_10152.method_9564();
            }
            case RED: {
                return class_2246.field_10118.method_9564();
            }
            case WHITE: {
                return class_2246.field_9991.method_9564();
            }
            case YELLOW: {
                return class_2246.field_10578.method_9564();
            }
            case CLEAR: {
                return class_2246.field_10285.method_9564();
            }
        }
        return class_2246.field_10355.method_9564();
    }

    protected boolean BeforeBuilding(StructureConfiguration configuration, class_1937 world, class_2338 originalPos, class_2350 assumedNorth, class_1657 player) {
        return false;
    }

    public void AfterBuilding(StructureConfiguration configuration, class_3218 world, class_2338 originalPos, class_2350 assumedNorth, class_1657 player) {
    }

    protected void ClearSpace(StructureConfiguration configuration, class_1937 world, class_2338 originalPos, class_2350 assumedNorth) {
        if (this.clearSpace.getShape().getWidth() > 0 && this.clearSpace.getShape().getLength() > 0) {
            class_2338 startBlockPos = this.clearSpace.getStartingPosition().getRelativePosition(originalPos, this.clearSpace.getShape().getDirection(), configuration.houseFacing);
            class_2338 endBlockPos = startBlockPos.method_10079(configuration.houseFacing.method_10153().method_10170(), this.clearSpace.getShape().getWidth() - 1).method_10079(configuration.houseFacing.method_10153(), this.clearSpace.getShape().getLength() - 1).method_10079(class_2350.field_11036, this.clearSpace.getShape().getHeight());
            this.clearedBlockPos = new ArrayList();
            for (class_2338 pos : class_2338.method_10097((class_2338)startBlockPos, (class_2338)endBlockPos)) {
                if (!this.BlockShouldBeClearedDuringConstruction(configuration, world, originalPos, assumedNorth, pos).booleanValue()) continue;
                this.clearedBlockPos.add(new class_2338((class_2382)pos));
                this.allBlockPositions.add(new class_2338((class_2382)pos));
            }
        } else {
            this.clearedBlockPos = new ArrayList();
        }
    }

    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, class_1937 world, class_2338 originalPos, class_2350 assumedNorth, class_2248 foundBlock, class_2680 blockState, class_1657 player) {
        return false;
    }

    protected Boolean BlockShouldBeClearedDuringConstruction(StructureConfiguration configuration, class_1937 world, class_2338 originalPos, class_2350 assumedNorth, class_2338 blockPos) {
        return true;
    }

    protected Boolean WaterReplacedWithCobbleStone(StructureConfiguration configuration, BuildBlock block, class_1937 world, class_2338 originalPos, class_2350 assumedNorth, class_2248 foundBlock, class_2680 blockState, class_1657 player) {
        boolean isOverworld = class_1937.field_25179.method_29177().toString().equals(world.method_27983().method_29177().toString());
        if (world.method_8597().method_27999() || !isOverworld && Prefab.serverConfiguration.allowWaterInNonOverworldDimensions) {
            boolean foundWaterLikeBlock;
            boolean bl = foundWaterLikeBlock = foundBlock instanceof class_2404 && blockState.method_26207() == class_3614.field_15920 || foundBlock instanceof class_2476;
            if (!foundWaterLikeBlock) {
                for (BuildProperty property : block.getProperties()) {
                    if (!property.getName().equalsIgnoreCase(class_2741.field_12508.method_11899()) || !property.getValue().equalsIgnoreCase(class_2741.field_12508.method_11826(Boolean.valueOf(true)))) continue;
                    foundWaterLikeBlock = true;
                    break;
                }
            }
            if (foundWaterLikeBlock) {
                class_2960 cobbleIdentifier = class_2378.field_11146.method_10221((Object)class_2246.field_10445);
                block.setBlockDomain(cobbleIdentifier.method_12836());
                block.setBlockName(cobbleIdentifier.method_12832());
                block.setBlockState(class_2246.field_10445.method_9564());
                this.priorityThreeBlocks.add(block);
                return true;
            }
        }
        return false;
    }
}

