/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.enums.AdvancedAquaBaseOptions;
import com.wuest.prefab.structures.config.enums.AdvancedFarmOptions;
import com.wuest.prefab.structures.config.enums.AdvancedWarehouseOptions;
import com.wuest.prefab.structures.config.enums.AquaBaseOptions;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.config.enums.DefenseBunkerOptions;
import com.wuest.prefab.structures.config.enums.EnderGatewayOptions;
import com.wuest.prefab.structures.config.enums.GrassyPlainOptions;
import com.wuest.prefab.structures.config.enums.JailOptions;
import com.wuest.prefab.structures.config.enums.MachineryTowerOptions;
import com.wuest.prefab.structures.config.enums.MagicTempleOptions;
import com.wuest.prefab.structures.config.enums.MineshaftEntranceOptions;
import com.wuest.prefab.structures.config.enums.ModerateFarmOptions;
import com.wuest.prefab.structures.config.enums.ModernBuildingsOptions;
import com.wuest.prefab.structures.config.enums.NetherGateOptions;
import com.wuest.prefab.structures.config.enums.SaloonOptions;
import com.wuest.prefab.structures.config.enums.SkiLodgeOptions;
import com.wuest.prefab.structures.config.enums.StarterFarmOptions;
import com.wuest.prefab.structures.config.enums.TownHallOptions;
import com.wuest.prefab.structures.config.enums.VillagerHouseOptions;
import com.wuest.prefab.structures.config.enums.WarehouseOptions;
import com.wuest.prefab.structures.config.enums.WatchTowerOptions;
import com.wuest.prefab.structures.config.enums.WelcomeCenterOptions;
import com.wuest.prefab.structures.config.enums.WindMillOptions;
import com.wuest.prefab.structures.config.enums.WorkshopOptions;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.predefined.StructureBasic;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class BasicStructureConfiguration
extends StructureConfiguration {
    private static final String structureEnumNameTag = "structureEnumName";
    private static final String structureDisplayNameTag = "structureDisplayName";
    private static final String bedColorTag = "bedColor";
    private static final String glassColorTag = "glassColor";
    private static final String chosenOptionTag = "chosenOption";
    public EnumBasicStructureName basicStructureName;
    public String structureDisplayName;
    public class_1767 bedColor;
    public FullDyeColor glassColor;
    public BaseOption chosenOption;

    public String getDisplayName() {
        if (this.basicStructureName == EnumBasicStructureName.Custom) {
            return this.structureDisplayName;
        }
        return this.basicStructureName.getItemTranslationString();
    }

    public boolean IsCustomStructure() {
        return this.basicStructureName == EnumBasicStructureName.Custom;
    }

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = class_2350.field_11043;
        this.basicStructureName = EnumBasicStructureName.AquaBase;
        this.bedColor = class_1767.field_7964;
        this.glassColor = FullDyeColor.CLEAR;
        this.chosenOption = this.basicStructureName.baseOption.getSpecificOptions(false).get(0);
    }

    @Override
    protected void CustomReadFromNBTTag(class_2487 messageTag, StructureConfiguration config) {
        BasicStructureConfiguration basicConfig = (BasicStructureConfiguration)config;
        if (messageTag.method_10545(structureEnumNameTag)) {
            basicConfig.basicStructureName = EnumBasicStructureName.valueOf(messageTag.method_10558(structureEnumNameTag));
        }
        if (messageTag.method_10545(structureDisplayNameTag)) {
            basicConfig.structureDisplayName = messageTag.method_10558(structureDisplayNameTag);
        }
        if (messageTag.method_10545(bedColorTag)) {
            basicConfig.bedColor = class_1767.valueOf((String)messageTag.method_10558(bedColorTag));
        }
        if (messageTag.method_10545(glassColorTag)) {
            basicConfig.glassColor = FullDyeColor.valueOf(messageTag.method_10558(glassColorTag));
        }
        if (messageTag.method_10545(chosenOptionTag)) {
            basicConfig.chosenOption = BaseOption.getOptionByTranslationString(messageTag.method_10558(chosenOptionTag));
        }
    }

    @Override
    protected class_2487 CustomWriteToCompoundNBT(class_2487 tag) {
        tag.method_10582(structureEnumNameTag, this.basicStructureName.name());
        if (this.structureDisplayName != null) {
            tag.method_10582(structureDisplayNameTag, this.structureDisplayName);
        }
        tag.method_10582(bedColorTag, this.bedColor.method_15434().toUpperCase());
        tag.method_10582(glassColorTag, this.glassColor.method_15434().toUpperCase());
        tag.method_10582(chosenOptionTag, this.chosenOption.getTranslationString());
        return tag;
    }

    @Override
    public BasicStructureConfiguration ReadFromCompoundNBT(class_2487 messageTag) {
        BasicStructureConfiguration config = new BasicStructureConfiguration();
        return (BasicStructureConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(class_1657 player, class_3218 world, class_2338 hitBlockPos) {
        StructureBasic structure;
        String assetLocation = "";
        if (!this.IsCustomStructure()) {
            assetLocation = this.chosenOption.getAssetLocation();
        }
        if ((structure = (StructureBasic)StructureBasic.CreateInstance(assetLocation, StructureBasic.class)).BuildStructure(this, world, hitBlockPos, class_2350.field_11043, player)) {
            class_1799 stack = ItemBasicStructure.getBasicStructureItemInHand(player);
            if (!stack.method_7963()) {
                if (stack.method_7947() == 1) {
                    player.method_31548().method_7378(stack);
                } else {
                    stack.method_7939(stack.method_7947() - 1);
                }
                player.field_7512.method_7623();
            } else {
                this.DamageHeldItem(player, stack.method_7909());
            }
        }
    }

    public static enum EnumBasicStructureName {
        Custom("custom", null, null, null),
        MachineryTower("machinery_tower", "item.prefab.item_machinery_tower", "item_machinery_tower", MachineryTowerOptions.Default),
        DefenseBunker("defense_bunker", "item.prefab.item_defense_bunker", "item_defense_bunker", DefenseBunkerOptions.Default),
        MineshaftEntrance("mineshaft_entrance", "item.prefab.item_mineshaft_entrance", "item_mineshaft_entrance", MineshaftEntranceOptions.Default),
        EnderGateway("ender_gateway", "item.prefab.item_ender_gateway", "item_ender_gateway", EnderGatewayOptions.Default),
        AquaBase("aqua_base", "item.prefab.item_aqua_base", "item_aqua_base", AquaBaseOptions.Default),
        GrassyPlain("grassy_plain", "item.prefab.item_grassy_plain", "item_grassy_plain", GrassyPlainOptions.Default),
        MagicTemple("magic_temple", "item.prefab.item_magic_temple", "item_magic_temple", MagicTempleOptions.Default),
        WatchTower("watch_tower", "item.prefab.item_watch_tower", "item_watch_tower", WatchTowerOptions.Default),
        WelcomeCenter("welcome_center", "item.prefab.item_welcome_center", "item_welcome_center", WelcomeCenterOptions.Default),
        Jail("jail", "item.prefab.item_jail", "item_jail", JailOptions.Default),
        Saloon("saloon", "item.prefab.item_saloon", "item_saloon", SaloonOptions.Default),
        SkiLodge("ski_lodge", "item.prefab.item_ski_lodge", "item_ski_lodge", SkiLodgeOptions.Default),
        WindMill("wind_mill", "item.prefab.item_wind_mill", "item_wind_mill", WindMillOptions.Default),
        TownHall("town_hall", "item.prefab.item_town_hall", "item_town_hall", TownHallOptions.Default),
        NetherGate("nether_gate", "item.prefab.item_nether_gate", "item_nether_gate", NetherGateOptions.AncientSkull),
        AdvancedAquaBase("advanced_aqua_base", "item.prefab.item_advanced_aqua_base", "item_advanced_aqua_base", AdvancedAquaBaseOptions.Default),
        WorkShop("workshop", "item.prefab.item_workshop", "item_workshop", WorkshopOptions.Default),
        VillagerHouses("villager_houses", "item.prefab.item_villager_houses", "item_villager_houses", VillagerHouseOptions.FLAT_ROOF),
        AdvancedWarehouse("advanced_warehouse", "item.prefab.item_advanced_warehouse", "item_advanced_warehouse", AdvancedWarehouseOptions.Default),
        Warehouse("warehouse", "item.prefab.item_warehouse", "item_warehouse", WarehouseOptions.Default),
        ModernBuildings("modern_buildings", "item.prefab.item_modern_buildings", "item_modern_buildings", ModernBuildingsOptions.Mall),
        StarterFarm("starter_farm", "item.prefab.item_starter_farm", "item_starter_farm", StarterFarmOptions.ElevatedFarm),
        ModerateFarm("moderate_farm", "item.prefab.item_moderate_farm", "item_moderate_farm", ModerateFarmOptions.AutomatedFarm),
        AdvancedFarm("advanced_farm", "item.prefab.item_advanced_farm", "item_advanced_farm", AdvancedFarmOptions.AutomatedBeeFarm);

        private final String name;
        private final String itemTranslationString;
        private final BaseOption baseOption;
        private class_2960 itemTextureLocation;

        private EnumBasicStructureName(String name, String itemTranslationString, String itemTextureLocation, BaseOption baseOption) {
            this.name = name;
            this.itemTranslationString = itemTranslationString;
            if (itemTextureLocation != null) {
                this.itemTextureLocation = new class_2960("prefab", itemTextureLocation);
            }
            this.baseOption = baseOption;
        }

        public String getName() {
            return this.name;
        }

        public String getItemTranslationString() {
            return this.itemTranslationString;
        }

        public class_2960 getItemTextureLocation() {
            return this.itemTextureLocation;
        }

        public BaseOption getBaseOption() {
            return this.baseOption;
        }
    }
}

