/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.network.message.PlayerEntityTagMessage;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.predefined.StructureAlternateStart;
import io.netty.buffer.Unpooled;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class HouseConfiguration
extends StructureConfiguration {
    private static String addTorchesTag = "addTorches";
    private static String addBedTag = "addBed";
    private static String addCraftingTableTag = "addCraftingTable";
    private static String addFurnaceTag = "addFurnace";
    private static String addChestTag = "addChest";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineShaftTag = "addMineShaft";
    private static String hitXTag = "hitX";
    private static String hitYTag = "hitY";
    private static String hitZTag = "hitZ";
    private static String houseFacingTag = "houseFacing";
    private static String houseStyleTag = "houseStyle";
    private static String glassColorTag = "glassColor";
    private static String bedColorTag = "bedColor";
    public boolean addTorches;
    public boolean addBed;
    public boolean addCraftingTable;
    public boolean addFurnace;
    public boolean addChest;
    public boolean addChestContents;
    public boolean addMineShaft;
    public HouseStyle houseStyle;
    public FullDyeColor glassColor;
    public class_1767 bedColor;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.BASIC;
        this.glassColor = FullDyeColor.LIGHT_GRAY;
        this.bedColor = class_1767.field_7964;
        this.addTorches = true;
        this.addBed = true;
        this.addCraftingTable = true;
        this.addFurnace = true;
        this.addChest = true;
        this.addChestContents = true;
        this.addMineShaft = true;
    }

    @Override
    public class_2487 WriteToCompoundNBT() {
        class_2487 tag = new class_2487();
        tag.method_10556(addTorchesTag, this.addTorches);
        tag.method_10556(addBedTag, this.addBed);
        tag.method_10556(addCraftingTableTag, this.addCraftingTable);
        tag.method_10556(addFurnaceTag, this.addFurnace);
        tag.method_10556(addChestTag, this.addChest);
        tag.method_10556(addChestContentsTag, this.addChestContents);
        tag.method_10556(addMineShaftTag, this.addMineShaft);
        tag.method_10569(hitXTag, this.pos.method_10263());
        tag.method_10569(hitYTag, this.pos.method_10264());
        tag.method_10569(hitZTag, this.pos.method_10260());
        tag.method_10582(houseFacingTag, this.houseFacing.method_15434());
        tag.method_10569(houseStyleTag, this.houseStyle.value);
        tag.method_10582(glassColorTag, this.glassColor.method_15434().toUpperCase());
        tag.method_10582(bedColorTag, this.bedColor.method_15434().toUpperCase());
        return tag;
    }

    @Override
    public HouseConfiguration ReadFromCompoundNBT(class_2487 tag) {
        HouseConfiguration config = null;
        if (tag != null) {
            config = new HouseConfiguration();
            if (tag.method_10545(addTorchesTag)) {
                config.addTorches = tag.method_10577(addTorchesTag);
            }
            if (tag.method_10545(addBedTag)) {
                config.addBed = tag.method_10577(addBedTag);
            }
            if (tag.method_10545(addCraftingTableTag)) {
                config.addCraftingTable = tag.method_10577(addCraftingTableTag);
            }
            if (tag.method_10545(addFurnaceTag)) {
                config.addFurnace = tag.method_10577(addFurnaceTag);
            }
            if (tag.method_10545(addChestTag)) {
                config.addChest = tag.method_10577(addChestTag);
            }
            if (tag.method_10545(addChestContentsTag)) {
                config.addChestContents = tag.method_10577(addChestContentsTag);
            }
            if (tag.method_10545(addMineShaftTag)) {
                config.addMineShaft = tag.method_10577(addMineShaftTag);
            }
            if (tag.method_10545(hitXTag)) {
                config.pos = new class_2338(tag.method_10550(hitXTag), tag.method_10550(hitYTag), tag.method_10550(hitZTag));
            }
            if (tag.method_10545(houseFacingTag)) {
                config.houseFacing = BuildBlock.getDirectionByName(tag.method_10558(houseFacingTag));
            }
            if (tag.method_10545(houseStyleTag)) {
                config.houseStyle = HouseStyle.ValueOf(tag.method_10550(houseStyleTag));
            }
            if (tag.method_10545(glassColorTag)) {
                config.glassColor = FullDyeColor.valueOf(tag.method_10558(glassColorTag));
            }
            if (tag.method_10545(bedColorTag)) {
                config.bedColor = class_1767.valueOf((String)tag.method_10558(bedColorTag));
            }
        }
        return config;
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(class_1657 player, class_3218 world, class_2338 hitBlockPos) {
        boolean houseBuilt = true;
        StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(this.houseStyle.getStructureLocation(), StructureAlternateStart.class);
        houseBuilt = structure.BuildStructure(this, world, hitBlockPos, class_2350.field_11043, player);
        if (houseBuilt) {
            EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntity(player);
            playerConfig.builtStarterHouse = true;
            this.RemoveStructureItemFromPlayer(player, ModRegistry.StartHouse);
            PlayerEntityTagMessage message = new PlayerEntityTagMessage();
            message.setMessageTag(playerConfig.createPlayerTag());
            class_2540 byteBuf = new class_2540(Unpooled.buffer());
            PlayerEntityTagMessage.encode(message, byteBuf);
            ServerSidePacketRegistry.INSTANCE.sendToPlayer(player, ModRegistry.PlayerConfigSync, byteBuf);
        }
    }

    public static enum HouseStyle {
        BASIC(0, "prefab.gui.starter.basic.display", new class_2960("prefab", "textures/gui/basic_house.png"), "assets/prefab/structures/basic_house.zip"),
        RANCH(1, "prefab.gui.starter.ranch.display", new class_2960("prefab", "textures/gui/ranch_house.png"), "assets/prefab/structures/ranch_house.zip"),
        LOFT(2, "prefab.gui.starter.loft.display", new class_2960("prefab", "textures/gui/loft_house.png"), "assets/prefab/structures/loft_house.zip"),
        HOBBIT(3, "prefab.gui.starter.hobbit.display", new class_2960("prefab", "textures/gui/hobbit_house.png"), "assets/prefab/structures/hobbit_house.zip"),
        DESERT(4, "prefab.gui.starter.desert.display", new class_2960("prefab", "textures/gui/desert_house.png"), "assets/prefab/structures/desert_house.zip"),
        SNOWY(5, "prefab.gui.starter.snowy.display", new class_2960("prefab", "textures/gui/snowy_house.png"), "assets/prefab/structures/snowy_house.zip"),
        DESERT2(6, "prefab.gui.starter.desert.display2", new class_2960("prefab", "textures/gui/desert_house2.png"), "assets/prefab/structures/desert_house2.zip"),
        SUBAQUATIC(7, "prefab.gui.starter.subaquatic.display", new class_2960("prefab", "textures/gui/subaquatic_house.png"), "assets/prefab/structures/subaquatic_house.zip"),
        MODERN(8, "prefab.gui.starter.modern.display", new class_2960("prefab", "textures/gui/modern_starting_house.png"), "assets/prefab/structures/modern_starting_house.zip"),
        CAMPSITE(9, "prefab.gui.starter.camping.display", new class_2960("prefab", "textures/gui/campsite_house.png"), "assets/prefab/structures/campsite_house.zip");

        private final int value;
        private final String displayName;
        private final class_2960 housePicture;
        private final String structureLocation;

        private HouseStyle(int newValue, String displayName, class_2960 housePicture, String structureLocation) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
        }

        public static HouseStyle ValueOf(int value) {
            HouseStyle returnValue = BASIC;
            for (HouseStyle current : HouseStyle.values()) {
                if (current.value != value) continue;
                returnValue = current;
                break;
            }
            return returnValue;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public class_2960 getHousePicture() {
            return this.housePicture;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

