/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.structures.base.EnumStructureMaterial;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.predefined.StructureInstantBridge;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class InstantBridgeConfiguration
extends StructureConfiguration {
    public int bridgeLength;
    public EnumStructureMaterial bridgeMaterial;
    public boolean includeRoof;
    public int interiorHeight;

    @Override
    public void Initialize() {
        super.Initialize();
        this.bridgeLength = 25;
        this.bridgeMaterial = EnumStructureMaterial.Cobblestone;
        this.interiorHeight = 3;
        this.includeRoof = true;
    }

    @Override
    public InstantBridgeConfiguration ReadFromCompoundNBT(class_2487 messageTag) {
        InstantBridgeConfiguration config = new InstantBridgeConfiguration();
        return (InstantBridgeConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(class_1657 player, class_3218 world, class_2338 hitBlockPos) {
        StructureInstantBridge structure = StructureInstantBridge.CreateInstance();
        if (structure.BuildStructure(this, world, hitBlockPos, class_2350.field_11043, player)) {
            this.DamageHeldItem(player, ModRegistry.InstantBridge);
        }
    }

    @Override
    protected class_2487 CustomWriteToCompoundNBT(class_2487 tag) {
        tag.method_10569("bridgeLength", this.bridgeLength);
        tag.method_10569("bridgeMaterial", this.bridgeMaterial.getNumber());
        tag.method_10556("includeRoof", this.includeRoof);
        tag.method_10569("interiorHeight", this.interiorHeight);
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(class_2487 messageTag, StructureConfiguration config) {
        if (messageTag.method_10545("bridgeLength")) {
            ((InstantBridgeConfiguration)config).bridgeLength = messageTag.method_10550("bridgeLength");
        }
        if (messageTag.method_10545("bridgeMaterial")) {
            ((InstantBridgeConfiguration)config).bridgeMaterial = EnumStructureMaterial.getMaterialByNumber(messageTag.method_10550("bridgeMaterial"));
        }
        if (messageTag.method_10545("includeRoof")) {
            ((InstantBridgeConfiguration)config).includeRoof = messageTag.method_10577("includeRoof");
        }
        if (messageTag.method_10545("interiorHeight")) {
            ((InstantBridgeConfiguration)config).interiorHeight = messageTag.method_10550("interiorHeight");
        }
    }
}

