/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.predefined.StructureModerateHouse;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;

public class ModerateHouseConfiguration
extends StructureConfiguration {
    public static String tagKey = "houseConfig";
    private static String houseStyleTag = "houseStyle";
    private static String addChestTag = "addChests";
    private static String addChestContentsTag = "addChestContents";
    private static String addMineshaftTag = "addMineshaft";
    private static String bedColorTag = "bedColor";
    public HouseStyle houseStyle = HouseStyle.SPRUCE_HOME;
    public boolean addChests = true;
    public boolean addChestContents = true;
    public boolean addMineshaft = true;
    public class_1767 bedColor = class_1767.field_7964;

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseStyle = HouseStyle.SPRUCE_HOME;
        this.bedColor = class_1767.field_7964;
    }

    @Override
    protected class_2487 CustomWriteToCompoundNBT(class_2487 tag) {
        tag.method_10569(houseStyleTag, this.houseStyle.value);
        tag.method_10556(addChestTag, this.addChests);
        tag.method_10556(addChestContentsTag, this.addChestContents);
        tag.method_10556(addMineshaftTag, this.addMineshaft);
        tag.method_10582(bedColorTag, this.bedColor.method_15434().toUpperCase());
        return tag;
    }

    @Override
    protected void CustomReadFromNBTTag(class_2487 messageTag, StructureConfiguration config) {
        ModerateHouseConfiguration houseConfiguration = (ModerateHouseConfiguration)config;
        if (messageTag.method_10545(houseStyleTag)) {
            houseConfiguration.houseStyle = HouseStyle.ValueOf(messageTag.method_10550(houseStyleTag));
        }
        if (messageTag.method_10545(addChestTag)) {
            houseConfiguration.addChests = messageTag.method_10577(addChestTag);
        }
        if (messageTag.method_10545(addChestContentsTag)) {
            houseConfiguration.addChestContents = messageTag.method_10577(addChestContentsTag);
        }
        if (messageTag.method_10545(addMineshaftTag)) {
            houseConfiguration.addMineshaft = messageTag.method_10577(addMineshaftTag);
        }
        if (messageTag.method_10545(bedColorTag)) {
            houseConfiguration.bedColor = class_1767.valueOf((String)messageTag.method_10558(bedColorTag));
        }
    }

    @Override
    public ModerateHouseConfiguration ReadFromCompoundNBT(class_2487 messageTag) {
        ModerateHouseConfiguration config = new ModerateHouseConfiguration();
        return (ModerateHouseConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(class_1657 player, class_3218 world, class_2338 hitBlockPos) {
        StructureModerateHouse structure = (StructureModerateHouse)StructureModerateHouse.CreateInstance(this.houseStyle.getStructureLocation(), StructureModerateHouse.class);
        if (structure.BuildStructure(this, world, hitBlockPos, class_2350.field_11043, player)) {
            this.RemoveStructureItemFromPlayer(player, ModRegistry.ModerateHouse);
        }
    }

    public static enum HouseStyle {
        SPRUCE_HOME(0, "prefab.gui.moderate_house.spruce", new class_2960("prefab", "textures/gui/moderate_house_spruce_topdown.png"), "assets/prefab/structures/moderate_house_spruce.zip", 31, 31, 23, 8, 1),
        ACACIA_HOME(1, "prefab.gui.moderate_house.acacia", new class_2960("prefab", "textures/gui/moderate_house_acacia_topdown.png"), "assets/prefab/structures/moderate_house_acacia.zip", 31, 31, 21, 12, 6),
        EARTHEN_HOME(2, "prefab.gui.moderate_house.earthen", new class_2960("prefab", "textures/gui/moderate_house_earthen_topdown.png"), "assets/prefab/structures/moderate_house_earthen.zip", 16, 16, 16, 8, 6),
        JUNGLE_TREE_HOME(3, "prefab.gui.moderate_house.jungle", new class_2960("prefab", "textures/gui/moderate_house_jungle_topdown.png"), "assets/prefab/structures/moderate_house_jungle.zip", 16, 16, 41, 8, 1),
        NETHER_HOME(4, "prefab.gui.moderate_house.nether", new class_2960("prefab", "textures/gui/moderate_house_nether_topdown.png"), "assets/prefab/structures/moderate_house_nether.zip", 16, 15, 22, 0, 0),
        MOUNTAIN_HOME(5, "prefab.gui.moderate_house.mountain", new class_2960("prefab", "textures/gui/moderate_house_mountain_topdown.png"), "assets/prefab/structures/moderate_house_mountain.zip", 20, 21, 12, 10, 0),
        ACACIA_HOME2(6, "prefab.gui.moderate_house.acacia_2", new class_2960("prefab", "textures/gui/moderate_house_acacia_2_topdown.png"), "assets/prefab/structures/moderate_house_acacia_2.zip", 31, 31, 21, 12, 6);

        private final int value;
        private final String displayName;
        private final class_2960 housePicture;
        private final String structureLocation;
        private final int width;
        private final int length;
        private final int height;
        private final int eastOffSet;
        private final int downOffSet;

        private HouseStyle(int newValue, String displayName, class_2960 housePicture, String structureLocation, int width, int length, int height, int eastOffSet, int downOffSet) {
            this.value = newValue;
            this.displayName = displayName;
            this.housePicture = housePicture;
            this.structureLocation = structureLocation;
            this.width = width;
            this.length = length;
            this.height = height;
            this.eastOffSet = eastOffSet;
            this.downOffSet = downOffSet;
        }

        public static HouseStyle ValueOf(int value) {
            for (HouseStyle currentValue : HouseStyle.values()) {
                if (currentValue.value != value) continue;
                return currentValue;
            }
            return SPRUCE_HOME;
        }

        public int getValue() {
            return this.value;
        }

        public String getDisplayName() {
            return GuiLangKeys.translateString(this.displayName);
        }

        public class_2960 getHousePicture() {
            return this.housePicture;
        }

        public int getWidth() {
            return this.width;
        }

        public int getLength() {
            return this.length;
        }

        public int getHeight() {
            return this.height;
        }

        public int getEastOffSet() {
            return this.eastOffSet;
        }

        public int getDownOffSet() {
            return this.downOffSet;
        }

        public String getStructureLocation() {
            return this.structureLocation;
        }
    }
}

