/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.events;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.config.ModConfiguration;
import com.wuest.prefab.network.message.PlayerEntityTagMessage;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildEntity;
import com.wuest.prefab.structures.base.BuildTileEntity;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1530;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2185;
import net.minecraft.class_2231;
import net.minecraft.class_2241;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2312;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_238;
import net.minecraft.class_2399;
import net.minecraft.class_2401;
import net.minecraft.class_2457;
import net.minecraft.class_2470;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2523;
import net.minecraft.class_2527;
import net.minecraft.class_2540;
import net.minecraft.class_2541;
import net.minecraft.class_2577;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_3749;

public final class StructureEventHandler {
    public static HashMap<class_1657, ArrayList<Structure>> structuresToBuild = new HashMap();
    public static ArrayList<Tuple<Structure, BuildEntity>> entitiesToGenerate = new ArrayList();
    public static int ticksSinceLastEntitiesGenerated = 0;

    public static void registerStructureServerSideEvents() {
        StructureEventHandler.playerJoinedServer();
        StructureEventHandler.serverStarted();
        StructureEventHandler.serverStopped();
        StructureEventHandler.serverTick();
    }

    private static void playerJoinedServer() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, serverWorld) -> {
            if (entity instanceof class_3222) {
                StructureEventHandler.playerLoggedIn((class_3222)entity, serverWorld);
            }
        });
    }

    private static void serverTick() {
        ServerTickEvents.END_SERVER_TICK.register(server -> StructureEventHandler.onServerTick());
    }

    private static void serverStarted() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> EntityPlayerConfiguration.playerTagData.clear());
    }

    private static void serverStopped() {
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> EntityPlayerConfiguration.playerTagData.clear());
    }

    public static void playerLoggedIn(class_3222 player, class_3218 serverWorld) {
        EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntity((class_1657)player);
        ModConfiguration.StartingItemOptions startingItem = Prefab.serverConfiguration.startingItem;
        if (!playerConfig.givenHouseBuilder && startingItem != null) {
            class_1799 stack = class_1799.field_8037;
            switch (startingItem) {
                case StartingHouse: {
                    stack = new class_1799((class_1935)ModRegistry.StartHouse);
                    break;
                }
                case ModerateHouse: {
                    stack = new class_1799((class_1935)ModRegistry.ModerateHouse);
                }
            }
            if (!stack.method_7960()) {
                System.out.println(player.method_5476().getString() + " joined the game for the first time. Giving them starting item.");
                player.method_31548().method_7394(stack);
                player.field_7512.method_7623();
                playerConfig.givenHouseBuilder = true;
            }
        }
        PlayerEntityTagMessage message = new PlayerEntityTagMessage();
        class_2540 messagePacket = Utils.createMessageBuffer(playerConfig.createPlayerTag());
        ServerSidePacketRegistry.INSTANCE.sendToPlayer((class_1657)player, ModRegistry.PlayerConfigSync, messagePacket);
    }

    public static void onServerTick() {
        ArrayList<class_1657> playersToRemove = new ArrayList<class_1657>();
        if (++ticksSinceLastEntitiesGenerated > 40) {
            StructureEventHandler.processStructureEntities();
            ticksSinceLastEntitiesGenerated = 0;
        }
        for (Map.Entry<class_1657, ArrayList<Structure>> entry : structuresToBuild.entrySet()) {
            ArrayList<Structure> structuresToRemove = new ArrayList<Structure>();
            for (Structure structure : entry.getValue()) {
                if (!structure.entitiesRemoved) {
                    for (class_2338 clearedPos : structure.clearedBlockPos) {
                        class_238 axisPos = class_259.method_1077().method_1107().method_996(clearedPos);
                        List list = structure.world.method_8335(null, axisPos);
                        if (list.isEmpty()) continue;
                        for (class_1297 entity : list) {
                            if (entity instanceof class_1309) continue;
                            if (entity instanceof class_1530) {
                                structure.BeforeHangingEntityRemoved((class_1530)entity);
                            }
                            entity.method_5650(class_1297.class_5529.field_26999);
                        }
                    }
                    structure.entitiesRemoved = true;
                }
                if (structure.airBlocks.size() > 0) {
                    structure.hasAirBlocks = true;
                }
                for (int i = 0; i < 100; ++i) {
                    i = StructureEventHandler.setBlock(i, structure, structuresToRemove);
                }
                StructureEventHandler.removeWaterLogging(structure);
            }
            StructureEventHandler.removeStructuresFromList(structuresToRemove, entry);
            if (entry.getValue().size() != 0) continue;
            playersToRemove.add(entry.getKey());
        }
        for (class_1657 player : playersToRemove) {
            structuresToBuild.remove(player);
        }
    }

    private static int setBlock(int i, Structure structure, ArrayList<Structure> structuresToRemove) {
        if (structure.clearedBlockPos.size() > 0 && !structure.hasAirBlocks) {
            class_2338 currentPos = structure.clearedBlockPos.get(0);
            structure.clearedBlockPos.remove(0);
            class_2680 clearBlockState = structure.world.method_8320(currentPos);
            if (clearBlockState.method_26207() != class_3614.field_15959) {
                structure.BeforeClearSpaceBlockReplaced(currentPos);
                block0: for (class_2350 adjacentBlock : class_2350.values()) {
                    class_2338 tempPos = currentPos.method_10093(adjacentBlock);
                    class_2680 foundState = structure.world.method_8320(tempPos);
                    class_2248 foundBlock = foundState.method_26204();
                    if (!(foundBlock instanceof class_2527) && !(foundBlock instanceof class_2478) && !(foundBlock instanceof class_2401) && !(foundBlock instanceof class_2269) && !(foundBlock instanceof class_2244) && !(foundBlock instanceof class_2577) && !(foundBlock instanceof class_2362) && !(foundBlock instanceof class_2523) && !(foundBlock instanceof class_2231) && !(foundBlock instanceof class_2323) && !(foundBlock instanceof class_2399) && !(foundBlock instanceof class_2541) && !(foundBlock instanceof class_2457) && !(foundBlock instanceof class_2312) && !(foundBlock instanceof class_2185) && !(foundBlock instanceof class_3749) && !(foundBlock instanceof class_2241)) continue;
                    structure.BeforeClearSpaceBlockReplaced(currentPos);
                    if (!(foundBlock instanceof class_2244)) {
                        structure.world.method_8650(tempPos, false);
                        continue;
                    }
                    if (foundBlock instanceof class_2323) {
                        class_2756 currentHalf = (class_2756)foundState.method_11654((class_2769)class_2741.field_12533);
                        class_2338 otherHalfPos = currentHalf == class_2756.field_12607 ? tempPos.method_10084() : tempPos.method_10074();
                        structure.world.method_8652(tempPos, class_2246.field_10124.method_9564(), 35);
                        structure.world.method_8652(otherHalfPos, class_2246.field_10124.method_9564(), 35);
                        continue;
                    }
                    for (class_2350 currentDirection : class_2350.values()) {
                        class_2338 bedPos = tempPos.method_10093(currentDirection);
                        class_2680 bedState = structure.world.method_8320(bedPos);
                        if (!(bedState.method_26204() instanceof class_2244)) continue;
                        structure.world.method_8652(tempPos, class_2246.field_10124.method_9564(), 35);
                        structure.world.method_8652(bedPos, class_2246.field_10124.method_9564(), 35);
                        continue block0;
                    }
                }
                structure.world.method_8650(currentPos, false);
            } else {
                --i;
            }
            return i;
        }
        BuildBlock currentBlock = null;
        if (structure.priorityOneBlocks.size() > 0) {
            currentBlock = structure.priorityOneBlocks.get(0);
            structure.priorityOneBlocks.remove(0);
        } else if (structure.priorityTwoBlocks.size() > 0) {
            currentBlock = structure.priorityTwoBlocks.get(0);
            structure.priorityTwoBlocks.remove(0);
        } else if (structure.airBlocks.size() > 0) {
            currentBlock = structure.airBlocks.get(0);
            structure.airBlocks.remove(0);
        } else if (structure.priorityThreeBlocks.size() > 0) {
            currentBlock = structure.priorityThreeBlocks.get(0);
            structure.priorityThreeBlocks.remove(0);
        } else if (structure.priorityFourBlocks.size() > 0) {
            currentBlock = structure.priorityFourBlocks.get(0);
            structure.priorityFourBlocks.remove(0);
        } else if (structure.priorityFiveBlocks.size() > 0) {
            currentBlock = structure.priorityFiveBlocks.get(0);
            structure.priorityFiveBlocks.remove(0);
        } else {
            structuresToRemove.add(structure);
            return 999;
        }
        class_2680 state = currentBlock.getBlockState();
        class_2338 setBlockPos = currentBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
        BuildingMethods.ReplaceBlock((class_1937)structure.world, setBlockPos, state);
        if (currentBlock.getSubBlock() != null) {
            BuildBlock subBlock = currentBlock.getSubBlock();
            BuildingMethods.ReplaceBlock((class_1937)structure.world, subBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing), subBlock.getBlockState());
        }
        return i;
    }

    private static void removeStructuresFromList(ArrayList<Structure> structuresToRemove, Map.Entry<class_1657, ArrayList<Structure>> entry) {
        for (Structure structure : structuresToRemove) {
            for (BuildTileEntity buildTileEntity : structure.tileEntities) {
                class_2338 tileEntityPos = buildTileEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
                class_2586 tileEntity = structure.world.method_8321(tileEntityPos);
                class_2680 tileBlock = structure.world.method_8320(tileEntityPos);
                if (tileEntity == null) continue;
                structure.world.method_8544(tileEntityPos);
                tileEntity = class_2586.method_11005((class_2338)tileEntityPos, (class_2680)tileBlock, (class_2487)buildTileEntity.getEntityDataTag());
                structure.world.method_8438(tileEntity);
                structure.world.method_22350(tileEntityPos).method_12008(true);
                tileEntity.method_5431();
                class_2622 packet = tileEntity.method_16886();
                if (packet == null) continue;
                structure.world.method_8503().method_3760().method_14581((class_2596)packet);
            }
            StructureEventHandler.removeWaterLogging(structure);
            for (BuildEntity buildEntity : structure.entities) {
                Optional entityType = class_1299.method_5898((String)buildEntity.getEntityResourceString());
                if (!entityType.isPresent()) continue;
                entitiesToGenerate.add(new Tuple<Structure, BuildEntity>(structure, buildEntity));
            }
            structure.AfterBuilding(structure.configuration, structure.world, structure.originalPos, structure.assumedNorth, entry.getKey());
            entry.getValue().remove(structure);
        }
    }

    private static void processStructureEntities() {
        for (Tuple<Structure, BuildEntity> entityRecords : entitiesToGenerate) {
            class_1297 entity;
            BuildEntity buildEntity = (BuildEntity)entityRecords.second;
            Structure structure = (Structure)entityRecords.first;
            Optional entityType = class_1299.method_5898((String)buildEntity.getEntityResourceString());
            if (!entityType.isPresent() || (entity = ((class_1299)entityType.get()).method_5883((class_1937)structure.world)) == null) continue;
            class_2487 tagCompound = buildEntity.getEntityDataTag();
            class_2338 entityPos = buildEntity.getStartingPosition().getRelativePosition(structure.originalPos, structure.getClearSpace().getShape().getDirection(), structure.configuration.houseFacing);
            if (tagCompound != null) {
                if (tagCompound.method_25928("UUID")) {
                    tagCompound.method_25927("UUID", UUID.randomUUID());
                }
                class_2499 nbttaglist = new class_2499();
                nbttaglist.add((Object)class_2489.method_23241((double)entityPos.method_10263()));
                nbttaglist.add((Object)class_2489.method_23241((double)entityPos.method_10264()));
                nbttaglist.add((Object)class_2489.method_23241((double)entityPos.method_10260()));
                tagCompound.method_10566("Pos", (class_2520)nbttaglist);
                entity.method_5651(tagCompound);
            }
            if (entity instanceof class_1533) {
                entity = StructureEventHandler.setItemFrameFacingAndRotation((class_1533)entity, buildEntity, entityPos, structure);
            } else if (entity instanceof class_1534) {
                entity = StructureEventHandler.setPaintingFacingAndRotation((class_1534)entity, buildEntity, entityPos, structure);
            } else if (entity instanceof class_1688) {
                buildEntity.entityYAxisOffset += 0.2;
                entity = StructureEventHandler.setEntityFacingAndRotation(entity, buildEntity, entityPos, structure);
            } else {
                entity = StructureEventHandler.setEntityFacingAndRotation(entity, buildEntity, entityPos, structure);
            }
            structure.world.method_8649(entity);
        }
        entitiesToGenerate.clear();
    }

    private static void removeWaterLogging(Structure structure) {
        if (structure.hasAirBlocks) {
            for (class_2338 currentPos : structure.allBlockPositions) {
                class_2680 currentState = structure.world.method_8320(currentPos);
                if (currentState.method_28498((class_2769)class_2741.field_12508)) {
                    currentState = (class_2680)currentState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
                    structure.world.method_8501(currentPos, currentState);
                    continue;
                }
                if (currentState.method_26207() != class_3614.field_15920) continue;
                structure.world.method_8501(currentPos, class_2246.field_10124.method_9564());
            }
        }
    }

    private static class_1297 setPaintingFacingAndRotation(class_1534 entity, BuildEntity buildEntity, class_2338 entityPos, Structure structure) {
        float yaw = entity.method_36454();
        class_2470 rotation = class_2470.field_11467;
        double x_axis_offset = 0.0;
        double z_axis_offset = 0.0;
        class_2350 facing = entity.method_5735();
        double y_axis_offset = buildEntity.entityYAxisOffset * -1.0;
        if (structure.configuration.houseFacing == structure.assumedNorth.method_10153()) {
            rotation = class_2470.field_11464;
            facing = facing.method_10153();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.method_10170()) {
            rotation = class_2470.field_11463;
            if (structure.getClearSpace().getShape().getDirection() == class_2350.field_11043) {
                facing = facing.method_10160();
            } else if (structure.getClearSpace().getShape().getDirection() == class_2350.field_11035) {
                facing = facing.method_10170();
            }
        } else if (structure.configuration.houseFacing == structure.assumedNorth.method_10160()) {
            rotation = class_2470.field_11465;
            if (structure.getClearSpace().getShape().getDirection() == class_2350.field_11043) {
                facing = facing.method_10170();
            } else if (structure.getClearSpace().getShape().getDirection() == class_2350.field_11035) {
                facing = facing.method_10160();
            }
        }
        if (entity.field_7134.method_6943() > entity.field_7134.method_6945() || entity.field_7134.method_6943() > 16) {
            y_axis_offset -= 1.0;
        }
        yaw = entity.method_5832(rotation);
        class_1534 hangingEntity = entity;
        class_2487 compound = new class_2487();
        hangingEntity.method_5652(compound);
        compound.method_10567("Facing", (byte)facing.method_10161());
        hangingEntity.method_5652(compound);
        StructureEventHandler.updateEntityHangingBoundingBox((class_1530)hangingEntity);
        entity.method_5808((double)entityPos.method_10263() + x_axis_offset, (double)entityPos.method_10264() + y_axis_offset, (double)entityPos.method_10260() + z_axis_offset, yaw, entity.method_36455());
        StructureEventHandler.updateEntityHangingBoundingBox((class_1530)entity);
        class_2791 chunk = structure.world.method_22350(entityPos);
        chunk.method_12008(true);
        return entity;
    }

    private static class_1297 setItemFrameFacingAndRotation(class_1533 frame, BuildEntity buildEntity, class_2338 entityPos, Structure structure) {
        float yaw = frame.method_36454();
        class_2470 rotation = class_2470.field_11467;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        class_2350 facing = frame.method_5735();
        double y_axis_offset = buildEntity.entityYAxisOffset;
        x_axis_offset *= -1.0;
        z_axis_offset *= -1.0;
        if (facing != class_2350.field_11036 && facing != class_2350.field_11033) {
            if (structure.configuration.houseFacing == structure.assumedNorth.method_10153()) {
                rotation = class_2470.field_11464;
                facing = facing.method_10153();
            } else if (structure.configuration.houseFacing == structure.assumedNorth.method_10170()) {
                if (structure.getClearSpace().getShape().getDirection() == class_2350.field_11043) {
                    rotation = class_2470.field_11463;
                    facing = facing.method_10160();
                } else if (structure.getClearSpace().getShape().getDirection() == class_2350.field_11035) {
                    facing = facing.method_10160();
                    rotation = class_2470.field_11463;
                }
            } else if (structure.configuration.houseFacing == structure.assumedNorth.method_10160()) {
                if (structure.getClearSpace().getShape().getDirection() == class_2350.field_11043) {
                    rotation = class_2470.field_11465;
                    facing = facing.method_10170();
                } else if (structure.getClearSpace().getShape().getDirection() == class_2350.field_11035) {
                    facing = facing.method_10170();
                    rotation = class_2470.field_11465;
                }
            } else {
                x_axis_offset = 0.0;
                z_axis_offset = 0.0;
            }
        }
        yaw = frame.method_5832(rotation);
        class_1533 hangingEntity = frame;
        class_2487 compound = new class_2487();
        hangingEntity.method_5652(compound);
        compound.method_10567("Facing", (byte)facing.method_10146());
        hangingEntity.method_5652(compound);
        StructureEventHandler.updateEntityHangingBoundingBox((class_1530)hangingEntity);
        frame.method_5808((double)entityPos.method_10263() + x_axis_offset, (double)entityPos.method_10264() + y_axis_offset, (double)entityPos.method_10260() + z_axis_offset, yaw, frame.method_36455());
        StructureEventHandler.updateEntityHangingBoundingBox((class_1530)frame);
        class_2791 chunk = structure.world.method_22350(entityPos);
        chunk.method_12008(true);
        return frame;
    }

    private static class_1297 setEntityFacingAndRotation(class_1297 entity, BuildEntity buildEntity, class_2338 entityPos, Structure structure) {
        float yaw = entity.method_36454();
        class_2470 rotation = class_2470.field_11467;
        double x_axis_offset = buildEntity.entityXAxisOffset;
        double z_axis_offset = buildEntity.entityZAxisOffset;
        class_2350 facing = structure.assumedNorth;
        double y_axis_offset = buildEntity.entityYAxisOffset;
        if (structure.configuration.houseFacing == structure.assumedNorth.method_10153()) {
            rotation = class_2470.field_11464;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.method_10153();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.method_10170()) {
            rotation = class_2470.field_11463;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.method_10170();
        } else if (structure.configuration.houseFacing == structure.assumedNorth.method_10160()) {
            rotation = class_2470.field_11465;
            x_axis_offset *= -1.0;
            z_axis_offset *= -1.0;
            facing = facing.method_10160();
        } else {
            x_axis_offset = 0.0;
            z_axis_offset = 0.0;
        }
        yaw = entity.method_5832(rotation);
        entity.method_5808((double)entityPos.method_10263() + x_axis_offset, (double)entityPos.method_10264() + y_axis_offset, (double)entityPos.method_10260() + z_axis_offset, yaw, entity.method_36455());
        return entity;
    }

    private static void updateEntityHangingBoundingBox(class_1530 entity) {
        double d0 = (double)entity.method_6896().method_10263() + 0.5;
        double d1 = (double)entity.method_6896().method_10264() + 0.5;
        double d2 = (double)entity.method_6896().method_10260() + 0.5;
        double d3 = 0.46875;
        double d4 = entity.method_6897() % 32 == 0 ? 0.5 : 0.0;
        double d5 = entity.method_6891() % 32 == 0 ? 0.5 : 0.0;
        class_2350 horizontal = entity.method_5735();
        d0 -= (double)horizontal.method_10148() * 0.46875;
        d2 -= (double)horizontal.method_10165() * 0.46875;
        class_2350 direction = horizontal == class_2350.field_11033 || horizontal == class_2350.field_11036 ? horizontal.method_10153() : horizontal.method_10160();
        entity.method_23327(d0 += d4 * (double)direction.method_10148(), d1 += d5, d2 += d4 * (double)direction.method_10165());
        double d6 = entity.method_6897();
        double d7 = entity.method_6891();
        double d8 = entity.method_6897();
        if (horizontal.method_10166() == class_2350.class_2351.field_11051) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        entity.method_5857(new class_238(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8));
    }
}

