/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.gui;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.gui.GuiBase;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.messages.StructureTagMessage;
import com.wuest.prefab.structures.render.StructureRenderHandler;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_4587;

public abstract class GuiStructure
extends GuiBase {
    public class_2338 pos;
    protected class_1657 player;
    protected class_4185 btnCancel;
    protected class_4185 btnBuild;
    protected class_4185 btnVisualize;
    public StructureTagMessage.EnumStructureConfiguration structureConfiguration;
    protected class_2960 structureImageLocation;
    private class_2350 structureFacing;

    public GuiStructure(String title) {
        super(title);
    }

    @Override
    public void method_25426() {
        this.player = this.field_22787.field_1724;
        this.structureFacing = this.player.method_5735().method_10153();
        this.Initialize();
    }

    @Override
    protected void Initialize() {
        super.Initialize();
    }

    protected void InitializeStandardButtons() {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        int grayBoxX = adjustedXYValue.getFirst();
        int grayBoxY = adjustedXYValue.getSecond();
        this.btnVisualize = this.createAndAddCustomButton(grayBoxX + 113, grayBoxY + 165, 90, 20, "prefab.gui.button.preview");
        this.btnBuild = this.createAndAddCustomButton(grayBoxX + 215, grayBoxY + 165, 90, 20, "prefab.gui.button.build");
        this.btnCancel = this.createAndAddButton(grayBoxX + 10, grayBoxY + 165, 90, 20, "prefab.gui.button.cancel");
    }

    public void checkVisualizationSetting() {
        if (!Prefab.serverConfiguration.enableStructurePreview) {
            this.btnVisualize.field_22764 = false;
        }
    }

    @Override
    public void method_25394(class_4587 matrixStack, int x, int y, float f) {
        Tuple<Integer, Integer> adjustedXYValue = this.getAdjustedXYValue();
        this.preButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        this.renderButtons(matrixStack, x, y);
        this.postButtonRender(matrixStack, adjustedXYValue.getFirst(), adjustedXYValue.getSecond(), x, y, f);
        if (this.btnVisualize != null) {
            this.checkVisualizationSetting();
        }
    }

    @Override
    protected void preButtonRender(class_4587 matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.drawStandardControlBoxAndImage(matrixStack, this.structureImageLocation, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void postButtonRender(class_4587 matrixStack, int x, int y, int mouseX, int mouseY, float partialTicks) {
    }

    protected void performCancelOrBuildOrHouseFacing(StructureConfiguration configuration, class_4264 button) {
        configuration.houseFacing = this.structureFacing;
        if (button == this.btnCancel) {
            this.closeScreen();
        } else if (button == this.btnBuild) {
            class_2540 messagePacket = Utils.createStructureMessageBuffer(configuration.WriteToCompoundNBT(), this.structureConfiguration);
            ClientPlayNetworking.send((class_2960)ModRegistry.StructureBuild, (class_2540)messagePacket);
            this.closeScreen();
        }
    }

    protected void performPreview(Structure structure, StructureConfiguration structureConfiguration) {
        StructureRenderHandler.setStructure(structure, class_2350.field_11043, structureConfiguration);
        this.closeScreen();
    }
}

