/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.items;

import com.wuest.prefab.ClientModRegistry;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Utils;
import com.wuest.prefab.gui.GuiLangKeys;
import com.wuest.prefab.structures.gui.GuiBulldozer;
import com.wuest.prefab.structures.items.StructureItem;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class ItemBulldozer
extends StructureItem {
    private boolean creativePowered = false;

    public ItemBulldozer() {
        super(new class_1792.class_1793().method_7892(ModRegistry.PREFAB_GROUP).method_7895(4));
    }

    public ItemBulldozer(boolean creativePowered) {
        super(new class_1792.class_1793().method_7892(ModRegistry.PREFAB_GROUP));
        this.creativePowered = creativePowered;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        if (context.method_8045().field_9236 && context.method_8038() == class_2350.field_11036 && this.getPoweredValue(context.method_8036(), context.method_20287())) {
            ClientModRegistry.openGuiForItem(context);
            return class_1269.field_5811;
        }
        return class_1269.field_5814;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        boolean advancedKeyDown = class_437.method_25442();
        if (!advancedKeyDown) {
            tooltip.add((class_2561)GuiLangKeys.translateToComponent("prefab.gui.tooltip.shift"));
        } else if (this.getPoweredValue(stack)) {
            tooltip.addAll(Utils.WrapStringToLiterals(GuiLangKeys.translateString("prefab.gui.tooltip.bulldozer_powered")));
        } else {
            tooltip.addAll(Utils.WrapStringToLiterals(GuiLangKeys.translateString("prefab.gui.tooltip.bulldozer_unpowered")));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_7886(class_1799 stack) {
        return this.getPoweredValue(stack) || super.method_7886(stack);
    }

    @Override
    protected void Initialize() {
        ModRegistry.guiRegistrations.add(x -> this.RegisterGui(GuiBulldozer.class));
    }

    private boolean getPoweredValue(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        return this.getPoweredValue(stack);
    }

    private boolean getPoweredValue(class_1799 stack) {
        if (this.creativePowered) {
            return true;
        }
        if (stack.method_7909() == ModRegistry.Bulldozer) {
            if (stack.method_7969() == null || stack.method_7969().method_33133()) {
                stack.method_7980(stack.method_7953(new class_2487()));
            } else {
                class_2487 prefabTag;
                class_2487 tag = stack.method_7969();
                if (tag.method_10545("prefab") && (prefabTag = tag.method_10562("prefab")).method_10545("powered")) {
                    return prefabTag.method_10577("powered");
                }
            }
        }
        return false;
    }

    public void setPoweredValue(class_1799 stack, boolean value) {
        if (stack.method_7969() == null || stack.method_7969().method_33133()) {
            stack.method_7980(stack.method_7953(new class_2487()));
        }
        class_2487 prefabTag = new class_2487();
        prefabTag.method_10556("powered", value);
        stack.method_7969().method_10566("prefab", (class_2520)prefabTag);
    }
}

