/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.Utils;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildShape;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2304;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2476;
import net.minecraft.class_2508;
import net.minecraft.class_2525;
import net.minecraft.class_2527;
import net.minecraft.class_2533;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3708;
import net.minecraft.class_3865;

public class StructureAlternateStart
extends Structure {
    private class_2338 chestPosition = null;
    private class_2338 furnacePosition = null;
    private class_2338 trapDoorPosition = null;
    private class_2338 signPosition = null;
    private ArrayList<Tuple<class_2338, class_2338>> bedPositions = new ArrayList();

    public static void ScanBasicHouseStructure(class_1937 world, class_2338 originalPos, class_2350 playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(class_2350.field_11035);
        clearedSpace.getShape().setHeight(10);
        clearedSpace.getShape().setLength(12);
        clearedSpace.getShape().setWidth(13);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(5);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        class_2338 corner = originalPos.method_10089(5).method_10072().method_10074();
        class_2338 corner2 = originalPos.method_10088(8).method_10077(13).method_10086(10);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\basic_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanRanchStructure(class_1937 world, class_2338 originalPos, class_2350 playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(class_2350.field_11035);
        clearedSpace.getShape().setHeight(7);
        clearedSpace.getShape().setLength(21);
        clearedSpace.getShape().setWidth(11);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        Structure.ScanStructure(world, originalPos, originalPos.method_10089(8).method_10072().method_10074(), originalPos.method_10077(22).method_10088(3).method_10086(8), "..\\src\\main\\resources\\assets\\prefab\\structures\\ranch_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanLoftStructure(class_1937 world, class_2338 originalPos, class_2350 playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(class_2350.field_11035);
        clearedSpace.getShape().setHeight(9);
        clearedSpace.getShape().setLength(13);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(7);
        Structure.ScanStructure(world, originalPos, originalPos.method_10089(7).method_10072(), originalPos.method_10077(14).method_10088(8).method_10086(9), "..\\src\\main\\resources\\assets\\prefab\\structures\\loft_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanHobbitStructure(class_1937 world, class_2338 originalPos, class_2350 playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(class_2350.field_11035);
        clearedSpace.getShape().setHeight(12);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-3);
        Structure.ScanStructure(world, originalPos, originalPos.method_10089(8).method_10072().method_10087(3), originalPos.method_10077(16).method_10088(8).method_10086(12), "..\\src\\main\\resources\\assets\\prefab\\structures\\hobbit_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanDesert2Structure(class_1937 world, class_2338 originalPos, class_2350 playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(class_2350.field_11035);
        clearedSpace.getShape().setHeight(10);
        clearedSpace.getShape().setLength(14);
        clearedSpace.getShape().setWidth(11);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        class_2338 corner = originalPos.method_10089(8).method_10072().method_10074();
        class_2338 corner2 = originalPos.method_10088(6).method_10077(16).method_10086(10);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\desert_house2.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanSubAquaticStructure(class_1937 world, class_2338 originalPos, class_2350 playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(class_2350.field_11035);
        clearedSpace.getShape().setHeight(13);
        clearedSpace.getShape().setLength(9);
        clearedSpace.getShape().setWidth(12);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        class_2338 corner = originalPos.method_10089(8).method_10072().method_10074();
        class_2338 corner2 = originalPos.method_10088(4).method_10077(10).method_10086(12);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\subaquatic_house.zip", clearedSpace, playerFacing, true, true);
    }

    public static void ScanStructure(class_1937 world, class_2338 originalPos, class_2350 playerFacing, String structureFileName, boolean includeAir, boolean excludeWater) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(class_2350.field_11035);
        clearedSpace.getShape().setHeight(8);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BuildShape buildShape = clearedSpace.getShape();
        PositionOffset offset = clearedSpace.getStartingPosition();
        int downOffset = offset.getHeightOffset() < 0 ? Math.abs(offset.getHeightOffset()) : 0;
        class_2338 cornerPos = originalPos.method_10089(offset.getEastOffset()).method_10077(offset.getSouthOffset()).method_10087(downOffset);
        Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.method_10077(buildShape.getLength()).method_10088(buildShape.getWidth()).method_10086(buildShape.getHeight()), "..\\src\\main\\resources\\assets\\prefab\\structures\\" + structureFileName + ".zip", clearedSpace, playerFacing, includeAir, excludeWater);
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, class_1937 world, class_2338 originalPos, class_2350 assumedNorth, class_2248 foundBlock, class_2680 blockState, class_1657 player) {
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        if (!houseConfig.addBed && foundBlock instanceof class_2244 || !houseConfig.addChest && foundBlock instanceof class_2281 || !houseConfig.addTorches && foundBlock instanceof class_2527 || !houseConfig.addCraftingTable && foundBlock instanceof class_2304 || !houseConfig.addFurnace && foundBlock instanceof class_3865 || !houseConfig.addChest && foundBlock instanceof class_3708 || foundBlock instanceof class_2476 || foundBlock instanceof class_2525) {
            return true;
        }
        if (foundBlock instanceof class_3865) {
            this.furnacePosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof class_2533 && houseConfig.addMineShaft && this.trapDoorPosition == null) {
            this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof class_2281 && this.chestPosition == null || foundBlock instanceof class_3708 && this.chestPosition == null) {
            this.chestPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof class_2508) {
            this.signPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock == class_2246.field_10258 && houseConfig.addMineShaft) {
            this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing).method_10084();
        } else if (foundBlock instanceof class_2244 && houseConfig.addBed) {
            class_2338 bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            class_2338 bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            this.bedPositions.add(new Tuple<class_2338, class_2338>(bedHeadPosition, bedFootPosition));
            return true;
        }
        class_2960 foundBlockIdentifier = class_2378.field_11146.method_10221((Object)foundBlock);
        if (foundBlockIdentifier.method_12836().equals(class_2378.field_11146.method_10221((Object)class_2246.field_10087).method_12836()) && foundBlockIdentifier.method_12832().endsWith("glass")) {
            blockState = this.getStainedGlassBlock(houseConfig.glassColor);
            block.setBlockState(blockState);
            this.priorityOneBlocks.add(block);
            return true;
        }
        if (foundBlockIdentifier.method_12836().equals(class_2378.field_11146.method_10221((Object)class_2246.field_9991).method_12836()) && foundBlockIdentifier.method_12832().endsWith("glass_pane")) {
            blockState = this.getStainedGlassPaneBlock(houseConfig.glassColor);
            BuildBlock.SetBlockState(configuration, world, originalPos, assumedNorth, block, foundBlock, blockState, this);
            this.priorityOneBlocks.add(block);
            return true;
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, class_3218 world, class_2338 originalPos, class_2350 assumedNorth, class_1657 player) {
        class_2586 tileEntity;
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntity(player);
        ArrayList<class_2338> furnacePositions = new ArrayList<class_2338>();
        if (this.furnacePosition != null) {
            furnacePositions.add(this.furnacePosition);
        }
        BuildingMethods.FillFurnaces((class_1937)world, furnacePositions);
        if (this.chestPosition != null && houseConfig.addChestContents) {
            BuildingMethods.FillChest((class_1937)world, this.chestPosition);
        }
        if (this.trapDoorPosition != null && this.trapDoorPosition.method_10264() > 15 && houseConfig.addMineShaft) {
            BuildingMethods.PlaceMineShaft(world, this.trapDoorPosition.method_10074(), houseConfig.houseFacing, false);
        }
        if (this.signPosition != null && (tileEntity = world.method_8321(this.signPosition)) instanceof class_2625) {
            class_2625 signTile = (class_2625)tileEntity;
            signTile.method_11299(0, (class_2561)Utils.createTextComponent("This is"));
            if (player.method_5476().getString().length() >= 15) {
                signTile.method_11299(1, (class_2561)Utils.createTextComponent(player.method_5476().getString()));
            } else {
                signTile.method_11299(1, (class_2561)Utils.createTextComponent(player.method_5476().getString() + "'s"));
            }
            signTile.method_11299(2, (class_2561)Utils.createTextComponent("house!"));
        }
        if (this.bedPositions.size() > 0 && houseConfig.addBed) {
            for (Tuple<class_2338, class_2338> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed((class_1937)world, bedPosition.getFirst(), bedPosition.getSecond(), houseConfig.bedColor);
            }
        }
        playerConfig.builtStarterHouse = true;
        ServerSidePacketRegistry.INSTANCE.sendToPlayer(player, ModRegistry.PlayerConfigSync, Utils.createMessageBuffer(playerConfig.createPlayerTag()));
    }
}

