/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.InstantBridgeConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.class_1657;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

public class StructureInstantBridge
extends Structure {
    public static StructureInstantBridge CreateInstance() {
        return new StructureInstantBridge();
    }

    @Override
    public boolean BuildStructure(StructureConfiguration configuration, class_3218 world, class_2338 originalPos, class_2350 assumedNorth, class_1657 player) {
        InstantBridgeConfiguration specificConfig = (InstantBridgeConfiguration)configuration;
        this.setupClearSpace(specificConfig);
        this.setupStructure(specificConfig, originalPos);
        return super.BuildStructure(specificConfig, world, originalPos, assumedNorth, player);
    }

    public void setupStructure(InstantBridgeConfiguration configuration, class_2338 originalPos) {
        ArrayList<BuildBlock> buildingBlocks = new ArrayList<BuildBlock>();
        class_2680 materialState = configuration.bridgeMaterial.getBlockType();
        class_2350 facing = class_2350.field_11035;
        class_2680 torchState = class_2246.field_10336.method_9564();
        class_2680 glassState = class_2246.field_10285.method_9564();
        int interiorHeightOffSet = configuration.interiorHeight - 3;
        for (int i = 1; i <= configuration.bridgeLength; ++i) {
            class_2338 currentPos = originalPos.method_10079(facing, i);
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10079(facing.method_10160(), 2), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10093(facing.method_10160()), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos, originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10093(facing.method_10170()), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10079(facing.method_10170(), 2), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10079(facing.method_10160(), 2).method_10084(), originalPos));
            buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10079(facing.method_10170(), 2).method_10084(), originalPos));
            if (configuration.includeRoof) {
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10079(facing.method_10160(), 2).method_10086(3 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10093(facing.method_10160()).method_10086(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10086(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10093(facing.method_10170()).method_10086(4 + interiorHeightOffSet), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(materialState, materialState.method_26204(), currentPos.method_10079(facing.method_10170(), 2).method_10086(3 + interiorHeightOffSet), originalPos));
            }
            for (int j = 0; j <= interiorHeightOffSet; ++j) {
                if ((i == 1 || i % 6 == 0) && j == 0) {
                    buildingBlocks.add(Structure.createBuildBlockFromBlockState(torchState, torchState.method_26204(), currentPos.method_10079(facing.method_10160(), 2).method_10086(2), originalPos));
                    buildingBlocks.add(Structure.createBuildBlockFromBlockState(torchState, torchState.method_26204(), currentPos.method_10079(facing.method_10170(), 2).method_10086(2), originalPos));
                    continue;
                }
                if (!configuration.includeRoof) continue;
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(glassState, glassState.method_26204(), currentPos.method_10079(facing.method_10160(), 2).method_10086(2 + j), originalPos));
                buildingBlocks.add(Structure.createBuildBlockFromBlockState(glassState, glassState.method_26204(), currentPos.method_10079(facing.method_10170(), 2).method_10086(2 + j), originalPos));
            }
        }
        this.setBlocks(buildingBlocks);
    }

    private void setupClearSpace(InstantBridgeConfiguration configuration) {
        int clearHeight = 3;
        if (configuration.includeRoof) {
            clearHeight = configuration.interiorHeight - clearHeight + clearHeight + 2;
        }
        BuildClear clear = new BuildClear();
        clear.getStartingPosition().setSouthOffset(1);
        clear.getStartingPosition().setEastOffset(2);
        clear.getShape().setDirection(class_2350.field_11035);
        clear.getShape().setHeight(clearHeight - 1);
        clear.getShape().setWidth(5);
        clear.getShape().setLength(configuration.bridgeLength);
        this.setClearSpace(clear);
    }
}

