/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Tuple;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.network.message.PlayerEntityTagMessage;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.ModerateHouseConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2533;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3865;

public class StructureModerateHouse
extends Structure {
    private class_2338 chestPosition = null;
    private ArrayList<class_2338> furnacePosition = null;
    private class_2338 trapDoorPosition = null;
    private ArrayList<Tuple<class_2338, class_2338>> bedPositions = new ArrayList();

    public static void ScanStructure(class_1937 world, class_2338 originalPos, class_2350 playerFacing, ModerateHouseConfiguration.HouseStyle houseStyle) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(playerFacing);
        clearedSpace.getShape().setHeight(houseStyle.getHeight());
        clearedSpace.getShape().setLength(houseStyle.getLength() + 1);
        clearedSpace.getShape().setWidth(houseStyle.getWidth());
        clearedSpace.getStartingPosition().setHorizontalOffset(playerFacing, 1);
        clearedSpace.getStartingPosition().setHorizontalOffset(playerFacing.method_10160(), houseStyle.getEastOffSet());
        clearedSpace.getStartingPosition().setHeightOffset(houseStyle.getDownOffSet() * -1);
        class_2338 cornerPos = originalPos.method_10079(playerFacing.method_10160(), houseStyle.getEastOffSet()).method_10093(playerFacing).method_10087(houseStyle.getDownOffSet());
        Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.method_10079(playerFacing, houseStyle.getLength()).method_10079(playerFacing.method_10170(), houseStyle.getWidth()).method_10086(houseStyle.getHeight()), "../src/main/resources/" + houseStyle.getStructureLocation(), clearedSpace, playerFacing, false, false);
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, class_1937 world, class_2338 originalPos, class_2350 assumedNorth, class_2248 foundBlock, class_2680 blockState, class_1657 player) {
        ModerateHouseConfiguration houseConfiguration = (ModerateHouseConfiguration)configuration;
        if (foundBlock instanceof class_3865) {
            if (this.furnacePosition == null) {
                this.furnacePosition = new ArrayList();
            }
            this.furnacePosition.add(block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing));
        } else {
            if (foundBlock instanceof class_2281 && !houseConfiguration.addChests) {
                return true;
            }
            if (foundBlock instanceof class_2281 && this.chestPosition == null) {
                this.chestPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            } else if (foundBlock instanceof class_2533 && this.trapDoorPosition == null) {
                this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            } else if (foundBlock == class_2246.field_10258) {
                this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing).method_10084();
            } else if (foundBlock instanceof class_2244) {
                class_2338 bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                class_2338 bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
                this.bedPositions.add(new Tuple<class_2338, class_2338>(bedHeadPosition, bedFootPosition));
                return true;
            }
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, class_3218 world, class_2338 originalPos, class_2350 assumedNorth, class_1657 player) {
        ModerateHouseConfiguration houseConfig = (ModerateHouseConfiguration)configuration;
        EntityPlayerConfiguration playerConfig = EntityPlayerConfiguration.loadFromEntity(player);
        BuildingMethods.FillFurnaces((class_1937)world, this.furnacePosition);
        if (this.chestPosition != null && !playerConfig.builtStarterHouse && houseConfig.addChestContents) {
            BuildingMethods.FillChest((class_1937)world, this.chestPosition);
        }
        if (this.trapDoorPosition != null && this.trapDoorPosition.method_10264() > 15 && houseConfig.addMineshaft) {
            BuildingMethods.PlaceMineShaft(world, this.trapDoorPosition.method_10074(), houseConfig.houseFacing, false);
        }
        if (this.bedPositions.size() > 0) {
            for (Tuple<class_2338, class_2338> bedPosition : this.bedPositions) {
                BuildingMethods.PlaceColoredBed((class_1937)world, bedPosition.getFirst(), bedPosition.getSecond(), houseConfig.bedColor);
            }
        }
        playerConfig.builtStarterHouse = true;
        PlayerEntityTagMessage message = new PlayerEntityTagMessage();
        message.setMessageTag(playerConfig.createPlayerTag());
        class_2540 byteBuf = new class_2540(Unpooled.buffer());
        PlayerEntityTagMessage.encode(message, byteBuf);
        ServerSidePacketRegistry.INSTANCE.sendToPlayer(player, ModRegistry.PlayerConfigSync, byteBuf);
    }
}

