/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wuest.prefab.ClientModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.blocks.BlockStructureScanner;
import com.wuest.prefab.config.StructureScannerConfig;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.render.TranslucentVertexConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_757;
import net.minecraft.class_776;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class StructureRenderHandler {
    public static StructureConfiguration currentConfiguration;
    public static Structure currentStructure;
    public static class_2350 assumedNorth;
    public static boolean rendering;
    public static boolean showedMessage;
    private static int dimension;

    public static void setStructure(Structure structure, class_2350 assumedNorth, StructureConfiguration configuration) {
        currentStructure = structure;
        StructureRenderHandler.assumedNorth = assumedNorth;
        currentConfiguration = configuration;
        showedMessage = false;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null) {
            dimension = mc.field_1687.method_8597().method_32925();
        }
    }

    public static void renderPlayerLook(class_1657 player, class_239 src, class_4587 matrixStack, CallbackInfo callbackInfo) {
        if (currentStructure != null && dimension == player.field_6002.method_8597().method_32925() && currentConfiguration != null && Prefab.serverConfiguration.enableStructurePreview) {
            rendering = true;
            class_4597.class_4598 entityVertexConsumer = class_310.method_1551().method_22940().method_23000();
            class_4604 frustum = new class_4604(matrixStack.method_23760().method_23761(), RenderSystem.getProjectionMatrix());
            class_2338 cameraPos = player.method_33575();
            frustum.method_23088((double)cameraPos.method_10263(), (double)cameraPos.method_10264(), (double)cameraPos.method_10260());
            for (BuildBlock buildBlock : currentStructure.getBlocks()) {
                class_2338 pos;
                class_238 box;
                class_2248 foundBlock = (class_2248)class_2378.field_11146.method_10223(buildBlock.getResourceLocation());
                if (foundBlock == null || !frustum.method_23093(box = new class_238((double)(pos = buildBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing)).method_10263() - 0.5, (double)pos.method_10264() - 0.5, (double)pos.method_10260() - 0.5, (double)pos.method_10263() + 1.5, (double)pos.method_10264() + 1.5, (double)pos.method_10260() + 1.5))) continue;
                class_2680 blockState = foundBlock.method_9564();
                buildBlock = BuildBlock.SetBlockState(currentConfiguration, player.field_6002, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock, foundBlock, blockState, currentStructure);
                StructureRenderHandler.renderComponentInWorld(player.field_6002, buildBlock, (class_4597)entityVertexConsumer, matrixStack, pos);
            }
            entityVertexConsumer.method_22994(class_1921.method_23583());
            if (!showedMessage) {
                class_2588 message = new class_2588("prefab.gui.preview.notice");
                message.method_10862(class_2583.field_24360.method_10977(class_124.field_1060));
                player.method_7353((class_2561)message, false);
                message = new class_2588("prefab.gui.structure.block.clicked");
                message.method_10862(class_2583.field_24360.method_10977(class_124.field_1054));
                player.method_7353((class_2561)message, false);
                showedMessage = true;
            }
        }
    }

    private static boolean renderComponentInWorld(class_1937 world, BuildBlock buildBlock, class_4597 entityVertexConsumer, class_4587 matrixStack, class_2338 pos) {
        class_2680 targetBlock = world.method_8320(pos);
        if (targetBlock.method_26207() != class_3614.field_15959 && targetBlock.method_26207() != class_3614.field_15920) {
            return false;
        }
        StructureRenderHandler.doRenderComponent(world, buildBlock, pos, entityVertexConsumer, matrixStack);
        if (buildBlock.getSubBlock() != null) {
            class_2248 foundBlock = (class_2248)class_2378.field_11146.method_10223(buildBlock.getSubBlock().getResourceLocation());
            class_2680 blockState = foundBlock.method_9564();
            BuildBlock subBlock = BuildBlock.SetBlockState(currentConfiguration, world, StructureRenderHandler.currentConfiguration.pos, assumedNorth, buildBlock.getSubBlock(), foundBlock, blockState, currentStructure);
            class_2338 subBlockPos = subBlock.getStartingPosition().getRelativePosition(StructureRenderHandler.currentConfiguration.pos, currentStructure.getClearSpace().getShape().getDirection(), StructureRenderHandler.currentConfiguration.houseFacing);
            return StructureRenderHandler.renderComponentInWorld(world, subBlock, entityVertexConsumer, matrixStack, subBlockPos);
        }
        return true;
    }

    private static void doRenderComponent(class_1937 world, BuildBlock buildBlock, class_2338 pos, class_4597 entityVertexConsumer, class_4587 matrixStack) {
        class_2680 state = buildBlock.getBlockState();
        StructureRenderHandler.renderBlock(world, matrixStack, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), state, entityVertexConsumer, pos);
    }

    private static void renderBlock(class_1937 world, class_4587 matrixStack, class_243 pos, class_2680 state, class_4597 entityVertexConsumer, class_2338 blockPos) {
        class_310 minecraft = class_310.method_1551();
        class_4184 camera = minecraft.method_1561().field_4686;
        class_243 projectedView = camera.method_19326();
        if (state.method_26217() != class_2464.field_11455 && state.method_26217() == class_2464.field_11458) {
            matrixStack.method_22903();
            matrixStack.method_22904(-projectedView.method_10216(), -projectedView.method_10214(), -projectedView.method_10215());
            matrixStack.method_22904(pos.field_1352, pos.field_1351, pos.field_1350);
            class_776 blockRenderManager = minecraft.method_1541();
            class_4588 consumer = entityVertexConsumer.getBuffer(class_1921.method_23583());
            TranslucentVertexConsumer translucentConsumer = new TranslucentVertexConsumer(consumer, 100);
            int color = minecraft.method_1505().method_1697(state, (class_1920)world, blockPos, 50);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            blockRenderManager.method_3350().method_3367(matrixStack.method_23760(), (class_4588)translucentConsumer, state, blockRenderManager.method_3349(state), r, g, b, 0xF000F0, class_4608.field_21444);
            matrixStack.method_22909();
        }
    }

    public static void RenderTest(class_1937 worldIn, class_4587 matrixStack, double cameraX, double cameraY, double cameraZ) {
        if (currentStructure != null && dimension == class_310.method_1551().field_1724.field_6002.method_8597().method_32925() && currentConfiguration != null && Prefab.serverConfiguration.enableStructurePreview) {
            class_2338 originalPos = StructureRenderHandler.currentConfiguration.pos.method_10084();
            double blockXOffset = originalPos.method_10263();
            double blockZOffset = originalPos.method_10260();
            double blockStartYOffset = originalPos.method_10264();
            StructureRenderHandler.drawBox(matrixStack, blockXOffset, blockZOffset, blockStartYOffset, cameraX, cameraY, cameraZ, 1, 1, 1);
        }
    }

    public static void drawBox(class_4587 matrixStack, double blockXOffset, double blockZOffset, double blockStartYOffset, double cameraX, double cameraY, double cameraZ, int xLength, int zLength, int height) {
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.disableTexture();
        RenderSystem.disableBlend();
        double translatedX = blockXOffset - cameraX;
        double translatedY = blockStartYOffset - cameraY + 0.02;
        double translatedYEnd = translatedY + (double)height - 0.02;
        double translatedZ = blockZOffset - cameraZ;
        RenderSystem.lineWidth((float)2.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        bufferBuilder.method_22912(translatedX, translatedY, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX, translatedYEnd, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        tessellator.method_1350();
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedY, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedYEnd, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        tessellator.method_1350();
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        bufferBuilder.method_22912(translatedX, translatedY, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX, translatedYEnd, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        tessellator.method_1350();
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        tessellator.method_1350();
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        bufferBuilder.method_22912(translatedX, translatedY, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX, translatedY, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedY, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX, translatedY, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedY, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedY, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX, translatedY, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        tessellator.method_1350();
        bufferBuilder.method_1328(class_293.class_5596.field_29345, class_290.field_1576);
        bufferBuilder.method_22912(translatedX, translatedYEnd, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX, translatedYEnd, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedYEnd, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX, translatedYEnd, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedYEnd, translatedZ).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX + (double)xLength, translatedYEnd, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(translatedX, translatedYEnd, translatedZ + (double)zLength).method_22915(1.0f, 1.0f, 0.0f, 1.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.enableTexture();
    }

    public static void renderScanningBoxes(class_4587 matrixStack, double cameraX, double cameraY, double cameraZ) {
        for (int i = 0; i < ClientModRegistry.structureScanners.size(); ++i) {
            StructureScannerConfig config = ClientModRegistry.structureScanners.get(i);
            class_2338 pos = config.blockPos;
            boolean removeConfig = false;
            boolean bl = removeConfig = pos == null;
            if (pos != null) {
                boolean bl2 = removeConfig = !(class_310.method_1551().field_1687.method_8320(pos).method_26204() instanceof BlockStructureScanner);
            }
            if (removeConfig) {
                ClientModRegistry.structureScanners.remove(i);
                --i;
                continue;
            }
            class_2350 leftDirection = config.direction.method_10160();
            class_2338 startingPosition = config.blockPos.method_10079(leftDirection, config.blocksToTheLeft).method_10079(class_2350.field_11033, config.blocksDown).method_10079(config.direction, config.blocksParallel);
            int xLength = config.blocksWide;
            int zLength = config.blocksLong;
            switch (config.direction) {
                case field_11043: {
                    zLength = -zLength;
                    startingPosition = startingPosition.method_10093(config.direction.method_10153());
                    break;
                }
                case field_11034: {
                    int tempWidth = xLength;
                    xLength = zLength;
                    zLength = tempWidth;
                    break;
                }
                case field_11035: {
                    xLength = -xLength;
                    startingPosition = startingPosition.method_10093(config.direction.method_10160());
                    break;
                }
                case field_11039: {
                    int tempLength = zLength;
                    zLength = -xLength;
                    xLength = -tempLength;
                    startingPosition = startingPosition.method_10093(config.direction.method_10153());
                    startingPosition = startingPosition.method_10093(config.direction.method_10160());
                    break;
                }
            }
            StructureRenderHandler.drawBox(matrixStack, startingPosition.method_10263(), startingPosition.method_10260(), startingPosition.method_10264(), cameraX, cameraY, cameraZ, xLength, zLength, config.blocksTall);
        }
    }

    static {
        rendering = false;
        showedMessage = false;
    }
}

