/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.crafting.conditions.FluidTagEmptyCondition;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BlueBandedBeeEntity;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModConfiguredFeatures;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModFeatures;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.integrations.top.TopPlugin;
import cy.jdkdigital.productivebees.network.PacketHandler;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.setup.ClientProxy;
import cy.jdkdigital.productivebees.setup.ClientSetup;
import cy.jdkdigital.productivebees.setup.IProxy;
import cy.jdkdigital.productivebees.setup.ServerProxy;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="productivebees")
@Mod.EventBusSubscriber(modid="productivebees")
public final class ProductiveBees {
    public static final String MODID = "productivebees";
    public static final Random rand = new Random();
    public static final IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final Logger LOGGER = LogManager.getLogger();

    public ProductiveBees() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoad);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModPointOfInterestTypes.POINT_OF_INTEREST_TYPES.register(modEventBus);
        ModFluids.FLUIDS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModEntities.HIVE_BEES.register(modEventBus);
        ModEntities.SOLITARY_BEES.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        ModContainerTypes.CONTAINER_TYPES.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModRecipeTypes.RECIPE_SERIALIZERS.register(modEventBus);
        ModParticles.PARTICLE_TYPES.register(modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modEventBus.addListener(ClientSetup::init);
            modEventBus.addListener(EventPriority.LOWEST, ClientSetup::registerParticles);
        });
        modEventBus.addListener(this::onInterModEnqueue);
        modEventBus.addGenericListener(Feature.class, this::onRegisterFeatures);
        modEventBus.addListener(this::onCommonSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ProductiveBeesConfig.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ProductiveBeesConfig.CLIENT_CONFIG);
        CraftingHelper.register((IConditionSerializer)FluidTagEmptyCondition.Serializer.INSTANCE);
    }

    public void onInterModEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopPlugin::new);
        }
    }

    public void onServerStarting(AddReloadListenerEvent event) {
        BeeReloadListener.recipeManager = event.getDataPackRegistries().func_240967_e_();
        event.addListener((IFutureReloadListener)BeeReloadListener.INSTANCE);
    }

    public void onRegisterFeatures(RegistryEvent.Register<Feature<?>> event) {
        ModConfiguredFeatures.registerConfiguredFeatures();
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        CapabilityBee.register();
        PacketHandler.init();
        ModAdvancements.register();
        OptionalDispenseBehavior cageDispenseBehavior = new OptionalDispenseBehavior(){
            private final DefaultDispenseItemBehavior fallbackDispenseBehavior = new DefaultDispenseItemBehavior();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                if (stack.func_77973_b() instanceof BeeCage && BeeCage.isFilled(stack)) {
                    Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
                    BeeEntity entity = BeeCage.getEntityFromStack(stack, (World)source.func_197524_h(), true);
                    if (entity != null) {
                        entity.field_226369_bI_ = null;
                        BlockPos spawnPos = source.func_180699_d().func_177972_a(direction);
                        entity.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
                        if (source.func_197524_h().func_217376_c((Entity)entity)) {
                            if (stack.func_77973_b().equals(ModItems.BEE_CAGE.get())) {
                                stack.func_190918_g(1);
                            } else if (stack.func_77973_b().equals(ModItems.STURDY_BEE_CAGE.get())) {
                                stack.func_77982_d(null);
                            }
                        }
                        return stack;
                    }
                }
                return this.fallbackDispenseBehavior.dispense(source, stack);
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.BEE_CAGE.get()), (IDispenseItemBehavior)cageDispenseBehavior);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModItems.STURDY_BEE_CAGE.get()), (IDispenseItemBehavior)cageDispenseBehavior);
        DeferredWorkQueue.runLater(() -> {
            EntityType bee;
            for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
                bee = (EntityType)registryObject.get();
                GlobalEntityTypeAttributes.put((EntityType)bee, (AttributeModifierMap)ProductiveBeeEntity.getDefaultAttributes().func_233813_a_());
            }
            for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
                bee = (EntityType)registryObject.get();
                GlobalEntityTypeAttributes.put((EntityType)bee, (AttributeModifierMap)ProductiveBeeEntity.getDefaultAttributes().func_233813_a_());
            }
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntities.BLUE_BANDED_BEE.get()), (AttributeModifierMap)BlueBandedBeeEntity.getDefaultAttributes().func_233813_a_());
        });
        this.fixPOI(event);
    }

    private void onBiomeLoad(BiomeLoadingEvent event) {
        ModFeatures.registerFeatures(event);
    }

    private void fixPOI(FMLCommonSetupEvent event) {
        for (RegistryObject poi : ModPointOfInterestTypes.POINT_OF_INTEREST_TYPES.getEntries()) {
            ModPointOfInterestTypes.fixPOITypeBlockStates((PointOfInterestType)poi.get());
        }
        PointOfInterestType.field_226356_s_.field_221075_w = this.makePOIStatesMutable(PointOfInterestType.field_226356_s_.field_221075_w);
        ImmutableList beehives = (ImmutableList)ForgeRegistries.BLOCKS.getValues().stream().filter(block -> block instanceof AdvancedBeehive && !(block instanceof DragonEggHive)).collect(ImmutableList.toImmutableList());
        for (Block block2 : beehives) {
            for (BlockState state : block2.func_176194_O().func_177619_a()) {
                PointOfInterestType.field_221073_u.put(state, PointOfInterestType.field_226356_s_);
                try {
                    PointOfInterestType.field_226356_s_.field_221075_w.add(state);
                }
                catch (Exception e) {
                    LOGGER.warn("Could not add blockstate to beehive POI " + state);
                }
            }
        }
    }

    private Set<BlockState> makePOIStatesMutable(Set<BlockState> toCopy) {
        HashSet copy = Sets.newHashSet();
        copy.addAll(toCopy);
        return copy;
    }
}

