/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.item;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import cy.jdkdigital.productivebees.common.item.WoodChip;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;

public class WoodChipRenderer
extends ItemStackTileEntityRenderer {
    private static HashMap<String, TextureAtlasSprite> blockTextureLocations = new HashMap();

    protected void add(IVertexBuilder builder, MatrixStack matrixStack, float x, float y, float z, float u, float v) {
        builder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(u, v).func_225587_b_(0, 240).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    protected void addBox(IVertexBuilder builder, MatrixStack matrixStack, TextureAtlasSprite sprite, int fromX, int fromY, int toX, int toY) {
        float startX = (float)fromX / 16.0f;
        float startY = (float)fromY / 16.0f;
        float endX = (float)toX / 16.0f;
        float endY = (float)toY / 16.0f;
        this.add(builder, matrixStack, startX, startY, 1.0f, sprite.func_94214_a((double)fromX), sprite.func_94207_b((double)fromY));
        this.add(builder, matrixStack, endX, startY, 1.0f, sprite.func_94214_a((double)toX), sprite.func_94207_b((double)fromY));
        this.add(builder, matrixStack, endX, endY, 1.0f, sprite.func_94214_a((double)toX), sprite.func_94207_b((double)toY));
        this.add(builder, matrixStack, startX, endY, 1.0f, sprite.func_94214_a((double)fromX), sprite.func_94207_b((double)toY));
        this.add(builder, matrixStack, startX, endY, 1.0f, sprite.func_94214_a((double)fromX), sprite.func_94207_b((double)toY));
        this.add(builder, matrixStack, endX, endY, 1.0f, sprite.func_94214_a((double)toX), sprite.func_94207_b((double)toY));
        this.add(builder, matrixStack, endX, startY, 1.0f, sprite.func_94214_a((double)toX), sprite.func_94207_b((double)fromY));
        this.add(builder, matrixStack, startX, startY, 1.0f, sprite.func_94214_a((double)fromX), sprite.func_94207_b((double)fromY));
    }

    public void func_239207_a_(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLightIn, int packedUV) {
        Item item = itemStack.func_77973_b();
        if (item instanceof WoodChip) {
            TextureAtlasSprite sprite;
            IVertexBuilder builder = renderTypeBuffer.getBuffer(RenderType.func_228643_e_());
            Block woodBlock = WoodChip.getBlock(itemStack);
            if (woodBlock != null && woodBlock != Blocks.field_150350_a && (sprite = WoodChipRenderer.getBlockSprite(woodBlock)) != null) {
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.5, 0.5, 0.5);
                if (!itemStack.func_82839_y()) {
                    matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                }
                matrixStack.func_227861_a_(-0.5, -0.5, -1.0);
                this.addBox(builder, matrixStack, sprite, 5, 1, 9, 12);
                this.addBox(builder, matrixStack, sprite, 6, 0, 8, 1);
                this.addBox(builder, matrixStack, sprite, 4, 2, 5, 8);
                this.addBox(builder, matrixStack, sprite, 3, 3, 4, 5);
                this.addBox(builder, matrixStack, sprite, 9, 3, 10, 10);
                this.addBox(builder, matrixStack, sprite, 10, 4, 11, 7);
                this.addBox(builder, matrixStack, sprite, 5, 12, 8, 13);
                this.addBox(builder, matrixStack, sprite, 6, 13, 7, 14);
                matrixStack.func_227865_b_();
            }
        }
    }

    protected static TextureAtlasSprite getBlockSprite(@Nonnull Block block) {
        String woodName = block.getRegistryName().toString();
        if (blockTextureLocations.get(woodName) != null) {
            return blockTextureLocations.get(woodName);
        }
        BlockRendererDispatcher manager = Minecraft.func_71410_x().func_175602_ab();
        IBakedModel model = manager.func_184389_a(block.func_176223_P());
        List quads = model.func_200117_a(block.func_176223_P(), Direction.NORTH, new Random());
        if (quads.isEmpty()) {
            return null;
        }
        TextureAtlasSprite sprite = ((BakedQuad)quads.iterator().next()).func_187508_a();
        blockTextureLocations.put(woodName, sprite);
        return blockTextureLocations.get(woodName);
    }
}

