/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.CombBlock;
import cy.jdkdigital.productivebees.common.tileentity.CombBlockTileEntity;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeCreator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigurableCombBlock
extends CombBlock {
    public ConfigurableCombBlock(AbstractBlock.Properties properties, String colorCode) {
        super(properties, colorCode);
    }

    @Override
    public int getColor(IBlockDisplayReader world, BlockPos pos) {
        TileEntity tileEntity;
        if (world != null && pos != null && (tileEntity = world.func_175625_s(pos)) instanceof CombBlockTileEntity) {
            return ((CombBlockTileEntity)tileEntity).getColor();
        }
        return this.getColor();
    }

    public void func_149666_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (!((Object)((Object)this)).equals(ForgeRegistries.BLOCKS.getValue(this.getRegistryName()))) {
            super.func_149666_a(group, items);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CombBlockTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        CompoundNBT tag;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CombBlockTileEntity && (tag = stack.func_179543_a("EntityTag")) != null && tag.func_74764_b("type")) {
            ((CombBlockTileEntity)tileEntity).setType(tag.func_74779_i("type"));
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        String type;
        ItemStack stack = new ItemStack((IItemProvider)ModItems.CONFIGURABLE_COMB_BLOCK.get());
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CombBlockTileEntity && (type = ((CombBlockTileEntity)tileEntity).getCombType()) != null) {
            BeeCreator.setTag(type, stack);
        }
        return stack;
    }
}

