/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.DragonEggHive;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ExpansionBox
extends Block {
    public static final BooleanProperty HAS_HONEY = BooleanProperty.func_177716_a((String)"has_honey");

    public ExpansionBox(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BeehiveBlock.field_226872_b_, (Comparable)Direction.NORTH)).func_206870_a(AdvancedBeehive.EXPANDED, (Comparable)((Object)VerticalHive.NONE))).func_206870_a((Property)HAS_HONEY, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BeehiveBlock.field_226872_b_, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BeehiveBlock.field_226872_b_, AdvancedBeehive.EXPANDED, HAS_HONEY});
    }

    public void updateState(World world, BlockPos pos, BlockState state, boolean isRemoved) {
        Pair<Pair<BlockPos, Direction>, BlockState> pair = ExpansionBox.getAdjacentHive(world, pos);
        if (pair != null) {
            Pair posAndDirection = (Pair)pair.getLeft();
            BlockPos hivePos = (BlockPos)posAndDirection.getLeft();
            VerticalHive directionProperty = AdvancedBeehive.calculateExpandedDirection(world, hivePos, isRemoved);
            if (!isRemoved) {
                this.updateStateWithDirection(world, pos, state, directionProperty);
            }
            ((AdvancedBeehive)((BlockState)pair.getRight()).func_177230_c()).updateStateWithDirection(world, hivePos, (BlockState)pair.getRight(), directionProperty);
        } else if (!isRemoved) {
            this.updateStateWithDirection(world, pos, state, VerticalHive.NONE);
        }
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        Pair posAndDirection;
        BlockPos hivePos;
        TileEntity hiveTileEntity;
        Pair<Pair<BlockPos, Direction>, BlockState> pair;
        ItemStack heldItem = player.func_184614_ca();
        if (heldItem.func_77973_b().equals(Items.field_151055_y) && !((VerticalHive)((Object)state.func_177229_b(AdvancedBeehive.EXPANDED))).equals((Object)VerticalHive.NONE) && (pair = ExpansionBox.getAdjacentHive(worldIn, pos)) != null && (hiveTileEntity = worldIn.func_175625_s(hivePos = (BlockPos)(posAndDirection = (Pair)pair.getLeft()).getLeft())) instanceof AdvancedBeehiveTileEntityAbstract) {
            ((AdvancedBeehiveTileEntityAbstract)hiveTileEntity).func_226963_a_(player, state, BeehiveTileEntity.State.BEE_RELEASED);
        }
        super.func_196270_a(state, worldIn, pos, player);
    }

    public void updateStateWithDirection(World world, BlockPos pos, BlockState state, VerticalHive directionProperty) {
        world.func_175656_a(pos, (BlockState)state.func_206870_a(AdvancedBeehive.EXPANDED, (Comparable)((Object)directionProperty)));
    }

    public static Pair<Pair<BlockPos, Direction>, BlockState> getAdjacentHive(World world, BlockPos pos) {
        for (Direction direction : BlockStateProperties.field_208155_H.func_177700_c()) {
            BlockPos newPos;
            BlockState blockStateAtPos;
            Block blockAtPos;
            if (direction == Direction.UP || !((blockAtPos = (blockStateAtPos = world.func_180495_p(newPos = pos.func_177972_a(direction))).func_177230_c()) instanceof AdvancedBeehive) || blockAtPos instanceof DragonEggHive) continue;
            return Pair.of((Object)Pair.of((Object)newPos, (Object)direction), (Object)blockStateAtPos);
        }
        return null;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        if (!world.func_201670_d()) {
            this.updateState(world, pos, state, false);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        boolean removed = super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        if (!world.func_201670_d()) {
            this.updateState(world, pos, state, true);
        }
        return removed;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.EXPANSION_BOX.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileEntity;
        Pair<Pair<BlockPos, Direction>, BlockState> pair;
        if (!worldIn.field_72995_K && (pair = ExpansionBox.getAdjacentHive(worldIn, pos)) != null && (tileEntity = worldIn.func_175625_s((BlockPos)((Pair)pair.getLeft()).getLeft())) instanceof AdvancedBeehiveTileEntity) {
            this.updateState(worldIn, pos, state, false);
            BlockState blockState = tileEntity.func_195044_w();
            worldIn.func_184138_a(pos, blockState, blockState, 3);
            ((AdvancedBeehive)blockState.func_177230_c()).openGui((ServerPlayerEntity)player, (AdvancedBeehiveTileEntity)tileEntity);
        }
        return ActionResultType.SUCCESS;
    }
}

