/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.client.particle.NectarParticleType;
import cy.jdkdigital.productivebees.common.entity.bee.IEffectBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntity;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.BeeEffect;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class ConfigurableBeeEntity
extends ProductiveBeeEntity
implements IEffectBeeEntity {
    private int attackCooldown = 0;
    public int breathCollectionCooldown = 600;
    private int teleportCooldown = 250;
    private static Map<Integer, float[]> colorCache = new HashMap<Integer, float[]>();
    public static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(ConfigurableBeeEntity.class, (IDataSerializer)DataSerializers.field_187194_d);

    public ConfigurableBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
        this.beehiveInterests = poiType -> poiType == PointOfInterestType.field_226356_s_ || poiType == ModPointOfInterestTypes.SOLITARY_HIVE.get() && this.isWild() || poiType == ModPointOfInterestTypes.SOLITARY_NEST.get() && this.isWild() || poiType == ModPointOfInterestTypes.DRACONIC_NEST.get() && this.isDraconic() || poiType == ModPointOfInterestTypes.SUGARBAG_NEST.get() && this.getBeeType().equals("productivebees:sugarbag");
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason spawnReason, @Nullable ILivingEntityData livingEntityData, @Nullable CompoundNBT tag) {
        String type = "";
        if (tag != null) {
            String string = tag.func_74764_b("type") ? tag.func_74779_i("type") : (type = tag.func_74764_b("EntityTag") ? tag.func_74775_l("EntityTag").func_74779_i("type") : "");
        }
        if (type.equals("productivebees:ghostly") && ProductiveBees.rand.nextFloat() < 0.02f) {
            this.func_200203_b((ITextComponent)new StringTextComponent("BooBee"));
        } else if (type.equals("productivebees:blitz") && ProductiveBees.rand.nextFloat() < 0.02f) {
            this.func_200203_b((ITextComponent)new StringTextComponent("King BitzBee"));
        } else if (type.equals("productivebees:basalz") && ProductiveBees.rand.nextFloat() < 0.02f) {
            this.func_200203_b((ITextComponent)new StringTextComponent("Queen BazBee"));
        } else if (type.equals("productivebees:blizz") && ProductiveBees.rand.nextFloat() < 0.02f) {
            this.func_200203_b((ITextComponent)new StringTextComponent("Shiny BizBee"));
        } else if (type.equals("productivebees:redstone") && ProductiveBees.rand.nextFloat() < 0.01f) {
            this.func_200203_b((ITextComponent)new StringTextComponent("Redastone Bee"));
        } else if (type.equals("productivebees:destabilized_redstone") && ProductiveBees.rand.nextFloat() < 0.1f) {
            this.func_200203_b((ITextComponent)new StringTextComponent("Destabilized RedaStone Bee"));
        }
        return super.func_213386_a(world, difficulty, spawnReason, livingEntityData, tag);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            --this.teleportCooldown;
            if (--this.attackCooldown < 0) {
                this.attackCooldown = 0;
            }
            if (this.attackCooldown == 0 && this.func_233678_J__() && this.func_70638_az() != null && this.func_70638_az().func_70068_e((Entity)this) < 4.0) {
                this.attackCooldown = this.getEffectCooldown(this.getAttributeValue(BeeAttributes.TEMPER));
                this.attackTarget(this.func_70638_az());
            }
            if (--this.breathCollectionCooldown <= 0) {
                this.breathCollectionCooldown = 600;
                if (this.isDraconic() && this.field_70170_p.func_234923_W_() == World.field_234920_i_) {
                    this.func_226447_r_(true);
                }
            }
            if (this.field_70173_aa % 20 == 0 && this.func_226411_eD_() && this.isRedstoned()) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos beePosDown = this.func_233580_cy_().func_177979_c(i);
                    if (!this.field_70170_p.func_175623_d(beePosDown)) continue;
                    BlockState redstoneState = ((Block)ModBlocks.INVISIBLE_REDSTONE_BLOCK.get()).func_176223_P();
                    this.field_70170_p.func_175656_a(beePosDown, redstoneState);
                    this.field_70170_p.func_205220_G_().func_205360_a(beePosDown, (Object)redstoneState.func_177230_c(), 20);
                }
            }
            if (this.field_70173_aa > 100 && this.getBeeType().isEmpty() && this.func_70089_S()) {
                this.func_174812_G();
            }
        }
    }

    public void func_226397_a_(World worldIn, double xMin, double xMax, double zMin, double zMax, double posY, IParticleData particleData) {
        NectarParticleType particle;
        switch (this.getParticleType()) {
            case "pop": {
                particle = (NectarParticleType)ModParticles.COLORED_POPPING_NECTAR.get();
                break;
            }
            case "lava": {
                particle = (NectarParticleType)ModParticles.COLORED_LAVA_NECTAR.get();
                break;
            }
            case "portal": {
                particle = (NectarParticleType)ModParticles.COLORED_PORTAL_NECTAR.get();
                break;
            }
            case "rising": {
                particle = (NectarParticleType)ModParticles.COLORED_RISING_NECTAR.get();
                break;
            }
            default: {
                particle = (NectarParticleType)ModParticles.COLORED_FALLING_NECTAR.get();
            }
        }
        if (this.hasParticleColor()) {
            particle.setColor(this.getParticleColor());
        } else {
            particle.setColor(new float[]{0.92f, 0.782f, 0.72f});
        }
        worldIn.func_195594_a((IParticleData)particle, MathHelper.func_219803_d((double)worldIn.field_73012_v.nextDouble(), (double)xMin, (double)xMax), posY, MathHelper.func_219803_d((double)worldIn.field_73012_v.nextDouble(), (double)zMin, (double)zMax), 0.0, 0.0, 0.0);
    }

    protected void func_70619_bc() {
        if (this.teleportCooldown <= 0) {
            if (null != this.field_70699_by.func_75505_d() && this.isTeleporting()) {
                int antiTeleportUpgrades;
                TileEntity te;
                if (this.func_226409_eA_() && (te = this.field_70170_p.func_175625_s(this.func_226410_eB_())) instanceof AdvancedBeehiveTileEntity && (antiTeleportUpgrades = ((AdvancedBeehiveTileEntity)te).getUpgradeCount((Item)ModItems.UPGRADE_ANTI_TELEPORT.get())) > 0) {
                    this.teleportCooldown = 10000;
                    super.func_70619_bc();
                    return;
                }
                BlockPos pos = this.field_70699_by.func_75505_d().func_224770_k();
                this.teleport(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            this.teleportCooldown = 250;
        }
        super.func_70619_bc();
    }

    public void func_213295_a(BlockState state, Vector3d motionMultiplierIn) {
        if (!this.isStringy() || state.func_177230_c() != Blocks.field_196553_aF) {
            super.func_213295_a(state, motionMultiplierIn);
        }
    }

    @Override
    public void attackTarget(LivingEntity target) {
        if (this.func_70089_S() && this.getNBTData().func_74764_b("attackResponse")) {
            String attackResponse;
            switch (attackResponse = this.getNBTData().func_74779_i("attackResponse")) {
                case "fire": {
                    target.func_241209_g_(200);
                }
                case "lava": {
                    this.field_70170_p.func_180501_a(target.func_233580_cy_(), Blocks.field_150353_l.func_176223_P(), 11);
                }
            }
        }
    }

    public void setBeeType(String data) {
        this.field_70180_af.func_187227_b(TYPE, (Object)data);
    }

    @Override
    public String getBeeType() {
        return (String)this.field_70180_af.func_187225_a(TYPE);
    }

    @Override
    public void func_226449_s_(boolean hasStung) {
        if (!this.isStingless()) {
            super.func_226449_s_(hasStung);
        }
    }

    public void func_184206_a(DataParameter<?> param) {
        if (TYPE.equals(param)) {
            this.func_213323_x_();
        }
        super.func_184206_a(param);
    }

    public void setAttributes() {
        CompoundNBT nbt = this.getNBTData();
        if (nbt.func_74764_b("productivity")) {
            this.setAttributeValue(BeeAttributes.PRODUCTIVITY, nbt.func_74762_e("productivity"));
        }
        if (nbt.func_74764_b("temper")) {
            this.setAttributeValue(BeeAttributes.TEMPER, nbt.func_74762_e("temper"));
        }
        if (nbt.func_74764_b("endurance")) {
            this.setAttributeValue(BeeAttributes.ENDURANCE, nbt.func_74762_e("endurance"));
        }
        if (nbt.func_74764_b("behavior")) {
            this.setAttributeValue(BeeAttributes.BEHAVIOR, nbt.func_74762_e("behavior"));
        }
        if (nbt.func_74764_b("weather_tolerance")) {
            this.setAttributeValue(BeeAttributes.WEATHER_TOLERANCE, nbt.func_74762_e("weather_tolerance"));
        }
    }

    @Override
    public Color getColor(int tintIndex) {
        CompoundNBT nbt = this.getNBTData();
        if (nbt.func_74764_b("primaryColor")) {
            return tintIndex == 0 ? new Color(nbt.func_74762_e("primaryColor")) : new Color(nbt.func_74762_e("secondaryColor"));
        }
        return super.getColor(tintIndex);
    }

    @Nonnull
    protected ITextComponent func_225513_by_() {
        CompoundNBT nbt = this.getNBTData();
        if (nbt.func_74764_b("name")) {
            return new TranslationTextComponent("entity.productivebees.bee_configurable", new Object[]{nbt.func_74779_i("name")});
        }
        return super.func_225513_by_();
    }

    @Override
    public float getSizeModifier() {
        CompoundNBT nbt = this.getNBTData();
        return nbt != null ? nbt.func_74760_g("size") : super.getSizeModifier();
    }

    @Override
    public boolean canSelfBreed() {
        CompoundNBT nbt = this.getNBTData();
        return nbt.func_74767_n("selfbreed");
    }

    @Override
    public boolean isFlowerBlock(Block flowerBlock) {
        CompoundNBT nbt = this.getNBTData();
        if (nbt != null) {
            if (nbt.func_74764_b("flowerTag")) {
                ITag<Block> flowerTag = ModTags.getTag(new ResourceLocation(nbt.func_74779_i("flowerTag")));
                return flowerBlock.func_203417_a(flowerTag);
            }
            if (nbt.func_74764_b("flowerBlock")) {
                return flowerBlock.getRegistryName().toString().equals(nbt.func_74779_i("flowerBlock"));
            }
        }
        return super.isFlowerBlock(flowerBlock);
    }

    @Override
    public ITag<Block> getNestingTag() {
        CompoundNBT nbt = this.getNBTData();
        if (nbt != null && nbt.func_74764_b("nestingPreference")) {
            return ModTags.getTag(new ResourceLocation(nbt.func_74779_i("nestingPreference")));
        }
        return super.getNestingTag();
    }

    @Override
    public BeeEffect getBeeEffect() {
        CompoundNBT nbt = this.getNBTData();
        if (nbt.func_74764_b("effect")) {
            return new BeeEffect(nbt.func_74775_l("effect"));
        }
        return super.getBeeEffect();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)"");
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBeeType(compound.func_74779_i("type"));
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("type", this.getBeeType());
    }

    protected CompoundNBT getNBTData() {
        CompoundNBT nbt = BeeReloadListener.INSTANCE.getData(this.getBeeType());
        return nbt != null ? nbt : new CompoundNBT();
    }

    public boolean hasBeeTexture() {
        return this.getNBTData().func_74764_b("beeTexture");
    }

    public String getBeeTexture() {
        return this.getNBTData().func_74779_i("beeTexture");
    }

    @Override
    public String getRenderer() {
        return this.getNBTData().func_74779_i("renderer");
    }

    public String getRenderTransform() {
        return this.getNBTData().func_74779_i("renderTransform");
    }

    public boolean useGlowLayer() {
        return this.getNBTData().func_74767_n("useGlowLayer") || this.isRedstoned() && this.func_226411_eD_();
    }

    private boolean isWild() {
        return this.getNBTData().func_74764_b("nestingPreference");
    }

    public boolean isFireproof() {
        return this.getNBTData().func_74767_n("fireproof");
    }

    public boolean isWithered() {
        return this.getNBTData().func_74767_n("withered");
    }

    public boolean isTranslucent() {
        return this.getNBTData().func_74767_n("translucent");
    }

    public boolean isBlinding() {
        return this.getNBTData().func_74767_n("blinding");
    }

    public boolean isDraconic() {
        return this.getNBTData().func_74767_n("draconic");
    }

    public boolean isRedstoned() {
        return this.getNBTData().func_74767_n("redstoned");
    }

    public boolean isSlimy() {
        return this.getNBTData().func_74767_n("slimy");
    }

    public boolean isTeleporting() {
        return this.getNBTData().func_74767_n("teleporting");
    }

    public boolean isStringy() {
        return this.getNBTData().func_74767_n("stringy");
    }

    public boolean isStingless() {
        return this.getNBTData().func_74767_n("stingless");
    }

    public boolean hasMunchies() {
        return this.getNBTData().func_74767_n("munchies");
    }

    public boolean isWaterproof() {
        return this.getNBTData().func_74767_n("waterproof");
    }

    public String getParticleType() {
        return this.getNBTData().func_74779_i("particleType");
    }

    public boolean hasParticleColor() {
        return this.getNBTData().func_74764_b("particleColor");
    }

    public float[] getParticleColor() {
        Integer color = this.getNBTData().func_74762_e("particleColor");
        if (!colorCache.containsKey(color)) {
            colorCache.put(color, new Color(color).getComponents(null));
        }
        return colorCache.get(color);
    }

    public float[] getTertiaryColor() {
        CompoundNBT nbt = this.getNBTData();
        Integer color = nbt.func_74764_b("tertiaryColor") ? nbt.func_74762_e("tertiaryColor") : nbt.func_74762_e("primaryColor");
        if (!colorCache.containsKey(color)) {
            colorCache.put(color, new Color(color).getComponents(null));
        }
        return colorCache.get(color);
    }

    @Override
    public Map<Effect, Integer> getAggressiveEffects() {
        if (this.isWithered()) {
            return new HashMap<Effect, Integer>(){
                {
                    this.put(Effects.field_82731_v, 350);
                }
            };
        }
        if (this.hasMunchies()) {
            return new HashMap<Effect, Integer>(){
                {
                    this.put(Effects.field_76438_s, 530);
                }
            };
        }
        if (this.isBlinding()) {
            return new HashMap<Effect, Integer>(){
                {
                    this.put(Effects.field_76440_q, 450);
                }
            };
        }
        return null;
    }

    @Override
    public boolean func_180431_b(@Nonnull DamageSource source) {
        if (this.isWithered() && source.equals(DamageSource.field_82727_n)) {
            return true;
        }
        if (this.isDraconic() && source.equals(DamageSource.field_188407_q)) {
            return true;
        }
        if (this.isTranslucent() && source.equals(DamageSource.field_82728_o)) {
            return true;
        }
        if (this.isWaterproof() && source.equals(DamageSource.field_76369_e)) {
            return true;
        }
        if (this.isFireproof() && (source.equals(DamageSource.field_190095_e) || source.equals(DamageSource.field_76372_a) || source.equals(DamageSource.field_76370_b) || source.equals(DamageSource.field_76371_c))) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean func_70687_e(EffectInstance effect) {
        if (this.isWithered()) {
            return effect.func_188419_a() != Effects.field_82731_v && super.func_70687_e(effect);
        }
        return super.func_70687_e(effect);
    }

    private void teleport(double x, double y, double z) {
        boolean hasTeleported;
        EnderTeleportEvent event;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, y, z);
        while (blockpos$mutable.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76230_c()) {
            blockpos$mutable.func_189536_c(Direction.DOWN);
        }
        BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
        if (blockstate.func_185904_a().func_76230_c() && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f))) && (hasTeleported = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 0.3f, 0.3f);
            this.func_184185_a(SoundEvents.field_187534_aX, 0.2f, 1.0f);
        }
    }
}

