/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.entity.bee.solitary;

import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBeeEntity;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import cy.jdkdigital.productivebees.init.ModTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class BumbleBeeEntity
extends SolitaryBeeEntity
implements IRideable,
IEquipable {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(BumbleBeeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(BumbleBeeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final BoostHelper steering;

    public BumbleBeeEntity(EntityType<? extends BeeEntity> entityType, World world) {
        super(entityType, world);
        this.steering = new BoostHelper(this.field_70180_af, BOOST_TIME, SADDLED);
        this.beehiveInterests = poiType -> poiType == ModPointOfInterestTypes.BUMBLE_BEE_NEST.get();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.TREAT_ON_A_STICK.get()}), false));
    }

    @Override
    public String getRenderer() {
        return "thicc";
    }

    @Override
    public ITag<Block> getNestingTag() {
        return ModTags.BUMBLE_BEE_NESTS;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BOOST_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.steering.func_233616_a_();
        }
        super.func_184206_a(key);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_110257_ck()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity playerentity = (PlayerEntity)entity;
        return playerentity.func_184614_ca().func_77973_b() == ModItems.TREAT_ON_A_STICK.get() || playerentity.func_184592_cb().func_77973_b() == ModItems.TREAT_ON_A_STICK.get();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.steering.func_233618_a_(compound);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.steering.func_233621_b_(compound);
    }

    public boolean func_110257_ck() {
        return this.steering.func_233620_b_();
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    public void func_230266_a_(@Nullable SoundCategory soundCategory) {
        this.steering.func_233619_a_(true);
        if (soundCategory != null) {
            this.field_70170_p.func_217384_a(null, (Entity)this, SoundEvents.field_187706_dO, soundCategory, 0.5f, 1.0f);
        }
    }

    @Override
    public float getSizeModifier() {
        return 1.25f;
    }

    public void func_213352_e(Vector3d travelVector) {
        this.func_233622_a_((MobEntity)this, this.steering, travelVector);
    }

    public boolean func_184762_da() {
        return this.steering.func_233617_a_(this.func_70681_au());
    }

    public void func_230267_a__(Vector3d travelVec) {
        super.func_213352_e(travelVec);
    }

    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_);
    }

    @Nonnull
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        boolean flag = this.func_70877_b(player.func_184586_b(hand));
        if (!flag && this.func_110257_ck() && !this.func_184207_aI() && !player.func_226563_dT_()) {
            if (!this.field_70170_p.field_72995_K) {
                if (player instanceof ServerPlayerEntity) {
                    ModAdvancements.SADDLE_BEE.trigger((ServerPlayerEntity)player, this);
                }
                player.func_184220_m((Entity)this);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_233622_a_(MobEntity entity, BoostHelper boostHelper, Vector3d vec3d) {
        Entity rider;
        if (!entity.func_70089_S()) {
            return false;
        }
        Entity entity2 = rider = entity.func_184188_bt().isEmpty() ? null : (Entity)entity.func_184188_bt().get(0);
        if (entity.func_184207_aI() && entity.func_82171_bF() && rider instanceof PlayerEntity) {
            entity.field_70126_B = rider.field_70177_z;
            entity.field_70177_z = rider.field_70177_z % 360.0f;
            entity.field_70125_A = rider.field_70125_A * 0.5f % 360.0f;
            entity.field_70761_aq = entity.field_70177_z;
            entity.field_70759_as = entity.field_70177_z;
            entity.field_70138_W = 1.0f;
            entity.field_70747_aH = entity.func_70689_ay() * 0.1f;
            if (boostHelper.field_233610_a_ && boostHelper.field_233611_b_++ > boostHelper.field_233612_c_) {
                boostHelper.field_233610_a_ = false;
            }
            if (entity.func_184186_bw()) {
                float speed = this.func_230265_N__();
                if (boostHelper.field_233610_a_) {
                    speed += speed * 2.15f * MathHelper.func_76126_a((float)((float)boostHelper.field_233611_b_ / (float)boostHelper.field_233612_c_ * (float)Math.PI));
                }
                entity.func_70659_e(speed);
                this.func_230267_a__(new Vector3d(0.0, !this.field_70170_p.func_175623_d(this.func_233580_cy_().func_177979_c(3)) ? 1.0 : (this.field_70170_p.func_175623_d(this.func_233580_cy_().func_177979_c(1)) ? -1.0 : 0.0), 1.0));
                if (entity instanceof BumbleBeeEntity) {
                    this.setNewPosRotationIncrements(0);
                }
            } else {
                entity.func_233629_a_((LivingEntity)entity, false);
                entity.func_213317_d(Vector3d.field_186680_a);
            }
            return true;
        }
        entity.field_70138_W = 0.5f;
        entity.field_70747_aH = 0.02f;
        this.func_230267_a__(vec3d);
        return false;
    }

    public void setNewPosRotationIncrements(int value) {
        this.field_70716_bi = value;
    }
}

