/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.common.item.UpgradeItem;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FilterUpgradeItem
extends UpgradeItem {
    private static final String KEY = "productivebees_allowed_bees";

    public FilterUpgradeItem(Item.Properties properties) {
        super(properties);
    }

    public static void addAllowedBee(ItemStack stack, BeeEntity bee) {
        String type = BeeIngredientFactory.getIngredientKey(bee);
        if (type != null) {
            CompoundNBT tag = stack.func_196082_o();
            INBT list = tag.func_74781_a(KEY);
            if (!(list instanceof ListNBT)) {
                list = new ListNBT();
            }
            for (INBT inbtType : (ListNBT)list) {
                if (!inbtType.func_150285_a_().equals(type)) continue;
                return;
            }
            ((ListNBT)list).add((Object)StringNBT.func_229705_a_((String)type));
            tag.func_218657_a(KEY, list);
            stack.func_77982_d(tag);
        }
    }

    public static List<Supplier<BeeIngredient>> getAllowedBees(ItemStack stack) {
        ListNBT list;
        CompoundNBT tag = stack.func_77978_p();
        ArrayList<Supplier<BeeIngredient>> beeList = new ArrayList<Supplier<BeeIngredient>>();
        if (tag != null && tag.func_74764_b(KEY) && (list = (ListNBT)tag.func_74781_a(KEY)) != null) {
            for (INBT type : list) {
                beeList.add(BeeIngredientFactory.getIngredient(type.func_150285_a_()));
            }
        }
        return beeList;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, tooltip, flagIn);
        List<Supplier<BeeIngredient>> beeList = FilterUpgradeItem.getAllowedBees(stack);
        for (Supplier<BeeIngredient> allowedBee : beeList) {
            tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.information.upgrade.filter_entity", new Object[]{allowedBee.get().getBeeType()}).func_240699_a_(TextFormatting.GOLD));
        }
        if (!beeList.isEmpty()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.information.upgrade.filter").func_240699_a_(TextFormatting.WHITE));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.information.upgrade.filter_empty").func_240699_a_(TextFormatting.WHITE));
        }
    }

    @Nonnull
    public ActionResultType func_111207_a(ItemStack itemStack, PlayerEntity player, LivingEntity targetIn, Hand hand) {
        if (targetIn.func_130014_f_().func_201670_d() || !(targetIn instanceof BeeEntity)) {
            return ActionResultType.PASS;
        }
        FilterUpgradeItem.addAllowedBee(itemStack, (BeeEntity)targetIn);
        return ActionResultType.SUCCESS;
    }
}

