/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeAttribute;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import cy.jdkdigital.productivebees.util.ColorUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HoneyTreat
extends Item {
    private static final String GENES_KEY = "productivebees_gene_stack";

    public HoneyTreat(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasGene(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        return !itemStack.func_190926_b() && tag != null && tag.func_74764_b(GENES_KEY);
    }

    public static ItemStack getTypeStack(String beeType, int value) {
        ItemStack treat = new ItemStack((IItemProvider)ModItems.HONEY_TREAT.get());
        HoneyTreat.addGene(treat, Gene.getStack(beeType, value));
        return treat;
    }

    public static void addGene(ItemStack stack, ItemStack gene) {
        ListNBT genes = HoneyTreat.getGenes(stack);
        boolean addedToExistingGene = false;
        for (INBT inbt : genes) {
            ItemStack insertedGene = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt));
            int purity = Gene.getPurity(insertedGene);
            if (!Gene.getAttributeName(insertedGene).equals(Gene.getAttributeName(gene)) || !Gene.getValue(insertedGene).equals(Gene.getValue(gene))) continue;
            purity = Math.min(100, purity + Gene.getPurity(gene));
            Gene.setPurity(insertedGene, purity);
            addedToExistingGene = true;
        }
        if (!addedToExistingGene) {
            CompoundNBT serializedGene = gene.serializeNBT();
            genes.add((Object)serializedGene);
        }
        stack.func_196082_o().func_218657_a(GENES_KEY, (INBT)genes);
    }

    public static ListNBT getGenes(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        ListNBT genes = new ListNBT();
        if (tag != null && tag.func_74781_a(GENES_KEY) instanceof ListNBT) {
            genes = tag.func_74781_a(GENES_KEY);
        }
        return genes;
    }

    public static boolean hasBeeType(ItemStack stack) {
        ListNBT genes = HoneyTreat.getGenes(stack);
        for (INBT inbt : genes) {
            ItemStack insertedGene = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt));
            BeeAttribute<?> existingAttribute = Gene.getAttribute(insertedGene);
            if (existingAttribute != null || Gene.getAttributeName(insertedGene).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActionResultType func_111207_a(ItemStack itemStack, PlayerEntity player, LivingEntity target, Hand hand) {
        World world = target.func_130014_f_();
        if (target.func_130014_f_().func_201670_d() || !(target instanceof BeeEntity) || !target.func_70089_S()) {
            return ActionResultType.PASS;
        }
        BeeEntity bee = (BeeEntity)target;
        if (player instanceof ServerPlayerEntity && bee.func_233678_J__()) {
            ModAdvancements.CALM_BEE.trigger((ServerPlayerEntity)player, bee);
        }
        bee.func_230260_a__(0);
        bee.func_226450_t_(0);
        bee.func_70691_i(bee.func_110138_aP());
        if (bee.func_70631_g_()) {
            bee.func_175501_a((int)((float)(-bee.func_70874_b() / 20) * 0.1f), true);
        }
        itemStack.func_190918_g(1);
        BlockPos pos = target.func_233580_cy_();
        world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.2, 0.1, 0.2);
        if (bee instanceof ProductiveBeeEntity) {
            ProductiveBeeEntity productiveBee = (ProductiveBeeEntity)target;
            ListNBT genes = HoneyTreat.getGenes(itemStack);
            if (!genes.isEmpty()) {
                for (INBT inbt : genes) {
                    ItemStack insertedGene = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt));
                    int purity = Gene.getPurity(insertedGene);
                    if (((CompoundNBT)inbt).func_74764_b("purity")) {
                        purity = ((CompoundNBT)inbt).func_74762_e("purity");
                    }
                    if (ProductiveBees.rand.nextInt(100) > purity) continue;
                    productiveBee.setAttributeValue(Gene.getAttribute(insertedGene), Gene.getValue(insertedGene));
                    world.func_217379_c(2005, pos, 0);
                }
            } else {
                int temper = productiveBee.getAttributeValue(BeeAttributes.TEMPER);
                if (temper > 0 && player.field_70170_p.field_73012_v.nextFloat() < 0.05f) {
                    productiveBee.getBeeAttributes().put(BeeAttributes.TEMPER, --temper);
                }
            }
        }
        return ActionResultType.CONSUME;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        INBT genes;
        super.func_77624_a(stack, world, list, flag);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && (genes = tag.func_74781_a(GENES_KEY)) instanceof ListNBT) {
            ((ListNBT)genes).forEach(inbt -> {
                ItemStack insertedGene = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt));
                int purity = Gene.getPurity(insertedGene);
                if (((CompoundNBT)inbt).func_74764_b("purity")) {
                    purity = ((CompoundNBT)inbt).func_74762_e("purity");
                }
                Integer value = Gene.getValue(insertedGene);
                BeeAttribute<?> attribute = Gene.getAttribute(insertedGene);
                if (BeeAttributes.keyMap.containsKey(attribute)) {
                    IFormattableTextComponent translatedValue = new TranslationTextComponent(BeeAttributes.keyMap.get(attribute).get(value)).func_240699_a_(ColorUtil.getColor(value));
                    list.add((ITextComponent)new TranslationTextComponent("productivebees.information.attribute." + Gene.getAttributeName(insertedGene), new Object[]{translatedValue}).func_240699_a_(TextFormatting.DARK_GRAY).func_240702_b_(" (" + purity + "%)"));
                } else {
                    list.add((ITextComponent)new TranslationTextComponent("productivebees.information.attribute.type", new Object[]{Gene.getAttributeName(insertedGene)}).func_240699_a_(TextFormatting.DARK_GRAY).func_240702_b_(" (" + purity + "%)"));
                }
            });
        }
    }
}

