/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.init.ModPointOfInterestTypes;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class NestLocator
extends Item {
    private static final String KEY = "productivebees_locator_nest";

    public NestLocator(Item.Properties properties) {
        super(properties);
    }

    public static String getNestName(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        return nbt.func_74764_b("nestName") ? nbt.func_74779_i("nestName") : null;
    }

    public static String getNestRegistryName(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        return nbt.func_74764_b("nest") ? nbt.func_74779_i("nest") : null;
    }

    public static Block getNestBlock(ItemStack stack) {
        String registryName = NestLocator.getNestRegistryName(stack);
        if (registryName != null) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName));
        }
        return null;
    }

    public static void setNestBlock(ItemStack stack, @Nullable Block nest) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        nbt.func_82580_o("nest");
        if (nest != null && nest.getRegistryName() != null) {
            nbt.func_74778_a("nest", nest.getRegistryName().toString());
            nbt.func_74778_a("nestName", nest.func_235333_g_().getString());
        }
        stack.func_196082_o().func_218657_a(KEY, (INBT)nbt);
    }

    public static boolean hasNest(ItemStack stack) {
        return NestLocator.getNestRegistryName(stack) != null;
    }

    public static BlockPos getPosition(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        return nbt.func_74764_b("position") ? BlockPos.func_218283_e((long)nbt.func_74763_f("position")) : null;
    }

    public static void setPosition(ItemStack stack, @Nullable BlockPos pos) {
        CompoundNBT nbt = stack.func_196082_o().func_74775_l(KEY);
        if (pos != null) {
            nbt.func_74772_a("position", pos.func_218275_a());
        } else {
            nbt.func_82580_o("position");
        }
        stack.func_196082_o().func_218657_a(KEY, (INBT)nbt);
    }

    public static boolean hasPosition(ItemStack stack) {
        return NestLocator.getPosition(stack) != null;
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (!world.field_72995_K && context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            ItemStack stack = context.func_195999_j().func_184586_b(context.func_221531_n());
            BlockState state = world.func_180495_p(context.func_195995_a());
            Block block = state.func_177230_c();
            if (block instanceof BeehiveBlock || block instanceof AdvancedBeehive) {
                NestLocator.setNestBlock(stack, (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", "bee_nest")));
            } else if (block instanceof SolitaryNest) {
                NestLocator.setNestBlock(stack, block);
            } else {
                ItemStack in = new ItemStack((IItemProvider)block.func_199767_j());
                block0: for (IRecipe recipe : world.func_199532_z().func_215366_a(IRecipeType.field_222149_a).values()) {
                    for (Ingredient s : recipe.func_192400_c()) {
                        for (ItemStack ss : s.func_193365_a()) {
                            Block foundBlock;
                            if (!ss.func_77973_b().equals(in.func_77973_b())) continue;
                            ItemStack output = recipe.func_77571_b();
                            if (!(output.func_77973_b() instanceof BlockItem) || !((foundBlock = (Block)ForgeRegistries.BLOCKS.getValue(output.func_77973_b().getRegistryName())) instanceof SolitaryNest)) continue block0;
                            NestLocator.setNestBlock(stack, foundBlock);
                            break block0;
                        }
                    }
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ProductiveBees.LOGGER.info("nest locator use");
        if (!world.field_72995_K && world instanceof ServerWorld) {
            ItemStack stack = player.func_184586_b(hand);
            if (!player.func_225608_bj_()) {
                Predicate<Block> predicate = o -> o instanceof BeehiveBlock;
                if (NestLocator.hasNest(stack)) {
                    predicate = o -> o.equals(NestLocator.getNestBlock(stack));
                }
                Pair<Double, BlockPos> nearest = this.findNearestNest((ServerWorld)world, player.func_233580_cy_(), (Integer)ProductiveBeesConfig.GENERAL.nestLocatorDistance.get(), predicate);
                ProductiveBees.LOGGER.info("nearest " + nearest);
                if (nearest != null) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("productivebees.nest_locator.found_hive", new Object[]{(double)Math.round((Double)nearest.getFirst() * 100.0) / 100.0}), false);
                    NestLocator.setPosition(stack, (BlockPos)nearest.getSecond());
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("productivebees.nest_locator.not_found_hive"), false);
                    NestLocator.setPosition(stack, null);
                }
            }
            return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, tooltip, flagIn);
        if (NestLocator.hasNest(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.information.nestlocator.configured", new Object[]{NestLocator.getNestName(stack)}).func_240699_a_(TextFormatting.GOLD));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.information.nestlocator.unconfigured").func_240699_a_(TextFormatting.GOLD));
        }
    }

    private Pair<Double, BlockPos> findNearestNest(ServerWorld world, BlockPos pos, int distance, Predicate<Block> predicate) {
        Vector3d playerPos = new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        PointOfInterestManager pointofinterestmanager = world.func_217443_B();
        Stream stream = pointofinterestmanager.func_226353_b_(poiType -> poiType == PointOfInterestType.field_226356_s_ || poiType == PointOfInterestType.field_226357_t_ || poiType == ModPointOfInterestTypes.SOLITARY_HIVE.get() || poiType == ModPointOfInterestTypes.SOLITARY_NEST.get() || poiType == ModPointOfInterestTypes.DRACONIC_NEST.get() || poiType == ModPointOfInterestTypes.BUMBLE_BEE_NEST.get() || poiType == ModPointOfInterestTypes.SUGARBAG_NEST.get(), pos, distance, PointOfInterestManager.Status.ANY);
        List nearbyNestPositions = stream.map(PointOfInterest::func_218261_f).filter(nestPos -> {
            BlockState state = world.func_180495_p(nestPos);
            return predicate.test(state.func_177230_c());
        }).sorted(Comparator.comparingDouble(vec -> vec.func_177951_i((Vector3i)pos))).collect(Collectors.toList());
        if (!nearbyNestPositions.isEmpty()) {
            BlockPos nearestPos = (BlockPos)nearbyNestPositions.iterator().next();
            double distanceToNest = playerPos.func_72438_d(new Vector3d((double)nearestPos.func_177958_n(), (double)nearestPos.func_177956_o(), (double)nearestPos.func_177952_p()));
            return new Pair((Object)distanceToNest, (Object)nearestPos);
        }
        return null;
    }
}

