/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.tileentity.UpgradeableTileEntity;
import cy.jdkdigital.productivebees.init.ModItems;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class UpgradeItem
extends Item {
    public UpgradeItem(Item.Properties properties) {
        super(properties);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, tooltip, flagIn);
        if (stack.func_77973_b().equals(ModItems.UPGRADE_FILTER.get())) {
            return;
        }
        String upgradeType = stack.func_77973_b().getRegistryName().func_110623_a();
        double value = 0.0;
        switch (upgradeType) {
            case "upgrade_productivity": {
                value = (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier.get() - 1.0;
                break;
            }
            case "upgrade_breeding": {
                value = (Double)ProductiveBeesConfig.UPGRADES.breedingChance.get();
                break;
            }
            case "upgrade_time": {
                value = (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
                break;
            }
            case "upgrade_comb_block": {
                value = (Double)ProductiveBeesConfig.UPGRADES.combBlockTimeModifier.get();
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("productivebees.information.upgrade." + upgradeType, new Object[]{(int)(value * 100.0)}).func_240699_a_(TextFormatting.GOLD));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tileEntity;
        World world = context.func_195991_k();
        if (!world.field_72995_K && context.func_195999_j() != null && context.func_195999_j().func_225608_bj_() && context.func_195996_i().func_77973_b() instanceof UpgradeItem && (tileEntity = world.func_175625_s(context.func_195995_a())) instanceof UpgradeableTileEntity && ((UpgradeableTileEntity)tileEntity).acceptsUpgrades()) {
            AtomicBoolean hasInsertedUpgrade = new AtomicBoolean(false);
            ((UpgradeableTileEntity)tileEntity).getUpgradeHandler().ifPresent(handler -> {
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    if (!handler.getStackInSlot(slot).equals(ItemStack.field_190927_a)) continue;
                    handler.insertItem(slot, context.func_195996_i().func_77946_l(), false);
                    hasInsertedUpgrade.set(true);
                    break;
                }
            });
            if (hasInsertedUpgrade.get()) {
                if (!context.func_195999_j().func_184812_l_()) {
                    context.func_195996_i().func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_195939_a(context);
    }
}

