/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.init.ModItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class WoodChip
extends Item {
    protected static final String KEY = "productivebees_woodtype";

    public WoodChip(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack getStack(Block block) {
        return WoodChip.getStack(block, 1);
    }

    public static ItemStack getStack(Block block, int count) {
        return WoodChip.getStack(block.getRegistryName().toString(), count);
    }

    public static ItemStack getStack(String blockName, int count) {
        ItemStack result = new ItemStack((IItemProvider)ModItems.WOOD_CHIP.get(), count);
        WoodChip.setBlock(result, blockName);
        return result;
    }

    public static void setBlock(ItemStack stack, String blockName) {
        stack.func_196082_o().func_74778_a(KEY, blockName);
    }

    @Nullable
    public static Block getBlock(ItemStack stack) {
        String blockType = WoodChip.getBlockType(stack);
        if (blockType != null && !blockType.isEmpty()) {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockType));
        }
        return null;
    }

    public static String getBlockType(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null ? tag.func_74779_i(KEY) : null;
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        Block block = WoodChip.getBlock(stack);
        if (block != null) {
            return new TranslationTextComponent(this.func_77658_a() + ".named", new Object[]{new TranslationTextComponent(block.func_149739_a())});
        }
        return super.func_200295_i(stack);
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            try {
                BlockTags.field_200031_h.func_230236_b_().forEach(block -> {
                    if (block.getRegistryName() != null && block.getRegistryName().func_110623_a().contains("log") && !block.getRegistryName().func_110623_a().contains("stripped")) {
                        items.add((Object)WoodChip.getStack(block));
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

