/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBeeEntity;
import cy.jdkdigital.productivebees.common.entity.bee.hive.HoarderBeeEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.handler.bee.IInhabitantStorage;
import cy.jdkdigital.productivebees.handler.bee.InhabitantStorage;
import cy.jdkdigital.productivebees.util.BeeAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public abstract class AdvancedBeehiveTileEntityAbstract
extends BeehiveTileEntity {
    public int MAX_BEES = 3;
    private LazyOptional<IInhabitantStorage> beeHandler = LazyOptional.of(this::createBeeHandler);
    private TileEntityType<?> tileEntityType;
    protected int tickCounter = 0;

    public AdvancedBeehiveTileEntityAbstract(TileEntityType<?> tileEntityType) {
        this.tileEntityType = tileEntityType;
    }

    @Nonnull
    public TileEntityType<?> func_200662_C() {
        return this.tileEntityType == null ? super.func_200662_C() : this.tileEntityType;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.tickCounter++ % 100 == 0) {
                this.tickBees();
                this.tickCounter = 0;
            }
            this.beeHandler.ifPresent(h -> {
                if (h.getInhabitants().size() > 0 && this.field_145850_b.func_201674_k().nextDouble() < 0.005) {
                    BlockPos pos = this.func_174877_v();
                    double x = (double)pos.func_177958_n() + 0.5;
                    double y = pos.func_177956_o();
                    double z = (double)pos.func_177952_p() + 0.5;
                    this.field_145850_b.func_184148_a(null, x, y, z, SoundEvents.field_226134_ai_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
            });
        }
    }

    private void tickBees() {
        this.beeHandler.ifPresent(h -> {
            Iterator<Inhabitant> inhabitantIterator = h.getInhabitants().iterator();
            while (inhabitantIterator.hasNext()) {
                Inhabitant inhabitant = inhabitantIterator.next();
                if (inhabitant.ticksInHive > inhabitant.minOccupationTicks) {
                    BeehiveTileEntity.State beeState;
                    BeehiveTileEntity.State state = beeState = inhabitant.nbt.func_74767_n("HasNectar") ? BeehiveTileEntity.State.HONEY_DELIVERED : BeehiveTileEntity.State.BEE_RELEASED;
                    if (!this.releaseBee(this.func_195044_w(), inhabitant.nbt.func_74737_b(), null, beeState)) continue;
                    inhabitantIterator.remove();
                    continue;
                }
                inhabitant.ticksInHive += this.tickCounter;
            }
        });
    }

    protected int getTimeInHive(boolean hasNectar, @Nullable BeeEntity beeEntity) {
        if (beeEntity instanceof ProductiveBeeEntity) {
            return ((ProductiveBeeEntity)beeEntity).getTimeInHive(hasNectar);
        }
        return hasNectar ? (Integer)ProductiveBeesConfig.GENERAL.timeInHive.get() : (Integer)ProductiveBeesConfig.GENERAL.timeInHive.get() / 2;
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
        super.func_70296_d();
    }

    public void func_226963_a_(@Nullable PlayerEntity player, BlockState blockState, BeehiveTileEntity.State beeState) {
        ArrayList releasedBees = Lists.newArrayList();
        this.beeHandler.ifPresent(h -> h.getInhabitants().removeIf(tag -> this.releaseBee(blockState, tag.nbt.func_74737_b(), releasedBees, beeState)));
        if (player != null) {
            for (Entity entity : releasedBees) {
                if (!(entity instanceof BeeEntity)) continue;
                BeeEntity beeEntity = (BeeEntity)entity;
                if (!(player.func_233580_cy_().func_177951_i((Vector3i)entity.func_233580_cy_()) <= 16.0)) continue;
                if (!this.func_226972_k_()) {
                    int temper;
                    if (beeEntity instanceof ProductiveBeeEntity && ((temper = ((ProductiveBeeEntity)beeEntity).getAttributeValue(BeeAttributes.TEMPER).intValue()) == 0 || temper == 1 && (double)ProductiveBees.rand.nextFloat() < 0.5)) {
                        beeEntity.func_226450_t_(400);
                        break;
                    }
                    beeEntity.func_70624_b((LivingEntity)player);
                    continue;
                }
                beeEntity.func_226450_t_(400);
            }
        }
    }

    public boolean func_226969_f_() {
        return this.getBeeList().isEmpty();
    }

    public int func_226971_j_() {
        return this.getBeeList().size();
    }

    public boolean func_226970_h_() {
        return this.func_226971_j_() == this.MAX_BEES;
    }

    public boolean acceptsBee(BeeEntity bee) {
        return true;
    }

    public void func_226962_a_(Entity entity, boolean hasNectar, int ticksInHive) {
        if (entity instanceof BeeEntity && this.acceptsBee((BeeEntity)entity)) {
            this.beeHandler.ifPresent(h -> {
                if (h.getInhabitants().size() < this.MAX_BEES) {
                    entity.func_184210_p();
                    entity.func_184226_ay();
                    CompoundNBT compoundNBT = new CompoundNBT();
                    entity.func_70039_c(compoundNBT);
                    BeeEntity beeEntity = (BeeEntity)entity;
                    h.addInhabitant(new Inhabitant(compoundNBT, ticksInHive, this.getTimeInHive(hasNectar, beeEntity), ((BeeEntity)entity).func_226424_eq_(), entity.func_200200_C_().getString()));
                    if (beeEntity.func_226425_er_() && (!this.hasSavedFlowerPos() || this.field_145850_b != null && this.field_145850_b.field_73012_v.nextBoolean())) {
                        this.field_226959_b_ = beeEntity.func_226424_eq_();
                    }
                    if (this.field_145850_b != null) {
                        BlockPos pos = this.func_174877_v();
                        this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    entity.func_70106_y();
                }
            });
        }
    }

    public void func_226961_a_(@Nonnull Entity beeEntity, boolean hasNectar) {
        this.func_226962_a_(beeEntity, hasNectar, 0);
    }

    public boolean releaseBee(BlockState blockState, CompoundNBT tag, @Nullable List<Entity> releasedBees, BeehiveTileEntity.State beeState) {
        boolean stayInside;
        if (blockState.func_177230_c().equals(Blocks.field_150350_a) || this.field_145850_b == null) {
            return false;
        }
        boolean bl = stayInside = this.field_145850_b.func_234923_W_() == World.field_234918_g_ && this.field_145850_b.func_226690_K_() && tag.func_74762_e("bee_behavior") == 0 || this.field_145850_b.func_72896_J() && (beeState != BeehiveTileEntity.State.EMERGENCY || tag.func_74762_e("bee_weather_tolerance") == 0);
        if (!this.field_145850_b.func_226690_K_() && !this.field_145850_b.func_72896_J() && stayInside) {
            ProductiveBees.LOGGER.debug("Bee is staying inside during the day: " + tag);
        }
        if (!stayInside & this.field_145850_b instanceof ServerWorld) {
            boolean isPositionBlocked;
            BlockPos pos = this.func_174877_v();
            tag.func_82580_o("Passengers");
            tag.func_82580_o("Leash");
            tag.func_82580_o("UUID");
            Direction direction = blockState.func_235901_b_((Property)BlockStateProperties.field_208155_H) ? (Direction)blockState.func_177229_b((Property)BlockStateProperties.field_208155_H) : (Direction)blockState.func_177229_b((Property)BeehiveBlock.field_226872_b_);
            BlockPos offset = pos.func_177972_a(direction);
            boolean bl2 = isPositionBlocked = !this.field_145850_b.func_180495_p(offset).func_196952_d((IBlockReader)this.field_145850_b, offset).func_197766_b();
            if (!isPositionBlocked || beeState == BeehiveTileEntity.State.EMERGENCY) {
                boolean spawned = false;
                BeeEntity beeEntity = (BeeEntity)EntityType.func_220335_a((CompoundNBT)tag, (World)this.field_145850_b, spawnedEntity -> spawnedEntity);
                if (beeEntity != null) {
                    AtomicBoolean hasOffloaded = new AtomicBoolean(true);
                    if (beeEntity instanceof HoarderBeeEntity && ((HoarderBeeEntity)beeEntity).holdsItem()) {
                        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                            ((HoarderBeeEntity)beeEntity).emptyIntoInventory((InventoryHandlerHelper.ItemHandler)((Object)inv));
                            if (((HoarderBeeEntity)beeEntity).isInventoryEmpty()) {
                                hasOffloaded.set(false);
                            }
                        });
                    }
                    if ((spawned = AdvancedBeehiveTileEntityAbstract.spawnBeeInWorldAtPosition((ServerWorld)this.field_145850_b, (Entity)beeEntity, pos, direction, null)) && hasOffloaded.get()) {
                        if (this.hasSavedFlowerPos() && !beeEntity.func_226425_er_() && (beeEntity.func_70022_Q().contains("dye_bee") || this.field_145850_b.field_73012_v.nextFloat() <= 0.9f)) {
                            beeEntity.func_226431_g_(this.field_226959_b_);
                        }
                        this.beeReleasePostAction(beeEntity, blockState, beeState);
                        if (releasedBees != null) {
                            releasedBees.add((Entity)beeEntity);
                        }
                    }
                }
                return spawned;
            }
            return false;
        }
        return false;
    }

    protected void beeReleasePostAction(BeeEntity beeEntity, BlockState state, BeehiveTileEntity.State beeState) {
        int maxHoneyLevel;
        int honeyLevel;
        beeEntity.func_226426_eu_();
        beeEntity.func_70691_i(2.0f);
        AdvancedBeehiveTileEntityAbstract.applyHiveTime(this.getTimeInHive(beeState == BeehiveTileEntity.State.HONEY_DELIVERED, beeEntity), beeEntity);
        beeEntity.func_226413_eG_();
        if (beeEntity instanceof ProductiveBeeEntity && ((ProductiveBeeEntity)beeEntity).hasConverted()) {
            return;
        }
        if (beeState == BeehiveTileEntity.State.HONEY_DELIVERED && state.func_235901_b_((Property)BeehiveBlock.field_226873_c_) && (honeyLevel = AdvancedBeehiveTileEntityAbstract.func_226964_a_((BlockState)state)) < (maxHoneyLevel = AdvancedBeehiveTileEntityAbstract.getMaxHoneyLevel(state))) {
            int levelIncrease;
            int n = levelIncrease = this.field_145850_b.field_73012_v.nextInt(100) == 0 ? 2 : 1;
            if (honeyLevel + levelIncrease > maxHoneyLevel) {
                --levelIncrease;
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BeehiveBlock.field_226873_c_, (Comparable)Integer.valueOf(honeyLevel + levelIncrease)));
        }
    }

    private static void applyHiveTime(int ticksInHive, BeeEntity beeEntity) {
        int i = beeEntity.func_70874_b();
        if (i < 0) {
            beeEntity.func_70873_a(Math.min(0, i + ticksInHive));
        } else if (i > 0) {
            beeEntity.func_70873_a(Math.max(0, i - ticksInHive));
        }
        beeEntity.func_226426_eu_();
    }

    private boolean hasSavedFlowerPos() {
        return this.field_226959_b_ != null;
    }

    public static int getMaxHoneyLevel(BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof AdvancedBeehiveAbstract ? ((AdvancedBeehiveAbstract)block).getMaxHoneyLevel() : 5;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT tag) {
        super.func_230337_a_(blockState, tag);
        CompoundNBT beeTag = tag.func_74775_l("Bees");
        this.beeHandler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)beeTag));
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.beeHandler.ifPresent(h -> {
            tag.func_82580_o("Bees");
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("Bees", (INBT)compound);
        });
        return tag;
    }

    @Nonnull
    public ListNBT getBeeListAsNBTList() {
        return this.getCapability(CapabilityBee.BEE).map(IInhabitantStorage::getInhabitantListAsListNBT).orElse(new ListNBT());
    }

    public static boolean spawnBeeInWorldAtPosition(ServerWorld world, Entity entity, BlockPos pos, Direction direction, @Nullable Integer age) {
        BlockPos offset = pos.func_177972_a(direction);
        boolean isPositionBlocked = !world.func_180495_p(offset).func_196952_d((IBlockReader)world, offset).func_197766_b();
        float width = entity.func_213311_cf();
        double spawnOffset = isPositionBlocked ? 0.0 : 0.55 + (double)(width / 2.0f);
        double x = (double)pos.func_177958_n() + 0.5 + spawnOffset * (double)direction.func_82601_c();
        double y = (double)pos.func_177956_o() + 0.5 - (double)(entity.func_213302_cg() / 2.0f);
        double z = (double)pos.func_177952_p() + 0.5 + spawnOffset * (double)direction.func_82599_e();
        entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
        if (age != null && entity instanceof BeeEntity) {
            ((BeeEntity)entity).func_70873_a(age.intValue());
        }
        if (entity.func_200600_R().func_220341_a((ITag)EntityTypeTags.field_226155_c_)) {
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226132_ag_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            CompoundNBT tag = new CompoundNBT();
            if (entity instanceof ConfigurableBeeEntity) {
                tag.func_74778_a("type", ((ConfigurableBeeEntity)entity).getBeeType());
            }
            return world.func_217376_c(entity);
        }
        return false;
    }

    public List<Inhabitant> getBeeList() {
        return this.getCapability(CapabilityBee.BEE).map(IInhabitantStorage::getInhabitants).orElse(new ArrayList());
    }

    private IInhabitantStorage createBeeHandler() {
        return new InhabitantStorage(){

            @Override
            public void onContentsChanged() {
                super.onContentsChanged();
                AdvancedBeehiveTileEntityAbstract.this.func_70296_d();
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityBee.BEE) {
            return this.beeHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(null, pkt.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.deserializeNBT(tag);
    }

    public static class Inhabitant {
        public final CompoundNBT nbt;
        public int ticksInHive;
        public final int minOccupationTicks;
        public final BlockPos flowerPos;
        public final String localizedName;

        public Inhabitant(CompoundNBT nbt, int ticksInHive, int minOccupationTicks, BlockPos flowerPos, String localizedName) {
            nbt.func_82580_o("UUID");
            this.nbt = nbt;
            this.ticksInHive = ticksInHive;
            this.minOccupationTicks = minOccupationTicks;
            this.flowerPos = flowerPos;
            this.localizedName = localizedName;
        }

        public String toString() {
            return "Bee{ticksInHive=" + this.ticksInHive + "flowerPos=" + this.flowerPos + ", minOccupationTicks=" + this.minOccupationTicks + ", nbt=" + this.nbt + '}';
        }
    }
}

