/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.block.Feeder;
import cy.jdkdigital.productivebees.common.tileentity.CapabilityTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.container.FeederContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class FeederTileEntity
extends CapabilityTileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private int tickCounter = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(3, this){

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            return true;
        }
    });

    public FeederTileEntity() {
        super((TileEntityType)ModTileEntityTypes.FEEDER.get());
    }

    public Block getRandomBlockFromInventory(ITag<Block> tag) {
        return this.inventoryHandler.map(h -> {
            ArrayList<Block> possibleBlocks = new ArrayList<Block>();
            for (int slot = 0; slot < h.getSlots(); ++slot) {
                Block itemBlock;
                Item slotItem = h.getStackInSlot(slot).func_77973_b();
                if (!(slotItem instanceof BlockItem) || !(itemBlock = ((BlockItem)slotItem).func_179223_d()).func_203417_a(tag)) continue;
                possibleBlocks.add(itemBlock);
            }
            return (Block)possibleBlocks.get(ProductiveBees.rand.nextInt(possibleBlocks.size()));
        }).orElse(Blocks.field_150350_a);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModBlocks.FEEDER.get()).func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new FeederContainer(windowId, playerInventory, this);
    }

    public void func_73660_a() {
        BlockState state;
        if (this.field_145850_b instanceof ServerWorld && ++this.tickCounter % 164 == 0 && ((Boolean)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((Property)Feeder.HONEYLOGGED)).booleanValue()) {
            List entities = this.field_145850_b.func_217357_a(BeeEntity.class, new AxisAlignedBB(this.field_174879_c));
            for (Entity entity : entities) {
                if (!(entity instanceof BeeEntity)) continue;
                ((BeeEntity)entity).func_195064_c(new EffectInstance(Effects.field_76428_l, 80, 0, false, true));
            }
        }
    }
}

