/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.HoneyGenerator;
import cy.jdkdigital.productivebees.common.tileentity.FluidTankTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.tileentity.UpgradeableTileEntity;
import cy.jdkdigital.productivebees.container.HoneyGeneratorContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class HoneyGeneratorTileEntity
extends FluidTankTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
UpgradeableTileEntity {
    protected int tickCounter = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(2, this){

        @Override
        public boolean isBottleItem(Item item) {
            return item.equals(Items.field_226638_pX_) || item.func_206844_a(ModTags.HONEY_BUCKETS) || item.equals(Items.field_226639_pY_);
        }

        @Override
        public boolean isInputSlot(int slot) {
            return slot == 0;
        }
    });
    protected LazyOptional<IFluidHandler> fluidInventory = LazyOptional.of(() -> new InventoryHandlerHelper.FluidHandler(10000){

        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().func_207187_a((Fluid)ModFluids.HONEY.get());
        }

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (this.fluid.getAmount() > 0) {
                HoneyGeneratorTileEntity.this.setFilled(true);
            } else {
                HoneyGeneratorTileEntity.this.setFilled(false);
            }
            HoneyGeneratorTileEntity.this.func_70296_d();
        }
    });
    private List<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));
    protected LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(100000));

    private void setFilled(boolean filled) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)HoneyGenerator.FULL, (Comparable)Boolean.valueOf(filled)));
        }
    }

    private void setOn(boolean filled) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)HoneyGenerator.ON, (Comparable)Boolean.valueOf(filled)));
        }
    }

    public HoneyGeneratorTileEntity() {
        super((TileEntityType)ModTileEntityTypes.HONEY_GENERATOR.get());
    }

    @Override
    public void func_73660_a() {
        int tickRate = 10;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (++this.tickCounter % tickRate == 0) {
                int inputPowerAmount = (Integer)ProductiveBeesConfig.GENERAL.generatorPowerGen.get() * tickRate;
                int fluidConsumeAmount = (Integer)ProductiveBeesConfig.GENERAL.generatorHoneyUse.get() * tickRate;
                this.fluidInventory.ifPresent(fluidHandler -> this.energyHandler.ifPresent(handler -> {
                    if (fluidHandler.getFluidInTank(0).getAmount() >= fluidConsumeAmount && handler.receiveEnergy(inputPowerAmount, true) > 0) {
                        handler.receiveEnergy(inputPowerAmount, false);
                        fluidHandler.drain(fluidConsumeAmount, IFluidHandler.FluidAction.EXECUTE);
                        this.setOn(true);
                    } else {
                        this.setOn(false);
                    }
                }));
            }
            this.sendOutPower(tickRate);
        }
        super.func_73660_a();
    }

    private void sendOutPower(int modifier) {
        if (this.field_145850_b != null) {
            this.energyHandler.ifPresent(energyHandler -> {
                AtomicInteger capacity = new AtomicInteger(energyHandler.getEnergyStored());
                if (capacity.get() > 0) {
                    AtomicBoolean dirty = new AtomicBoolean(false);
                    for (IEnergyStorage handler : this.recipients) {
                        boolean doContinue = true;
                        if (handler.canReceive()) {
                            int received = handler.receiveEnergy(Math.min(capacity.get(), 100 * modifier), false);
                            capacity.addAndGet(-received);
                            energyHandler.extractEnergy(received, false);
                            dirty.set(true);
                            boolean bl = doContinue = capacity.get() > 0;
                        }
                        if (doContinue) continue;
                        break;
                    }
                    if (dirty.get()) {
                        this.func_70296_d();
                    }
                }
            });
        }
    }

    @Override
    public void tickFluidTank() {
        this.fluidInventory.ifPresent(fluidHandler -> this.inventoryHandler.ifPresent(invHandler -> {
            int fluidSpace = this.fluidInventory.map(h -> h.getTankCapacity(0) - h.getFluidInTank(0).getAmount()).orElse(0);
            if (!invHandler.getStackInSlot(0).func_190926_b()) {
                ItemStack invItem = invHandler.getStackInSlot(0);
                ItemStack outputInvItem = invHandler.getStackInSlot(1);
                ItemStack outputItem = ItemStack.field_190927_a;
                LazyOptional itemFluidHandler = invItem.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
                boolean isHoneyBottle = invItem.func_77973_b().equals(Items.field_226638_pX_);
                boolean isHoneyBlock = invItem.func_77973_b().equals(Items.field_226639_pY_);
                boolean isHoneyBucket = invItem.func_77973_b().func_206844_a(ModTags.HONEY_BUCKETS);
                int addAmount = 0;
                if (isHoneyBottle) {
                    addAmount = 250;
                    outputItem = new ItemStack((IItemProvider)Items.field_151069_bo);
                } else if (isHoneyBlock) {
                    addAmount = 1000;
                } else if (isHoneyBucket) {
                    addAmount = 1000;
                    outputItem = new ItemStack((IItemProvider)Items.field_151133_ar);
                } else if (itemFluidHandler.isPresent()) {
                    addAmount = fluidSpace;
                }
                if (!(outputItem.equals(ItemStack.field_190927_a) || outputInvItem.func_190926_b() || outputInvItem.func_77973_b().equals(outputItem.func_77973_b()) && outputInvItem.func_77976_d() != outputInvItem.func_190916_E())) {
                    return;
                }
                if (itemFluidHandler.isPresent() && itemFluidHandler.map(h -> h.getFluidInTank(0).isEmpty()).orElse(false).booleanValue()) {
                    if (outputInvItem.func_190926_b() && !invHandler.insertItem(1, invItem, false).func_190926_b()) {
                        invHandler.setStackInSlot(0, ItemStack.field_190927_a);
                    }
                    return;
                }
                if (addAmount > 0 && addAmount <= fluidSpace) {
                    int fillAmount = fluidHandler.fill(new FluidStack((Fluid)ModFluids.HONEY.get(), addAmount), IFluidHandler.FluidAction.EXECUTE);
                    if (itemFluidHandler.isPresent()) {
                        FluidUtil.tryEmptyContainer((ItemStack)invItem, (IFluidHandler)fluidHandler, (int)fillAmount, null, (boolean)true);
                    } else {
                        invItem.func_190918_g(1);
                        if (!outputItem.equals(ItemStack.field_190927_a)) {
                            if (outputInvItem.func_190926_b()) {
                                invHandler.setStackInSlot(1, outputItem);
                            } else {
                                outputInvItem.func_190917_f(1);
                            }
                        }
                    }
                }
            }
        }));
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.refreshConnectedTileEntityCache();
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidInventory.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModBlocks.HONEY_GENERATOR.get()).func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new HoneyGeneratorContainer(windowId, playerInventory, this);
    }

    public void refreshConnectedTileEntityCache() {
        if (this.field_145850_b instanceof ServerWorld) {
            Direction[] directions;
            ArrayList<IEnergyStorage> recipients = new ArrayList<IEnergyStorage>();
            for (Direction direction : directions = Direction.values()) {
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
                if (te == null) continue;
                te.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d()).ifPresent(recipients::add);
            }
            this.recipients = recipients;
        }
    }
}

