/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.tileentity.CapabilityTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.common.tileentity.UpgradeableTileEntity;
import cy.jdkdigital.productivebees.container.IncubatorContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import cy.jdkdigital.productivebees.util.BeeCreator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class IncubatorTileEntity
extends CapabilityTileEntity
implements INamedContainerProvider,
ITickableTileEntity,
UpgradeableTileEntity {
    public int recipeProgress = 0;
    public boolean isRunning = false;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(3, this){

        @Override
        public boolean isInputSlotItem(int slot, Item item) {
            return slot == 0 && item instanceof BeeCage || slot == 0 && item.func_206844_a(ModTags.EGGS) || slot == 1 && item instanceof HoneyTreat;
        }
    });
    protected LazyOptional<IItemHandlerModifiable> upgradeHandler = LazyOptional.of(() -> new InventoryHandlerHelper.UpgradeHandler(4, this));
    protected LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(10000));

    private void setRunning(boolean running) {
        this.isRunning = running;
    }

    public IncubatorTileEntity() {
        super((TileEntityType)ModTileEntityTypes.INCUBATOR.get());
    }

    public int getProcessingTime() {
        return (int)((double)((Integer)ProductiveBeesConfig.GENERAL.incubatorProcessingTime.get()).intValue() * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        double timeUpgradeModifier = 1.0 - (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(0.0, timeUpgradeModifier);
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.isRunning && this.field_145850_b instanceof ServerWorld) {
                this.energyHandler.ifPresent(handler -> handler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get()).intValue() * this.getEnergyConsumptionModifier()), false));
            }
            this.inventoryHandler.ifPresent(invHandler -> {
                if (!invHandler.getStackInSlot(0).func_190926_b()) {
                    if (this.isRunning || this.canProcessInput((IItemHandlerModifiable)invHandler)) {
                        this.setRunning(true);
                        int totalTime = this.getProcessingTime();
                        if (++this.recipeProgress >= totalTime) {
                            this.completeIncubation((IItemHandlerModifiable)invHandler);
                            this.recipeProgress = 0;
                            this.func_70296_d();
                        }
                    }
                } else {
                    this.recipeProgress = 0;
                    this.setRunning(false);
                }
            });
        }
    }

    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(1.0, timeUpgradeModifier);
    }

    private boolean canProcessInput(IItemHandlerModifiable invHandler) {
        int energy = this.energyHandler.map(IEnergyStorage::getEnergyStored).orElse(0);
        ItemStack inItem = invHandler.getStackInSlot(0);
        ItemStack treatItem = invHandler.getStackInSlot(1);
        boolean eggProcessing = inItem.func_77973_b().func_206844_a(ModTags.EGGS);
        boolean cageProcessing = inItem.func_77973_b() instanceof BeeCage && BeeCage.isFilled(inItem);
        return energy > (Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get() && (eggProcessing || cageProcessing) && invHandler.getStackInSlot(2).func_190926_b() && treatItem.func_77973_b().equals(ModItems.HONEY_TREAT.get()) && (cageProcessing && treatItem.func_190916_E() >= (Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get() || eggProcessing && !treatItem.func_190926_b() && HoneyTreat.hasBeeType(treatItem));
    }

    private void completeIncubation(IItemHandlerModifiable invHandler) {
        if (this.canProcessInput(invHandler)) {
            ItemStack inItem = invHandler.getStackInSlot(0);
            boolean eggProcessing = inItem.func_77973_b().func_206844_a(ModTags.EGGS);
            boolean cageProcessing = inItem.func_77973_b() instanceof BeeCage;
            if (this.canProcessInput(invHandler)) {
                if (cageProcessing) {
                    CompoundNBT nbt = inItem.func_77978_p();
                    if (nbt != null && nbt.func_74764_b("Age")) {
                        nbt.func_74768_a("Age", 0);
                    }
                    invHandler.setStackInSlot(2, inItem);
                    invHandler.getStackInSlot(1).func_190918_g(((Integer)ProductiveBeesConfig.GENERAL.incubatorTreatUse.get()).intValue());
                    invHandler.setStackInSlot(0, ItemStack.field_190927_a);
                } else if (eggProcessing) {
                    ItemStack treatItem = invHandler.getStackInSlot(1);
                    ListNBT genes = HoneyTreat.getGenes(treatItem);
                    for (INBT inbt : genes) {
                        ItemStack egg;
                        ItemStack insertedGene = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)inbt));
                        String beeName = Gene.getAttributeName(insertedGene);
                        if (beeName.isEmpty()) continue;
                        int purity = Gene.getPurity(insertedGene);
                        if (((CompoundNBT)inbt).func_74764_b("purity")) {
                            purity = ((CompoundNBT)inbt).func_74762_e("purity");
                        }
                        if (ProductiveBees.rand.nextInt(100) > purity || !((egg = BeeCreator.getSpawnEgg(beeName)).func_77973_b() instanceof SpawnEggItem)) continue;
                        invHandler.setStackInSlot(2, egg);
                    }
                    inItem.func_190918_g(1);
                    invHandler.getStackInSlot(1).func_190918_g(1);
                }
            }
        }
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.setRunning(false);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.recipeProgress = tag.func_74762_e("RecipeProgress");
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("RecipeProgress", this.recipeProgress);
        return tag;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModBlocks.INCUBATOR.get()).func_149739_a());
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new IncubatorContainer(windowId, playerInventory, this);
    }
}

