/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class JarTileEntity
extends TileEntity {
    @Nullable
    private Entity cachedEntity;
    public int tickCount = 0;
    private LazyOptional<IItemHandlerModifiable> inventoryHandler = LazyOptional.of(() -> new InventoryHandlerHelper.ItemHandler(1, this){

        @Override
        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b().getItem() instanceof BeeCage && BeeCage.isFilled(stack);
        }

        @Override
        public boolean isBottleItem(Item item) {
            return item instanceof BeeCage;
        }

        @Override
        public boolean isInputSlot(int slot) {
            return false;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (this.tileEntity.func_145830_o()) {
                this.tileEntity.func_145831_w().func_184138_a(this.tileEntity.func_174877_v(), this.tileEntity.func_195044_w(), this.tileEntity.func_195044_w(), 3);
            }
        }
    });

    public JarTileEntity() {
        super((TileEntityType)ModTileEntityTypes.JAR.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(null, pkt.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.deserializeNBT(tag);
    }

    @Nullable
    public Entity getCachedEntity(ItemStack cage) {
        if (this.cachedEntity == null) {
            this.cachedEntity = BeeCage.getEntityFromStack(cage, this.func_145831_w(), false);
        }
        return this.cachedEntity;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        CompoundNBT invTag = tag.func_74775_l("inv");
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> ((INBTSerializable)inv).deserializeNBT((INBT)invTag));
        this.tickCount = ProductiveBees.rand.nextInt(360);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT finalTag = tag = super.func_189515_b(tag);
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)inv).serializeNBT();
            finalTag.func_218657_a("inv", (INBT)compound);
        });
        return tag;
    }
}

