/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.Centrifuge;
import cy.jdkdigital.productivebees.common.tileentity.CentrifugeTileEntity;
import cy.jdkdigital.productivebees.container.PoweredCentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTileEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class PoweredCentrifugeTileEntity
extends CentrifugeTileEntity {
    public LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(10000));

    public PoweredCentrifugeTileEntity() {
        super((TileEntityType)ModTileEntityTypes.POWERED_CENTRIFUGE.get());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (((Boolean)this.func_195044_w().func_177229_b((Property)Centrifuge.RUNNING)).booleanValue() && this.field_145850_b instanceof ServerWorld) {
            this.energyHandler.ifPresent(handler -> handler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get()).intValue() * this.getEnergyConsumptionModifier()), false));
        }
    }

    protected double getEnergyConsumptionModifier() {
        double combBlockUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_COMB_BLOCK.get()) * (Double)ProductiveBeesConfig.UPGRADES.combBlockTimeModifier.get();
        double timeUpgradeModifier = (double)this.getUpgradeCount((Item)ModItems.UPGRADE_TIME.get()) * (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get();
        return Math.max(1.0, timeUpgradeModifier + combBlockUpgradeModifier);
    }

    @Override
    public int getProcessingTime() {
        return (int)((double)((Integer)ProductiveBeesConfig.GENERAL.centrifugePoweredProcessingTime.get()).intValue() * this.getProcessingTimeModifier());
    }

    @Override
    protected boolean canOperate() {
        int energy = this.energyHandler.map(IEnergyStorage::getEnergyStored).orElse(0);
        return energy >= (Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)ModBlocks.POWERED_CENTRIFUGE.get()).func_149739_a());
    }

    @Override
    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new PoweredCentrifugeContainer(windowId, playerInventory, this);
    }
}

