/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface UpgradeableTileEntity {
    public LazyOptional<IItemHandlerModifiable> getUpgradeHandler();

    default public boolean acceptsUpgrades() {
        return true;
    }

    default public int getUpgradeCount(Item item) {
        AtomicInteger numberOfUpgrades = new AtomicInteger();
        this.getUpgradeHandler().ifPresent(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (!stack.func_77973_b().equals(item)) continue;
                numberOfUpgrades.getAndIncrement();
            }
        });
        return numberOfUpgrades.get();
    }

    default public List<ItemStack> getInstalledUpgrades(@Nullable Item upgradeItem) {
        ArrayList<ItemStack> upgrades = new ArrayList<ItemStack>();
        this.getUpgradeHandler().ifPresent(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                if (upgradeItem != null && !handler.getStackInSlot(slot).func_77973_b().equals(upgradeItem)) continue;
                upgrades.add(handler.getStackInSlot(slot));
            }
        });
        return upgrades;
    }
}

