/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Bottler;
import cy.jdkdigital.productivebees.common.tileentity.BottlerTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.container.ManualSlotItemHandler;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class BottlerContainer
extends AbstractContainer {
    public final BottlerTileEntity tileEntity;
    private final IWorldPosCallable canInteractWithCallable;

    public BottlerContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, BottlerContainer.getTileEntity(playerInventory, data));
    }

    public BottlerContainer(int windowId, PlayerInventory playerInventory, final BottlerTileEntity tileEntity) {
        super((ContainerType)ModContainerTypes.BOTTLER.get(), windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.func_216961_a(new IIntArray(){

            public int func_221476_a(int i) {
                return i == 0 ? tileEntity.fluidId : tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(fluidHandler -> fluidHandler.getFluidInTank(0).getAmount()).orElse(0);
            }

            public void func_221477_a(int i, int value) {
                switch (i) {
                    case 0: {
                        tileEntity.fluidId = value;
                    }
                    case 1: {
                        tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                            FluidStack fluid = fluidHandler.getFluidInTank(0);
                            if (fluid.isEmpty()) {
                                fluidHandler.fill(new FluidStack((Fluid)Registry.field_212619_h.func_148745_a(tileEntity2.fluidId), value), IFluidHandler.FluidAction.EXECUTE);
                            } else {
                                fluid.setAmount(value);
                            }
                        });
                    }
                }
            }

            public int func_221478_a() {
                return 2;
            }
        });
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            this.func_75146_a((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 0, 152, 17));
            this.func_75146_a((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 11, 152, 53));
        });
        this.layoutPlayerInventorySlots(playerInventory, 0, 8, 84);
    }

    private static BottlerTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof BottlerTileEntity) {
            return (BottlerTileEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return (Boolean)this.canInteractWithCallable.func_221485_a((world, pos) -> world.func_180495_p(pos).func_177230_c() instanceof Bottler && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected TileEntity getTileEntity() {
        return this.tileEntity;
    }
}

