/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Incubator;
import cy.jdkdigital.productivebees.common.tileentity.IncubatorTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.InventoryHandlerHelper;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.container.ManualSlotItemHandler;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class IncubatorContainer
extends AbstractContainer {
    public final IncubatorTileEntity tileEntity;
    public final IWorldPosCallable canInteractWithCallable;

    public IncubatorContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, IncubatorContainer.getTileEntity(playerInventory, data));
    }

    public IncubatorContainer(int windowId, PlayerInventory playerInventory, IncubatorTileEntity tileEntity) {
        this((ContainerType)ModContainerTypes.INCUBATOR.get(), windowId, playerInventory, tileEntity);
    }

    public IncubatorContainer(@Nullable ContainerType<?> type, int windowId, PlayerInventory playerInventory, final IncubatorTileEntity tileEntity) {
        super(type, windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = IWorldPosCallable.func_221488_a((World)tileEntity.func_145831_w(), (BlockPos)tileEntity.func_174877_v());
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return tileEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
            }

            public void func_221494_a(int value) {
                tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
                    if (handler.getEnergyStored() > 0) {
                        handler.extractEnergy(handler.getEnergyStored(), false);
                    }
                    if (value > 0) {
                        handler.receiveEnergy(value, false);
                    }
                });
            }
        });
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return tileEntity.recipeProgress;
            }

            public void func_221494_a(int value) {
                tileEntity.recipeProgress = value;
            }
        });
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
            this.func_75146_a((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 0, 39, 35));
            this.func_75146_a((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 1, 67, 53));
            this.func_75146_a((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.ItemHandler)((Object)inv), 2, 95, 35));
        });
        this.tileEntity.getUpgradeHandler().ifPresent(upgradeHandler -> this.addSlotBox((IItemHandler)upgradeHandler, 0, 165, 8, 1, 18, 4, 18));
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, 84);
    }

    private static IncubatorTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof IncubatorTileEntity) {
            return (IncubatorTileEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return (Boolean)this.canInteractWithCallable.func_221485_a((world, pos) -> world.func_180495_p(pos).func_177230_c() instanceof Incubator && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected TileEntity getTileEntity() {
        return this.tileEntity;
    }
}

