/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.PoweredCentrifuge;
import cy.jdkdigital.productivebees.common.tileentity.PoweredCentrifugeTileEntity;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IntReferenceHolder;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class PoweredCentrifugeContainer
extends CentrifugeContainer {
    public final PoweredCentrifugeTileEntity tileEntity;

    public PoweredCentrifugeContainer(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory, PoweredCentrifugeContainer.getTileEntity(playerInventory, data));
    }

    public PoweredCentrifugeContainer(int windowId, PlayerInventory playerInventory, final PoweredCentrifugeTileEntity tileEntity) {
        super((ContainerType)ModContainerTypes.POWERED_CENTRIFUGE.get(), windowId, playerInventory, tileEntity);
        this.tileEntity = tileEntity;
        this.func_216958_a(new IntReferenceHolder(){

            public int func_221495_b() {
                return tileEntity.getCapability(CapabilityEnergy.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
            }

            public void func_221494_a(int value) {
                tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
                    if (handler.getEnergyStored() > 0) {
                        handler.extractEnergy(handler.getEnergyStored(), false);
                    }
                    if (value > 0) {
                        handler.receiveEnergy(value, false);
                    }
                });
            }
        });
    }

    private static PoweredCentrifugeTileEntity getTileEntity(PlayerInventory playerInventory, PacketBuffer data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        TileEntity tileAtPos = playerInventory.field_70458_d.field_70170_p.func_175625_s(data.func_179259_c());
        if (tileAtPos instanceof PoweredCentrifugeTileEntity) {
            return (PoweredCentrifugeTileEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    @Override
    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return (Boolean)this.canInteractWithCallable.func_221485_a((world, pos) -> world.func_180495_p(pos).func_177230_c() instanceof PoweredCentrifuge && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected TileEntity getTileEntity() {
        return this.tileEntity;
    }
}

