/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.client.render.ingredient.BeeRenderer;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.common.tileentity.DragonEggHiveTileEntity;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.handler.bee.CapabilityBee;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.integrations.jei.ingredients.BeeIngredientFactory;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;

public class AdvancedBeehiveScreen
extends ContainerScreen<AdvancedBeehiveContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive.png");
    private static final ResourceLocation GUI_TEXTURE_EXPANDED = new ResourceLocation("productivebees", "textures/gui/container/advanced_beehive_expanded.png");

    public AdvancedBeehiveScreen(AdvancedBeehiveContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        boolean expanded = ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, expanded ? -5.0f : 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_200200_C_(), expanded ? -5.0f : 8.0f, (float)(this.getYSize() - 96 + 2), 0x404040);
        assert (this.field_230706_i_ != null);
        HashMap<Integer, List<Integer>> positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.getCapability(CapabilityBee.BEE).ifPresent(inhabitantHandler -> {
            int j = 0;
            for (AdvancedBeehiveTileEntityAbstract.Inhabitant inhabitant : inhabitantHandler.getInhabitants()) {
                BeeIngredient beeIngredient;
                CompoundNBT nbt = inhabitant.nbt;
                BeeEntity bee = null;
                String type = inhabitant.nbt.func_74779_i("type");
                if (type.isEmpty()) {
                    type = inhabitant.nbt.func_74779_i("id");
                }
                if ((beeIngredient = BeeIngredientFactory.getIngredient(type).get()) != null) {
                    bee = beeIngredient.getCachedEntity((World)this.field_230706_i_.field_71441_e);
                }
                if (bee == null || bee.func_70022_Q() == null) continue;
                if (bee instanceof ConfigurableBeeEntity && nbt.func_74764_b("type")) {
                    ((ConfigurableBeeEntity)bee).setBeeType(nbt.func_74779_i("type"));
                }
                if (positions.containsKey(j) && this.func_195359_a((Integer)((List)positions.get(j)).get(0) - (expanded ? 13 : 0), (Integer)((List)positions.get(j)).get(1), 16, 16, mouseX, mouseY)) {
                    CompoundNBT tag = inhabitant.nbt.func_74737_b();
                    ArrayList<IReorderingProcessor> tooltipList = new ArrayList<IReorderingProcessor>();
                    tooltipList.add(bee.func_200200_C_().func_241878_f());
                    if (Screen.func_231173_s_()) {
                        String modId = new ResourceLocation(bee.func_70022_Q()).func_110624_b();
                        if (modId.equals("productivebees")) {
                            tag.func_74757_a("isProductiveBee", true);
                        }
                        List<ITextComponent> list = BeeHelper.populateBeeInfoFromTag(tag, null);
                        for (ITextComponent textComponent : list) {
                            tooltipList.add(textComponent.func_241878_f());
                        }
                        if (!tag.func_74767_n("isProductiveBee")) {
                            String modName = ModList.get().getModObjectById(modId).get().getClass().getSimpleName();
                            if (modId.equals("minecraft")) {
                                modName = "Minecraft";
                            }
                            tooltipList.add(new StringTextComponent(modName).func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.BLUE).func_241878_f());
                        }
                    } else {
                        tooltipList.add(new TranslationTextComponent("productivebees.information.hold_shift").func_240699_a_(TextFormatting.WHITE).func_241878_f());
                    }
                    this.func_238654_b_(matrixStack, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
                }
                ++j;
            }
        });
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean expanded = ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
        int honeyLevel = (Integer)((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.func_195044_w().func_177229_b((Property)BeehiveBlock.field_226873_c_);
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.field_71446_o.func_110577_a(expanded ? GUI_TEXTURE_EXPANDED : GUI_TEXTURE);
        this.func_238474_b_(matrixStack, this.getGuiLeft() - (expanded ? 13 : 0), this.getGuiTop(), 0, 0, this.getXSize() + (expanded ? 26 : 0), this.getYSize());
        HashMap<Integer, List<Integer>> positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        int xOffset = ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity instanceof DragonEggHiveTileEntity ? 13 : 0;
        this.func_238474_b_(matrixStack, this.getGuiLeft() + 87 - (expanded ? 13 : 0), this.getGuiTop() + 37, 202 + xOffset, honeyLevel * 13, 13, 13);
        ((AdvancedBeehiveContainer)this.field_147002_h).tileEntity.getCapability(CapabilityBee.BEE).ifPresent(inhabitantHandler -> {
            int i = 0;
            for (AdvancedBeehiveTileEntityAbstract.Inhabitant inhabitant : inhabitantHandler.getInhabitants()) {
                if (this.field_230706_i_.field_71439_g != null && positions.containsKey(i)) {
                    BeeIngredient beeIngredient;
                    String type = inhabitant.nbt.func_74779_i("type");
                    if (type.isEmpty()) {
                        type = inhabitant.nbt.func_74779_i("id");
                    }
                    if ((beeIngredient = BeeIngredientFactory.getIngredient(type).get()) != null) {
                        BeeRenderer.render(matrixStack, this.getGuiLeft() + (Integer)((List)positions.get(i)).get(0) - (expanded ? 13 : 0), this.getGuiTop() + (Integer)((List)positions.get(i)).get(1), beeIngredient, this.field_230706_i_);
                    }
                }
                ++i;
            }
        });
    }
}

