/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.common.tileentity.PoweredCentrifugeTileEntity;
import cy.jdkdigital.productivebees.container.CentrifugeContainer;
import cy.jdkdigital.productivebees.container.gui.FluidContainerUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class CentrifugeScreen
extends ContainerScreen<CentrifugeContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("productivebees", "textures/gui/container/centrifuge.png");
    private static final ResourceLocation GUI_TEXTURE_POWERED = new ResourceLocation("productivebees", "textures/gui/container/powered_centrifuge.png");

    public CentrifugeScreen(CentrifugeContainer container, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)container, inv, titleIn);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.field_230712_o_.func_243248_b(matrixStack, this.field_230704_d_, -5.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, this.field_213127_e.func_200200_C_(), -5.0f, (float)(this.getYSize() - 96 + 2), 0x404040);
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            if (this.func_195359_a(129, 16, 6, 54, mouseX, mouseY)) {
                ArrayList<IReorderingProcessor> tooltipList = new ArrayList<IReorderingProcessor>();
                if (fluidStack.getAmount() > 0) {
                    tooltipList.add(new TranslationTextComponent("productivebees.screen.fluid_level", new Object[]{new TranslationTextComponent(fluidStack.getTranslationKey()).getString(), fluidStack.getAmount() + "mb"}).func_241878_f());
                } else {
                    tooltipList.add(new TranslationTextComponent("productivebees.hive.tooltip.empty").func_241878_f());
                }
                this.func_238654_b_(matrixStack, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
            }
        });
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
            int energyAmount = handler.getEnergyStored();
            if (this.func_195359_a(-5, 16, 6, 54, mouseX, mouseY)) {
                ArrayList<IReorderingProcessor> tooltipList = new ArrayList<IReorderingProcessor>();
                tooltipList.add(new TranslationTextComponent("productivebees.screen.energy_level", new Object[]{energyAmount + "FE"}).func_241878_f());
                this.func_238654_b_(matrixStack, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
            }
        });
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            if (handler.getStackInSlot(0).func_190926_b() && this.func_195359_a(138, 16, 18, 18, mouseX, mouseY)) {
                ArrayList<IReorderingProcessor> tooltipList = new ArrayList<IReorderingProcessor>();
                tooltipList.add(new TranslationTextComponent("productivebees.centrifuge.tooltip.input_item").func_241878_f());
                this.func_238654_b_(matrixStack, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
            }
        });
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        assert (this.field_230706_i_ != null);
        if (((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE_POWERED);
        } else {
            this.field_230706_i_.func_110434_K().func_110577_a(GUI_TEXTURE);
        }
        this.func_238474_b_(matrixStack, this.getGuiLeft() - 13, this.getGuiTop(), 0, 0, this.getXSize() + 26, this.getYSize());
        int progress = (int)((float)((CentrifugeContainer)this.field_147002_h).tileEntity.recipeProgress * (24.0f / (float)((CentrifugeContainer)this.field_147002_h).tileEntity.getProcessingTime()));
        this.func_238474_b_(matrixStack, this.getGuiLeft() + 35, this.getGuiTop() + 35, 202, 52, progress + 1, 16);
        if (((CentrifugeContainer)this.field_147002_h).tileEntity instanceof PoweredCentrifugeTileEntity) {
            this.func_238474_b_(matrixStack, this.getGuiLeft() - 5, this.getGuiTop() + 17, 206, 0, 4, 52);
            ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityEnergy.ENERGY).ifPresent(handler -> {
                int energyAmount = handler.getEnergyStored();
                int energyLevel = (int)((float)energyAmount * 0.0052f);
                this.func_238474_b_(matrixStack, this.getGuiLeft() - 5, this.getGuiTop() + 17, 8, 17, 4, 52 - energyLevel);
            });
        }
        ((CentrifugeContainer)this.field_147002_h).tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            if (fluidStack.getAmount() > 0) {
                int fluidLevel = (int)((float)fluidStack.getAmount() * 0.0052f);
                FluidContainerUtil.setColors(fluidStack);
                FluidContainerUtil.drawTiledSprite(this.getGuiLeft() + 127, this.getGuiTop() + 69, 0, 4, fluidLevel, FluidContainerUtil.getSprite(fluidStack.getFluid().getAttributes().getStillTexture()), 16, 16, this.func_230927_p_());
                FluidContainerUtil.resetColor();
            }
        });
    }
}

