/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.network.PacketHandler;
import cy.jdkdigital.productivebees.network.packets.Messages;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Blocks;
import net.minecraft.block.CocoaBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="productivebees")
public class EventHandler {
    @SubscribeEvent
    public static void entityRightClicked(PlayerInteractEvent.EntityInteract entityInteract) {
        World world;
        ItemStack itemStack = entityInteract.getItemStack();
        Entity entity = entityInteract.getTarget();
        if (!itemStack.func_190926_b() && entity instanceof BeeEntity && (world = entityInteract.getWorld()) instanceof ServerWorld) {
            PlayerEntity player = entityInteract.getPlayer();
            BlockPos pos = entity.func_233580_cy_();
            Entity newBee = BeeHelper.itemInteract((BeeEntity)entity, itemStack, (ServerWorld)world, entity.serializeNBT(), player);
            if (newBee != null) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.2, 0.1, 0.2);
                world.func_184148_a(player, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_226134_ai_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                world.func_217376_c(newBee);
                entity.func_70106_y();
            }
        }
    }

    @SubscribeEvent
    public static void onUseItemFinish(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getResultStack();
        if (stack.func_77973_b().equals(Items.field_226638_pX_)) {
            LivingEntity entity = event.getEntityLiving();
            if (!entity.func_130014_f_().field_72995_K && entity.func_130014_f_().field_73012_v.nextBoolean()) {
                entity.curePotionEffects(stack);
            }
        }
    }

    @SubscribeEvent
    public static void cocoaBreakSpawn(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c().equals(Blocks.field_150375_by) && (Integer)event.getState().func_177229_b((Property)CocoaBlock.field_176501_a) == 2) {
            PlayerEntity player = event.getPlayer();
            World world = player.field_70170_p;
            if (world instanceof ServerWorld && player instanceof ServerPlayerEntity && (double)ProductiveBees.rand.nextFloat() < (Double)ProductiveBeesConfig.BEES.sugarbagBeeChance.get()) {
                ConfigurableBeeEntity bee = (ConfigurableBeeEntity)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).func_200721_a(world);
                BlockPos pos = event.getPos();
                if (bee != null && BeeReloadListener.INSTANCE.getData("productivebees:sugarbag") != null) {
                    bee.setBeeType("productivebees:sugarbag");
                    bee.setAttributes();
                    bee.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, bee.field_70177_z, bee.field_70125_A);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 0.2, 0.1, 0.2);
                    world.func_184133_a(player, pos, SoundEvents.field_226134_ai_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    world.func_217376_c((Entity)bee);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinServer(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity) {
            PacketHandler.sendBeeDataToPlayer(new Messages.BeeDataMessage(BeeReloadListener.INSTANCE.getData()), (ServerPlayerEntity)event.getEntity());
            int delay = (Integer)ProductiveBeesConfig.GENERAL.beeSyncDelay.get();
            if (delay > 0) {
                ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
                executorService.schedule(() -> PacketHandler.sendReindexCommandToPlayer(new Messages.ReindexMessage(), (ServerPlayerEntity)event.getEntity()), (long)delay, TimeUnit.SECONDS);
                executorService.shutdown();
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        ModifiableAttributeInstance attrib;
        Entity entity = event.getEntity();
        if (entity instanceof BeeEntity && (attrib = ((BeeEntity)entity).func_110148_a(Attributes.field_233819_b_)) != null && attrib.func_225505_c_().size() > 1) {
            for (AttributeModifier modifier : attrib.func_225505_c_()) {
                attrib.func_111124_b(modifier);
            }
            attrib.func_233769_c_(new AttributeModifier("Random spawn bonus", ProductiveBees.rand.nextGaussian() * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    @SubscribeEvent
    public static void onLootSetup(LootTableLoadEvent event) {
        if (event.getName().toString().contains("chests/village")) {
            event.getTable().getPool((String)"main").field_186453_a.add(ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)ModItems.STURDY_BEE_CAGE.get())).func_216086_a(4).func_216081_b());
        }
    }
}

