/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBeeEntity;
import cy.jdkdigital.productivebees.common.tileentity.SolitaryNestTileEntity;
import cy.jdkdigital.productivebees.common.tileentity.SugarbagNestTileEntity;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModTags;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;

public class SolitaryNestFeature
extends Feature<ReplaceBlockConfig> {
    private final float probability;
    private boolean placeOntop;

    public SolitaryNestFeature(float probability, Codec<ReplaceBlockConfig> configFactory) {
        this(probability, configFactory, false);
    }

    public SolitaryNestFeature(float probability, Codec<ReplaceBlockConfig> configFactory, boolean placeOntop) {
        super(configFactory);
        this.probability = probability;
        this.placeOntop = placeOntop;
    }

    public boolean place(@Nonnull ISeedReader world, @Nonnull ChunkGenerator chunkGenerator, @Nonnull Random rand, @Nonnull BlockPos blockPos, @Nonnull ReplaceBlockConfig featureConfig) {
        if (this.nestShouldNotGenerate(featureConfig) || rand.nextFloat() > this.probability) {
            return false;
        }
        blockPos = blockPos.func_177970_e(rand.nextInt(14)).func_177965_g(rand.nextInt(14));
        while (blockPos.func_177956_o() < 50 || !world.func_175623_d(blockPos)) {
            blockPos = blockPos.func_177984_a();
        }
        if (!this.placeOntop) {
            blockPos = blockPos.func_177977_b();
        }
        return this.placeNest(world, blockPos, featureConfig);
    }

    protected boolean nestShouldNotGenerate(ReplaceBlockConfig featureConfig) {
        return (Boolean)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get("enable_" + featureConfig.field_202458_b.func_177230_c().getRegistryName()).get() == false;
    }

    protected boolean placeNest(ISeedReader world, BlockPos pos, ReplaceBlockConfig featureConfig) {
        boolean match;
        BlockStateMatcher matcher = BlockStateMatcher.func_177638_a((Block)featureConfig.field_202457_a.func_177230_c());
        boolean bl = match = this.placeOntop ? matcher.test(world.func_180495_p(pos.func_177977_b())) : matcher.test(world.func_180495_p(pos));
        if (match) {
            ConfigurableBeeEntity newBee;
            Direction direction = featureConfig.field_202458_b.func_177230_c() instanceof WoodNest ? Direction.SOUTH : Direction.UP;
            for (Direction dir : BlockStateProperties.field_208155_H.func_177700_c()) {
                BlockPos blockPos = pos.func_177967_a(dir, 1);
                if (!world.func_175623_d(blockPos)) continue;
                direction = dir;
                break;
            }
            BlockState newState = (BlockState)featureConfig.field_202458_b.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction);
            if ((double)world.func_201674_k().nextFloat() < 0.001 && newState.func_235714_a_(ModTags.SOLITARY_OVERWORLD_NESTS) && newState.func_177230_c() instanceof WoodNest) {
                Direction facing = Direction.SOUTH;
                for (Direction dir : BlockStateProperties.field_208155_H.func_177700_c()) {
                    BlockPos blockPos = pos.func_177967_a(dir, 1);
                    if (!world.func_175623_d(blockPos)) continue;
                    if (!dir.equals((Object)Direction.DOWN) && !dir.equals((Object)Direction.UP)) {
                        facing = dir;
                    }
                    pos = blockPos;
                    break;
                }
                for (int i = 1; i <= 3; ++i) {
                    if (world.func_175623_d(pos.func_177981_b(i))) continue;
                    pos = pos.func_177981_b(i - 1);
                    break;
                }
                if (!world.func_175623_d(pos.func_177972_a(facing))) {
                    facing = facing.func_176734_d();
                }
                newState = (BlockState)((Block)ModBlocks.SUGARBAG_NEST.get()).func_176223_P().func_206870_a((Property)BeehiveBlock.field_226872_b_, (Comparable)facing);
            }
            boolean result = world.func_180501_a(pos, newState, 1);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof SolitaryNestTileEntity) {
                ProductiveBees.LOGGER.debug("Spawned nest at " + pos + " " + newState);
                newBee = ((SolitaryNest)world.func_180495_p(pos).func_177230_c()).getNestingBeeType((World)world.func_201672_e(), world.func_201672_e().func_226691_t_(pos));
                if (newBee instanceof BeeEntity) {
                    ((BeeEntity)newBee).func_70606_j(((BeeEntity)newBee).func_110138_aP());
                    newBee.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    ((SolitaryNestTileEntity)tileEntity).func_226962_a_((Entity)newBee, false, world.func_201674_k().nextInt(599));
                }
            } else if (tileEntity instanceof SugarbagNestTileEntity) {
                ProductiveBees.LOGGER.debug("Spawned sugarbag nest at " + pos + " " + newState);
                newBee = (ConfigurableBeeEntity)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).func_200721_a((World)world.func_201672_e());
                if (newBee != null) {
                    newBee.setBeeType("productivebees:sugarbag");
                    newBee.setAttributes();
                    newBee.func_70606_j(newBee.func_110138_aP());
                    newBee.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    ((SugarbagNestTileEntity)tileEntity).func_226962_a_((Entity)newBee, false, world.func_201674_k().nextInt(599));
                }
            }
            return result;
        }
        return false;
    }
}

