/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;

public class StructureSolitaryNestFeature
extends SolitaryNestFeature {
    private final float probability;
    private final int offsetSpan;

    public StructureSolitaryNestFeature(float probability, Codec<ReplaceBlockConfig> configFactory, int offsetSpan) {
        super(probability, configFactory);
        this.offsetSpan = offsetSpan;
        this.probability = probability;
    }

    @Override
    public boolean place(@Nonnull ISeedReader world, @Nonnull ChunkGenerator chunkGenerator, @Nonnull Random rand, @Nonnull BlockPos blockPos, @Nonnull ReplaceBlockConfig featureConfig) {
        block5: {
            if (this.nestShouldNotGenerate(featureConfig) || rand.nextFloat() > this.probability) {
                return false;
            }
            blockPos = blockPos.func_177970_e(rand.nextInt(14)).func_177965_g(rand.nextInt(14)).func_177981_b(50);
            BlockStateMatcher matcher = BlockStateMatcher.func_177638_a((Block)featureConfig.field_202457_a.func_177230_c());
            if (!matcher.test(world.func_180495_p(blockPos))) {
                for (Direction dir : BlockStateProperties.field_208157_J.func_177700_c()) {
                    if (!matcher.test(world.func_180495_p(blockPos.func_177967_a(dir, 2)))) continue;
                    blockPos = blockPos.func_177967_a(dir, 3);
                    break block5;
                }
                return false;
            }
        }
        blockPos = blockPos.func_177967_a(Direction.UP, world.func_201674_k().nextInt(this.offsetSpan));
        block1: for (Direction dir : BlockStateProperties.field_208157_J.func_177700_c()) {
            int i = 0;
            while (++i <= 5) {
                if (!world.func_175623_d(blockPos.func_177967_a(dir, i))) continue;
                blockPos = blockPos.func_177967_a(dir, i - 1);
                break block1;
            }
        }
        return this.placeNest(world, blockPos, featureConfig);
    }
}

