/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.handler.bee;

import com.google.common.collect.Lists;
import cy.jdkdigital.productivebees.common.tileentity.AdvancedBeehiveTileEntityAbstract;
import cy.jdkdigital.productivebees.handler.bee.IInhabitantStorage;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class InhabitantStorage
implements IInhabitantStorage,
INBTSerializable<CompoundNBT> {
    private List<AdvancedBeehiveTileEntityAbstract.Inhabitant> inhabitantList = Lists.newArrayList();

    @Override
    @Nonnull
    public List<AdvancedBeehiveTileEntityAbstract.Inhabitant> getInhabitants() {
        return this.inhabitantList;
    }

    @Override
    public void setInhabitants(List<AdvancedBeehiveTileEntityAbstract.Inhabitant> inhabitantList) {
        this.inhabitantList = inhabitantList;
        this.onContentsChanged();
    }

    @Override
    public void addInhabitant(AdvancedBeehiveTileEntityAbstract.Inhabitant inhabitant) {
        this.inhabitantList.add(inhabitant);
        this.onContentsChanged();
    }

    @Override
    public void clearInhabitants() {
        this.inhabitantList.clear();
        this.onContentsChanged();
    }

    @Override
    @Nonnull
    public ListNBT getInhabitantListAsListNBT() {
        ListNBT listNBT = new ListNBT();
        for (AdvancedBeehiveTileEntityAbstract.Inhabitant inhabitant : this.getInhabitants()) {
            CompoundNBT copyNbt = inhabitant.nbt.func_74737_b();
            copyNbt.func_82580_o("UUID");
            CompoundNBT tag = new CompoundNBT();
            tag.func_218657_a("EntityData", (INBT)copyNbt);
            tag.func_74768_a("TicksInHive", inhabitant.ticksInHive);
            if (inhabitant.flowerPos != null) {
                tag.func_218657_a("FlowerPos", (INBT)NBTUtil.func_186859_a((BlockPos)inhabitant.flowerPos));
            }
            tag.func_74768_a("MinOccupationTicks", inhabitant.minOccupationTicks);
            tag.func_74778_a("Name", inhabitant.localizedName);
            listNBT.add((Object)tag);
        }
        return listNBT;
    }

    @Override
    public void setInhabitantsFromListNBT(ListNBT list) {
        this.clearInhabitants();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            BlockPos flowerPos = tag.func_74764_b("FlowerPos") ? NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("FlowerPos")) : null;
            AdvancedBeehiveTileEntityAbstract.Inhabitant inhabitant = new AdvancedBeehiveTileEntityAbstract.Inhabitant(tag.func_74775_l("EntityData"), tag.func_74762_e("TicksInHive"), tag.func_74762_e("MinOccupationTicks"), flowerPos, tag.func_74779_i("Name"));
            this.addInhabitant(inhabitant);
        }
    }

    public CompoundNBT serializeNBT() {
        ListNBT listNBT = this.getInhabitantListAsListNBT();
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Inhabitants", (INBT)listNBT);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.clearInhabitants();
        ListNBT list = nbt.func_150295_c("Inhabitants", 10);
        this.setInhabitantsFromListNBT(list);
        this.onLoad();
    }

    protected void onLoad() {
    }

    @Override
    public void onContentsChanged() {
    }
}

