/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.init;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.gen.feature.CavernSolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.OreSolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.ReedSolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.StructureSolitaryNestFeature;
import cy.jdkdigital.productivebees.gen.feature.WoodSolitaryNestFeature;
import cy.jdkdigital.productivebees.init.ModConfiguredFeatures;
import java.util.function.Supplier;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="productivebees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"productivebees");
    public static final RegistryObject<Feature<ReplaceBlockConfig>> SAND_NEST = ModFeatures.register("sand_nest", () -> new SolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> SNOW_NEST = ModFeatures.register("snow_nest", () -> new SolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_, true));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> STONE_NEST = ModFeatures.register("stone_nest", () -> new SolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> COARSE_DIRT_NEST = ModFeatures.register("coarse_dirt_nest", () -> new SolitaryNestFeature(0.3f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> GRAVEL_NEST = ModFeatures.register("gravel_nest", () -> new SolitaryNestFeature(0.15f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> SLIMY_NEST = ModFeatures.register("slimy_nest", () -> new SolitaryNestFeature(0.1f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_, true));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> SUGAR_CANE_NEST = ModFeatures.register("sugar_cane_nest", () -> new ReedSolitaryNestFeature(0.7f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> GLOWSTONE_NEST = ModFeatures.register("glowstone_nest", () -> new CavernSolitaryNestFeature(0.9f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_, false));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> NETHER_QUARTZ_NEST = ModFeatures.register("nether_quartz_nest", () -> new OreSolitaryNestFeature(0.5f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_, 10, 70));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> NETHER_QUARTZ_NEST_HIGH = ModFeatures.register("nether_quartz_nest_high", () -> new OreSolitaryNestFeature(1.0f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_, 70, 100));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> NETHER_FORTRESS_NEST = ModFeatures.register("nether_fortress_nest", () -> new StructureSolitaryNestFeature(0.9f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_, 35));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> SOUL_SAND_NEST = ModFeatures.register("soul_sand_nest", () -> new CavernSolitaryNestFeature(0.1f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_, true));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> END_NEST = ModFeatures.register("end_nest", () -> new SolitaryNestFeature(0.15f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> OBSIDIAN_PILLAR_NEST = ModFeatures.register("obsidian_pillar_nest", () -> new StructureSolitaryNestFeature(1.0f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_, 25));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> BUMBLE_BEE_NEST = ModFeatures.register("bumble_bee_nest", () -> new SolitaryNestFeature(0.01f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> OAK_WOOD_NEST_FEATURE = ModFeatures.register("oak_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> SPRUCE_WOOD_NEST_FEATURE = ModFeatures.register("spruce_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> BIRCH_WOOD_NEST_FEATURE = ModFeatures.register("birch_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> DARK_OAK_WOOD_NEST_FEATURE = ModFeatures.register("dark_oak_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> JUNGLE_WOOD_NEST_FEATURE = ModFeatures.register("jungle_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.1f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));
    public static final RegistryObject<Feature<ReplaceBlockConfig>> ACACIA_WOOD_NEST_FEATURE = ModFeatures.register("acacia_wood_nest_feature", () -> new WoodSolitaryNestFeature(0.05f, (Codec<ReplaceBlockConfig>)ReplaceBlockConfig.field_236604_a_));

    private static <E extends IFeatureConfig> RegistryObject<Feature<E>> register(String name, Supplier<Feature<E>> supplier) {
        return FEATURES.register(name, supplier);
    }

    public static void registerFeatures(BiomeLoadingEvent event) {
        Biome.Category category = event.getCategory();
        if (category.equals((Object)Biome.Category.DESERT)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.SAND_NEST_FEATURE);
        } else if (category.equals((Object)Biome.Category.SAVANNA) || category.equals((Object)Biome.Category.TAIGA)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.COARSE_DIRT_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SPRUCE_WOOD_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.ACACIA_WOOD_NEST_FEATURE);
        } else if (category.equals((Object)Biome.Category.JUNGLE)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.JUNGLE_WOOD_NEST_FEATURE);
        } else if (category.equals((Object)Biome.Category.FOREST)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.OAK_WOOD_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.DARK_OAK_WOOD_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.BIRCH_WOOD_NEST_FEATURE);
        } else if (category.equals((Object)Biome.Category.EXTREME_HILLS)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.STONE_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.SNOW_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.SNOW_NEST_BLOCK_FEATURE);
        } else if (category.equals((Object)Biome.Category.SWAMP)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.SLIMY_NEST_FEATURE);
        } else if (category.equals((Object)Biome.Category.PLAINS)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.BUMBLE_BEE_NEST_FEATURE);
        } else if (category.equals((Object)Biome.Category.NETHER)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ModConfiguredFeatures.GLOWSTONE_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ModConfiguredFeatures.NETHER_QUARTZ_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.NETHER_QUARTZ_NEST_HIGH_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.NETHER_FORTRESS_NEST_FEATURE);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ModConfiguredFeatures.SOUL_SAND_NEST_FEATURE);
        } else if (category.equals((Object)Biome.Category.RIVER) || category.equals((Object)Biome.Category.BEACH)) {
            if (event.getClimate().field_242462_d != Biome.TemperatureModifier.FROZEN) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.GRAVEL_NEST_FEATURE);
            }
        } else if (category.equals((Object)Biome.Category.THEEND)) {
            if (event.getName().func_110623_a().equals("the_end")) {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.OBSIDIAN_PILLAR_NEST_FEATURE);
            } else {
                event.getGeneration().func_242513_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ModConfiguredFeatures.END_NEST_FEATURE);
            }
        }
        if (!category.equals((Object)Biome.Category.THEEND) && !category.equals((Object)Biome.Category.NETHER)) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, ModConfiguredFeatures.SUGAR_CANE_NEST_FEATURE);
        }
    }
}

